<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tools/src/M3Scanner.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tools/src/M3Scanner.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: M3Scanner.i3                                          

<P><PRE>INTERFACE <interface><A HREF="M3Scanner.m3">M3Scanner</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="M3Token.i3">M3Token</A>;

TYPE
  T = OBJECT
    token        : M3Token.T := M3Token.T.Comment;
    start        : CARDINAL  := 0;
    length       : CARDINAL  := 0;
    offset       : CARDINAL  := 0;
    line         : CARDINAL  := 0;
    column       : CARDINAL  := 0;
    msg          : TEXT      := NIL;
    buffer       : Buf       := NIL;
  METHODS
    next ();
  END;

  Buf = REF ARRAY OF CHAR;

TYPE
  <A HREF="M3Scanner.m3#Default">Default</A> &lt;: T OBJECT METHODS
    initFromRd  (source        : Rd.T;
                 skip_comments := TRUE;
                 split_pragmas := TRUE): T;
    initFromBuf (buf           : Buf;
                 skip_comments := TRUE;
                 split_pragmas := TRUE): T;
  END;

END M3Scanner.
</PRE><P>
An <CODE>M3Scanner.T</CODE>, or scanner, parses a stream of characters and
returns a stream of Modula-3 tokens. If <CODE>s</CODE> is a scanner, each
call <CODE>s.next()</CODE> sets the values of <CODE>s</CODE>'s fields to correspond to
the next token in the stream.
   <P>
The fields of a scanner are not to be modified by its client.
<P>
<CODE>s.token</CODE> is the class of the token.
<P>
In <CODE>s.buffer[s.start .. s.start+s.length-1]</CODE> are the characters
that comprise the token.
<P>
<CODE>s.offset</CODE> is the character offset of the token relative to the
beginning of the stream.  The first character of the stream is
at offset zero.
<P>
<CODE>s.line</CODE> is the line where the token occured relative
to the beginning of the stream.   The first line is one.
<P>
<CODE>s.column</CODE> is the character offset of the beginning of the token
within the line that contains it.  The first column is zero.
<P>
<CODE>s.buffer</CODE> contains the source being scanned.  Modifying its contents
may perturb the token stream or cause a checked runtime error.
<P>
<CODE>s.msg</CODE> describes the error that caused the <CODE>Error</CODE> token to be
returned.
<P>
The scanner returned by <CODE>NEW(Default).initFromRd(rd)</CODE> will read the
entire contents of <CODE>rd</CODE> into its buffer and initialize
the scanner as a zero-length comment at offset zero.
<P>
The scanner returned by <CODE>NEW(Default).initFromBuf(buf)</CODE> will use
<CODE>buf</CODE> as its buffer and initialize the scanner as a zero-length
comment at offset zero.
<P>
If <CODE>skip_comments</CODE> is <CODE>TRUE</CODE>, outer-level comments will be returned
as tokens.  Otherwise, comments are ignored.
<P>
If <CODE>split_pragmas</CODE> is <CODE>TRUE</CODE>, the contents of pragmas will be scanned
and returned as a stream of tokens between <CODE>Begin_pragma</CODE> and
<CODE>End_pragma</CODE> tokens.  If <CODE>split_pragmas</CODE> is false, the entire pragma
is returned in a single <CODE>Begin_pragma</CODE> token.


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
