<HTML>
<HEAD>
<TITLE>SRC Modula-3: metasyn/src/Builder.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>metasyn/src/Builder.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Builder.i3">Builder</A></implements></module>;
IMPORT <A HREF="../../synex/src/SynParse.i3">SynParse</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="MetaParser.i3">MetaParser</A>, <A HREF="../../text/src/Text.i3">Text</A>;

TYPE
  ClauseExtends =
    SynParse.Tree BRANDED OBJECT
    extend, iter, iterPosPresent: BOOLEAN;
    iterPos: INTEGER;
  END;
  StringAction =
    SynParse.Action BRANDED OBJECT
    text: TEXT;
  END;
  IntegerAction =
    SynParse.Action BRANDED OBJECT
    int: INTEGER;
  END;
  ProcAction =
    SynParse.Action BRANDED OBJECT
    proc: SynParse.Action;
  END;

REVEAL
  <A NAME="GramInfo">GramInfo</A> =
    GramInfoBase BRANDED OBJECT
    clauseList: MetaParser.ClauseList;
    oldKeySet, newKeySet: SynScan.KeywordSet;
  END;
</PRE> symbol table 

<P>
<P><PRE>TYPE
  H = MetaParser.ActionProcEntry ;

VAR
  (* Sample Action Table *)
   sourceTable := ARRAY [0..27] OF MetaParser.ActionProcEntry
                    { H { &quot;ClauseList&quot;            , ClauseList             },
                      H { &quot;ClauseExtendsIterNoPos&quot;, ClauseExtendsIterNoPos },
                      H { &quot;ClauseExtendsIterPos&quot;  , ClauseExtendsIterPos   },
                      H { &quot;ClauseExtendsIter&quot;     , ClauseExtendsIter      },
                      H { &quot;ClauseExtendsIter&quot;     , ClauseExtendsIter      },
                      H { &quot;ClauseExtendsChoice&quot;   , ClauseExtendsChoice    },
                      H { &quot;ClauseExtendsYes&quot;      , ClauseExtendsYes       },
                      H { &quot;ClauseExtendsNo&quot;       , ClauseExtendsNo        },
                      H { &quot;Storage&quot;               , Storage                },
                      H { &quot;Ide&quot;                   , Ide2                   },
                      H { &quot;Name&quot;                  , Name2                  },
                      H { &quot;GramIde&quot;               , GramIde2               },
                      H { &quot;GramString&quot;            , GramString2            },
                      H { &quot;GramKeyIde&quot;            , GramKeyIde2            },
                      H { &quot;GramKeyName&quot;           , GramKeyName2           },
                      H { &quot;GramKeyInt&quot;            , GramKeyInt2            },
                      H { &quot;GramKeyEof&quot;            , GramKeyEof2            },
                      H { &quot;GramKeyReal&quot;           , GramKeyReal2           },
                      H { &quot;GramKeyChar&quot;           , GramKeyChar2           },
                      H { &quot;GramKeyString&quot;         , GramKeyString2         },
                      H { &quot;GramExpSequence&quot;       , GramExpSequence        },
                      H { &quot;GramExpChoice&quot;         , GramExpChoice          },
                      H { &quot;GramExpIterPos&quot;        , GramExpIterPos         },
                      H { &quot;GramExpIterNoPos&quot;      , GramExpIterNoPos       },
                      H { &quot;GramExpIter&quot;           , GramExpIter            },
                      H { &quot;GramExpBase&quot;           , GramExpBase            },
                      H { &quot;GramExpParens&quot;         , GramExpParens          },
                      H { &quot;GramList&quot;              , GramList               } };

PROCEDURE <A NAME="LinkIn"><procedure>LinkIn</procedure></A>(table : MetaParser.ActionTable ) =
BEGIN
  MetaParser.TableFromArray(sourceTable,table);
END LinkIn;
</PRE> error printing routine 

<P>
<P>
<P> <CODE>getter</CODE>routines 
<PRE>PROCEDURE <A NAME="GClauseList"><procedure>GClauseList</procedure></A>(p: SynParse.T; loc: INTEGER): MetaParser.ClauseList
    RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE p.stack[loc] OF
    | MetaParser.ClauseList(node) =&gt; RETURN node ;
    ELSE
    END;
    MetaParser.TypeError(&quot;clause-list&quot;, p.stack[loc]);
    &lt;*ASSERT FALSE*&gt;
  END GClauseList;

PROCEDURE <A NAME="GClauseExtends"><procedure>GClauseExtends</procedure></A>(p: SynParse.T; loc: INTEGER): ClauseExtends
    RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE p.stack[loc] OF
    | NULL=&gt;
    | ClauseExtends(node) =&gt; RETURN node ;
    ELSE
    END;
    MetaParser.TypeError(&quot;clause-extends&quot;, p.stack[loc]);
    &lt;*ASSERT FALSE*&gt;
  END GClauseExtends;

PROCEDURE <A NAME="GIdeNode"><procedure>GIdeNode</procedure></A>(p: SynParse.T; loc: INTEGER): MetaParser.TextNode
    RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE p.stack[loc] OF
    | NULL=&gt;
    | MetaParser.TextNode(node) =&gt; RETURN node ;
    ELSE
    END;
    MetaParser.TypeError(&quot;n ide-node&quot;, p.stack[loc]);
    &lt;*ASSERT FALSE*&gt;
  END GIdeNode;

PROCEDURE <A NAME="GGrammar"><procedure>GGrammar</procedure></A>(p: SynParse.T; loc: INTEGER): SynParse.Grammar
    RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE p.stack[loc] OF
    | NULL=&gt;
    | SynParse.Grammar(node) =&gt; RETURN node ;
    ELSE
    END;
    MetaParser.TypeError(&quot;grammar&quot;,p.stack[loc]);
    &lt;*ASSERT FALSE*&gt;
  END GGrammar;

PROCEDURE <A NAME="GGramList"><procedure>GGramList</procedure></A>(p: SynParse.T; loc: INTEGER): SynParse.GrammarList
    RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE p.stack[loc] OF
    | SynParse.GrammarList(node) =&gt; RETURN node ;
    ELSE
    END;
    MetaParser.TypeError(&quot;grammar list&quot;,p.stack[loc]);
    &lt;*ASSERT FALSE*&gt;
  END GGramList;

PROCEDURE <A NAME="GArgs"><procedure>GArgs</procedure></A>(p: SynParse.T; loc: INTEGER):SynParse.Args
    RAISES {SynParse.Fail}=
  VAR
    n: INTEGER;
    args: SynParse.Tree;
    ret: SynParse.Args;
  BEGIN
    n:= 0;
    args := p.stack[loc];
    LOOP
      TYPECASE args OF
      | NULL=&gt; EXIT
      | Params(node) =&gt; INC(n); args:=node.rest;
      ELSE &lt;*ASSERT FALSE*&gt;
      END;
    END;
    ret := NEW(SynParse.Args,n);
    args := p.stack[loc];
    FOR i := 0 TO n-1 DO
      TYPECASE args OF
      | NULL =&gt;
      | Params(node) =&gt;
          ret^[i] := MetaParser.XInt(node.first);
          args:=node.rest;
      ELSE &lt;*ASSERT FALSE*&gt;
      END;
    END;
    RETURN ret;
  END GArgs;

PROCEDURE <A NAME="Ide"><procedure>Ide</procedure></A>(self: SynParse.Identifier; p: SynParse.T; name: TEXT;
              READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN NEW(MetaParser.TextNode, text:=name);
  END Ide;

PROCEDURE <A NAME="Ide2"><procedure>Ide2</procedure></A>(&lt;*UNUSED*&gt; self: SynParse.Action;
               p: SynParse.T; base: INTEGER;
               READONLY info: SynLocation.Info): SynParse.Tree
               RAISES {SynParse.Fail}=
  BEGIN
    RETURN
      Ide(NIL, p, MetaParser.GText(p, base+1), info);
  END Ide2;

PROCEDURE <A NAME="Name"><procedure>Name</procedure></A>(self: SynParse.Name; p: SynParse.T; name: TEXT;
              READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN NEW(MetaParser.TextNode, text:=name);
  END Name;

PROCEDURE <A NAME="Name2"><procedure>Name2</procedure></A>(self: SynParse.Action;
               p: SynParse.T; base: INTEGER;
               READONLY info: SynLocation.Info): SynParse.Tree
               RAISES {SynParse.Fail}=
  BEGIN
    RETURN
      Name(NIL, p, MetaParser.GText(p, base+1), info);
  END Name2;

PROCEDURE <A NAME="Grammar"><procedure>Grammar</procedure></A>(self:SynParse.Action; p: SynParse.T; base: INTEGER;
                  READONLY info: SynLocation.Info)
                  : SynParse.Tree
                  RAISES {SynParse.Fail} =
  BEGIN
    (* -- check that names in list are unique, whether extensions or not. *)
    RETURN GClauseList(p, base+1);
  END Grammar;

PROCEDURE <A NAME="ClauseList"><procedure>ClauseList</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                     READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  VAR
    clauseExtends: ClauseExtends;
  BEGIN
    clauseExtends:=GClauseExtends(p, base+2);

    RETURN
      NEW(MetaParser.ClauseList, location:=SynLocation.NewLineLocation(info),
          ide:=GIdeNode(p, base+1),
          args:= GArgs(p, base+5),
          extend:=clauseExtends.extend,
          extendIter:=clauseExtends.iter,
          iterPosPresent:=clauseExtends.iterPosPresent,
          iterPos:=clauseExtends.iterPos,
          gram:=GGrammar(p, base+3),
          rest:=GClauseList(p, base+4));
  END ClauseList;

PROCEDURE <A NAME="ClauseExtendsChoice"><procedure>ClauseExtendsChoice</procedure></A>(self: SynParse.Action; p: SynParse.T;
                              base: INTEGER;
                              READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN NEW(ClauseExtends, extend:=TRUE, iter:=FALSE,
               iterPosPresent:=FALSE, iterPos:=0);
  END ClauseExtendsChoice;

PROCEDURE <A NAME="ClauseExtendsIterPos"><procedure>ClauseExtendsIterPos</procedure></A>(self: SynParse.Action; p: SynParse.T;
                               base: INTEGER;
                               READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(ClauseExtends, extend:=TRUE, iter:=TRUE,
               iterPosPresent:=TRUE,
               iterPos:=MetaParser.GInt(p, base+3));
  END ClauseExtendsIterPos;

PROCEDURE <A NAME="ClauseExtendsIterNoPos"><procedure>ClauseExtendsIterNoPos</procedure></A>(self: SynParse.Action; p: SynParse.T;
                                 base: INTEGER;
                                 READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN NEW(ClauseExtends, extend:=TRUE, iter:=TRUE,
               iterPosPresent:=FALSE, iterPos:=0);
  END ClauseExtendsIterNoPos;

PROCEDURE <A NAME="ClauseExtendsIter"><procedure>ClauseExtendsIter</procedure></A>(self: SynParse.Action; p: SynParse.T;
                            base: INTEGER;
                            READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN p.stack[base+2];
  END ClauseExtendsIter;

PROCEDURE <A NAME="ClauseExtendsNo"><procedure>ClauseExtendsNo</procedure></A>(self: SynParse.Action; p: SynParse.T;
                          base: INTEGER;
                          READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN NEW(ClauseExtends, extend:=FALSE, iter:=FALSE);
  END ClauseExtendsNo;

PROCEDURE <A NAME="ClauseExtendsYes"><procedure>ClauseExtendsYes</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                           READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN p.stack[base+1];
  END ClauseExtendsYes;

  (* ****************************** *)
  (*  teminals of client grammar    *)
  (* ****************************** *)

PROCEDURE <A NAME="GramIdeCm"><procedure>GramIdeCm</procedure></A>(name: TEXT;args: SynParse.Args;
                    READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN NEW(SynParse.NonTerminal,
               location:=SynLocation.NewLineLocation(info),
               args:=args,
               name:=name);
  END GramIdeCm;

PROCEDURE <A NAME="GramIde2"><procedure>GramIde2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                   READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramIdeCm(MetaParser.GText(p, base+1),GArgs(p, base+2),info);
  END GramIde2;

  PROCEDURE <A NAME="GramString"><procedure>GramString</procedure></A>(self: SynParse.QuotedString; p: SynParse.T;
        string: TEXT;
	READONLY info: SynLocation.Info)
      : SynParse.Tree RAISES {SynParse.Fail} =
    VAR name: TEXT;
    BEGIN
      IF Text.Length(string)=0 THEN
	SynParse.Fault(p, &quot;Invalid token: \&quot;\&quot;&quot;)
      END;
      IF (Text.Length(string)=1) AND
          SynScan.IsDelimiter(p.Scanner(), Text.GetChar(string,0)) THEN
	RETURN
	  NEW(SynParse.GivenDelimiter, location:=SynLocation.NewLineLocation(info),
	    delim:=Text.GetChar(string,0));
      ELSIF (Text.Length(string)&gt;1) AND (Text.GetChar(string,0)='~') THEN
	name := Text.Sub(string, 1, Text.Length(string)-1);
        IF SynScan.IsIdentifier(p.Scanner(), name) THEN
          RETURN
            NEW(SynParse.GivenName, location:=SynLocation.NewLineLocation(info),
	      text:=name);
        ELSE
	  SynParse.Fault(p, &quot;Invalid token: &quot;&amp; string);
        &lt;*ASSERT FALSE*&gt;
        END;
      ELSIF SynScan.IsIdentifier(p.Scanner(), string) THEN
        RETURN
	    NEW(SynParse.GivenKeyword,
                location:=SynLocation.NewLineLocation(info),
                key:=string);
      ELSE
	SynParse.Fault(p, &quot;Invalid token: &quot;&amp; string);
        &lt;*ASSERT FALSE*&gt;
      END;
    END GramString;
</PRE><P>
PROCEDURE GramString(self: SynParse.QuotedString; 
                     p: SynParse.T; string: String.T;
                     READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    IF String.Length(string)=0 THEN 
      SynParse.Fault(p, <CODE>Invalid token: \</CODE>\<CODE></CODE>) 
    END;
    IF (String.Length(string)=1) AND SynScan.IsDelimiter(p.sc, string[0]) THEN
      RETURN 
        NEW(SynParse.GivenDelimiter, location:=SynLocation.NewLineLocation(info),
            delim:=string[0]);
      (* don't initialise build, take default action ( i.e. put 
         NIL onto stack )
                             
    <PRE>ELSIF SynScan.IsIdentifier(p.sc, string) THEN
      RETURN
        (* Fill the key field later; store it in ide for now. *)
        NEW(GivenNamedKeyword, location:=SynLocation.NewLineLocation(info),
            ide:=String.ToText(string), key:=NIL);
      (* don't initialise build, take default action ( i.e. put
         NIL onto stack *)
    ELSE SynParse.Fault(p, &quot;Invalid token: &quot;&amp;String.ToText(string));
    END;
  END GramString;
*)

PROCEDURE <A NAME="GramString2"><procedure>GramString2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                   READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramString(NIL,p, MetaParser.GText(p, base+1),info);
  END GramString2;

PROCEDURE <A NAME="GramKeyIde"><procedure>GramKeyIde</procedure></A>(self: SynParse.GivenKeyword; p: SynParse.T;
                     READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Identifier,
               location:=SynLocation.NewLineLocation(info),
               Build:=MetaParser.IdentifierToTree);
  END GramKeyIde;

PROCEDURE <A NAME="GramKeyIde2"><procedure>GramKeyIde2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree
    RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramKeyIde(NIL, p, info);
  END GramKeyIde2 ;

PROCEDURE <A NAME="GramKeyName"><procedure>GramKeyName</procedure></A>(self: SynParse.GivenKeyword; p: SynParse.T;
                     READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Name,
               location:=SynLocation.NewLineLocation(info),
               Build:=MetaParser.NameToTree);
  END GramKeyName;

PROCEDURE <A NAME="GramKeyName2"><procedure>GramKeyName2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree
    RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramKeyName(NIL, p, info);
  END GramKeyName2 ;

PROCEDURE <A NAME="GramKeyInt"><procedure>GramKeyInt</procedure></A>(self: SynParse.GivenKeyword; p: SynParse.T;
                     READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Integer,
               location:=SynLocation.NewLineLocation(info),
               Build:=MetaParser.IntegerToTree);
  END GramKeyInt;

PROCEDURE <A NAME="GramKeyInt2"><procedure>GramKeyInt2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree
    RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramKeyInt(NIL, p, info);
  END GramKeyInt2 ;

PROCEDURE <A NAME="GramKeyReal"><procedure>GramKeyReal</procedure></A>(self: SynParse.GivenKeyword; p: SynParse.T;
                      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Real,
               location:=SynLocation.NewLineLocation(info),
               Build:=MetaParser.RealToTree);
  END GramKeyReal;

PROCEDURE <A NAME="GramKeyReal2"><procedure>GramKeyReal2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree
    RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramKeyReal(NIL, p, info);
  END GramKeyReal2 ;

PROCEDURE <A NAME="GramKeyChar"><procedure>GramKeyChar</procedure></A>(self: SynParse.GivenKeyword; p: SynParse.T;
                      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.QuotedChar,
               location:=SynLocation.NewLineLocation(info),
               Build:=MetaParser.CharToTree);
  END GramKeyChar;

PROCEDURE <A NAME="GramKeyChar2"><procedure>GramKeyChar2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree
    RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramKeyChar(NIL, p, info);
  END GramKeyChar2 ;

PROCEDURE <A NAME="GramKeyString"><procedure>GramKeyString</procedure></A>(self: SynParse.GivenKeyword; p: SynParse.T;
                        READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.QuotedString,
               location:=SynLocation.NewLineLocation(info),
               Build:=MetaParser.StringToTree);
  END GramKeyString;

PROCEDURE <A NAME="GramKeyString2"><procedure>GramKeyString2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree
    RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramKeyString(NIL, p, info);
  END GramKeyString2 ;

PROCEDURE <A NAME="GramKeyEof"><procedure>GramKeyEof</procedure></A>(self: SynParse.GivenKeyword; p: SynParse.T;
                     READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Eof,
               location:=SynLocation.NewLineLocation(info));
  END GramKeyEof;

PROCEDURE <A NAME="GramKeyEof2"><procedure>GramKeyEof2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree
    RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      GramKeyEof(NIL, p, info);
  END GramKeyEof2 ;

  (* ************************************ *)

PROCEDURE <A NAME="GramActionString"><procedure>GramActionString</procedure></A>(self: SynParse.Action;
                           p: SynParse.T; base: INTEGER;
                           READONLY info: SynLocation.Info)
                           :SynParse.Tree=
  BEGIN
    RETURN
      MetaParser.TextToTree(NIL, p, NARROW(self,StringAction).text,info);
  END GramActionString;

PROCEDURE <A NAME="GramActionProc"><procedure>GramActionProc</procedure></A>(self: SynParse.Action;
                         p: SynParse.T; base: INTEGER;
                         READONLY info: SynLocation.Info)
                         :SynParse.Tree RAISES {SynParse.Fail}=
  BEGIN
    RETURN
      NARROW(self,ProcAction).proc;
  END GramActionProc;

PROCEDURE <A NAME="GramActionInteger"><procedure>GramActionInteger</procedure></A>(self: SynParse.Action;
                           p: SynParse.T; base: INTEGER;
                           READONLY info: SynLocation.Info)
                           :SynParse.Tree=
  BEGIN
    RETURN
      MetaParser.IntegerToTree(NIL, p, NARROW(self,IntegerAction).int,info);
  END GramActionInteger;

  (* **************************** *)

PROCEDURE <A NAME="GramList"><procedure>GramList</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                   READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      NEW(SynParse.GrammarList,
          location:=SynLocation.NewLineLocation(info),
          first:=p.stack[base+1],
          rest:=GGramList(p, base+2));
  END GramList;

PROCEDURE <A NAME="Storage"><procedure>Storage</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                  READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Storage,
               location:=SynLocation.NewLineLocation(info),
               position:=MetaParser.GInt(p, base+3),
               item:=GGrammar(p, base+1));
  END Storage;

PROCEDURE <A NAME="GramExpSequence"><procedure>GramExpSequence</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                          READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Sequence,
               location:=SynLocation.NewLineLocation(info),
               items:=GGramList(p, base+1));
  END GramExpSequence;

PROCEDURE <A NAME="GramExpChoice"><procedure>GramExpChoice</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                        READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Choice,
               location:=SynLocation.NewLineLocation(info),
               choice:=GGramList(p, base+1));
  END GramExpChoice;

PROCEDURE <A NAME="GramExpParens"><procedure>GramExpParens</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                        READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN p.stack[base+6];
  END GramExpParens;

PROCEDURE <A NAME="GramExpBase"><procedure>GramExpBase</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN p.stack[base+1];
  END GramExpBase;

PROCEDURE <A NAME="GramExpIter"><procedure>GramExpIter</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN p.stack[base+5];
  END GramExpIter;

PROCEDURE <A NAME="GramExpIterNoPos"><procedure>GramExpIterNoPos</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                           READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Iter, location:=SynLocation.NewLineLocation(info),
               base:=GGrammar(p, base+1),
               iter:=GGrammar(p, base+3),
               accum:=FALSE,
               accumPosition:=0);
  END GramExpIterNoPos;

PROCEDURE <A NAME="GramExpIterPos"><procedure>GramExpIterPos</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                         READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN NEW(SynParse.Iter, location:=SynLocation.NewLineLocation(info),
               base:= GGrammar(p, base+1),
               iter:= GGrammar(p, base+3),
               accum:=TRUE,
               accumPosition:=MetaParser.GInt(p, base+4));
  END GramExpIterPos;

  (* added following procedure for generating constant strings *)
PROCEDURE <A NAME="ActionString"><procedure>ActionString</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                       READONLY info: SynLocation.Info):
                       SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      NEW(StringAction,
          location := SynLocation.NewLineLocation(info),
          grammar := GGrammar(p, base+1),
          text := MetaParser.GText(p, base+3),
          Build := GramActionString);
  END ActionString;

  (* added following procedure for generating constant integers *)
PROCEDURE <A NAME="ActionInteger"><procedure>ActionInteger</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                       READONLY info: SynLocation.Info):
                       SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      NEW(IntegerAction,
          location := SynLocation.NewLineLocation(info),
          grammar := GGrammar(p, base+1),
          int := MetaParser.GInt(p, base+3),
          Build := GramActionInteger);
  END ActionInteger;

PROCEDURE <A NAME="LookupAction"><procedure>LookupAction</procedure></A>(p: SynParse.T; base: INTEGER;
                       READONLY info: SynLocation.Info): ActionProc
                       RAISES {SynParse.Fail}=
  VAR
    name : TEXT ;
    ref: REFANY;
  BEGIN
    (* AK look up action NEW *)
    name := MetaParser.GText(p, base+3);
    IF actionTable.get(name,ref) THEN
      TYPECASE ref OF
      | REF ActionProc(node) =&gt; RETURN node^;
      ELSE
        SynWr.Text(SynWr.out, &quot;Not an action: &quot;&amp;name&amp;&quot; &quot;, loud:=TRUE);
        SynLocation.PrintLocation(SynWr.out, SynLocation.NewLineLocation(info));
        SynWr.Text(SynWr.out, &quot;\n&quot;, loud:=TRUE);
        SynWr.Flush(SynWr.out, loud:=TRUE);
        RAISE SynParse.Fail;
      END;

    ELSE
      SynWr.Text(SynWr.out, &quot;Unknown action: &quot;&amp;name&amp;&quot; &quot;, loud:=TRUE);
      SynLocation.PrintLocation(SynWr.out, SynLocation.NewLineLocation(info));
      SynWr.Text(SynWr.out, &quot;\n&quot;, loud:=TRUE);
      SynWr.Flush(SynWr.out, loud:=TRUE);
      RAISE SynParse.Fail;
    END;
  END LookupAction;

PROCEDURE <A NAME="AntiquotedAction"><procedure>AntiquotedAction</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                           READONLY info: SynLocation.Info):
                           SynParse.Tree RAISES {SynParse.Fail} =
  BEGIN
    RETURN
      NEW(ProcAction,
          location := SynLocation.NewLineLocation(info),
          grammar:= GGrammar(p, base+1),
          proc := NEW(SynParse.Action,
                      location := NIL,
                      grammar := NIL,
                      Build := LookupAction(p, base,info)),
          Build := GramActionProc);
  END AntiquotedAction;

  (* following procedure for generating actions *)
PROCEDURE <A NAME="Action"><procedure>Action</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                 READONLY info: SynLocation.Info):
                 SynParse.Tree RAISES {SynParse.Fail} =

  BEGIN
    RETURN
      NEW(SynParse.Action,
          location := SynLocation.NewLineLocation(info),
          grammar:= GGrammar(p, base+1),
          Build := LookupAction(p, base, info));
  END Action;

  PROCEDURE <A NAME="Single"><procedure>Single</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
	READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN p.stack[base+1];
    END Single;

  PROCEDURE <A NAME="GramExp"><procedure>GramExp</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
	READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN p.stack[base+2];
    END GramExp;

PROCEDURE <A NAME="ConsParam"><procedure>ConsParam</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
               READONLY info: SynLocation.Info): SynParse.Tree=
  BEGIN
    RETURN NEW(Params,
          location := SynLocation.NewLineLocation(info),
          first:=p.stack[base+1], rest:=p.stack[base+2]);
  END ConsParam;

BEGIN

END Builder.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
