<HTML>
<HEAD>
<TITLE>SRC Modula-3: metasyn/src/Constructor.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>metasyn/src/Constructor.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
MODULE <module><implements><A HREF="Constructor.i3">Constructor</A></implements></module>;

IMPORT  <A HREF="../../synloc/src/SynWr.i3">SynWr</A>,<A HREF="../../synex/src/SynParse.i3">SynParse</A>,<A HREF="Builder.i3">Builder</A>,<A HREF="MetaParser.i3">MetaParser</A>,<A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

TYPE
  H = MetaParser.ActionProcEntry ;

VAR
   sourceTable := ARRAY [0..4] OF MetaParser.ActionProcEntry
                    { H { &quot;select1&quot;, Fetch1 }  ,
                      H { &quot;select2&quot;, Fetch2 }  ,
                      H { &quot;select3&quot;, Fetch3 }  ,
                      H { &quot;select4&quot;, Fetch4 }  ,
                      H { &quot;select5&quot;, Fetch5 }  } ;

PROCEDURE <A NAME="LinkInSelects"><procedure>LinkInSelects</procedure></A>(table : MetaParser.ActionTable ) =
BEGIN
  MetaParser.TableFromArray(sourceTable,table);
END LinkInSelects;

PROCEDURE <A NAME="Fetch1"><procedure>Fetch1</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                            READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN p.stack[base+1];
  END Fetch1;

PROCEDURE <A NAME="Fetch2"><procedure>Fetch2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                            READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN p.stack[base+2];
  END Fetch2;

PROCEDURE <A NAME="Fetch3"><procedure>Fetch3</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                            READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN p.stack[base+3];
  END Fetch3;

PROCEDURE <A NAME="Fetch4"><procedure>Fetch4</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                            READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN p.stack[base+4];
  END Fetch4;

PROCEDURE <A NAME="Fetch5"><procedure>Fetch5</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                            READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN p.stack[base+5];
  END Fetch5;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() RAISES {SynParse.Fail} =
VAR
  keyDefSyn, keyIde, keyName, keyEof, keyInt, keyReal,
  keyChar, keyString, keyTermSem, keyStar, keyEq,
  keyLess, keyMore, keyHat, keyTermSemHat : SynScan.Keyword;
  clauseRest, clauseSeq, clauseExtends,
  gramExp, gramParamList, gramParamList2, gramExpBase, gramExpIde,
  gramExpSequence, gramExpChoice, gramExpParens, gramExpIter, gramExpList,
  action : SynParse.NonTerminal;
  keySet : SynScan.KeywordSet ;

BEGIN

  metaParser := SynParse.New(SynWr.out, SynParse.NewEnv());
  keySet := SynScan.NewKeywordSet();

  keyDefSyn := SynScan.BeKeyword(&quot;::=&quot;, keySet);
  keyIde := SynScan.BeKeyword(&quot;ide&quot;, keySet);
  keyName := SynScan.BeKeyword(&quot;name&quot;, keySet);
  keyEof := SynScan.BeKeyword(&quot;EOF&quot;, keySet);
  keyInt := SynScan.BeKeyword(&quot;int&quot;, keySet);
  keyReal := SynScan.BeKeyword(&quot;real&quot;, keySet);
  keyChar := SynScan.BeKeyword(&quot;char&quot;, keySet);
  keyString := SynScan.BeKeyword(&quot;string&quot;, keySet);
  keyTermSem := SynScan.BeKeyword(&quot;::&quot;, keySet);
  keyTermSemHat := SynScan.BeKeyword(&quot;::^&quot;,keySet);
  keyStar := SynScan.BeKeyword(&quot;*&quot;, keySet);
  keyEq := SynScan.BeKeyword(&quot;=&quot;, keySet);
  keyLess := SynScan.BeKeyword(&quot;&lt;&quot;,keySet);
  keyMore := SynScan.BeKeyword(&quot;&gt;&quot;,keySet);
  keyHat := SynScan.BeKeyword(&quot;^&quot;,keySet);

  SynScan.UseKeywordSet(metaParser.Scanner(), keySet);

  grammar := NEW(SynParse.NonTerminal, name:=&quot;*grammar&quot;,
    args:=SynParse.noArgs);
  clauseSeq := NEW(SynParse.NonTerminal, name:=&quot;*clauseSeq&quot;,
    args:=SynParse.noArgs);
  clauseRest := NEW(SynParse.NonTerminal, name:=&quot;*clauseRest&quot;,
    args:=SynParse.noArgs);
  clauseExtends := NEW(SynParse.NonTerminal, name:=&quot;*clauseExtends&quot;,
    args:=SynParse.noArgs);
  gramExp := NEW(SynParse.NonTerminal, name:=&quot;*gram&quot;,
    args:=SynParse.noArgs);
  gramParamList := NEW(SynParse.NonTerminal, name:= &quot;*paramList&quot;,
    args:=SynParse.noArgs);
  gramParamList2 := NEW(SynParse.NonTerminal, name:= &quot;*paramList2&quot;,
    args:=SynParse.noArgs);
  gramExpBase := NEW(SynParse.NonTerminal, name:=&quot;*gramBase&quot;,
    args:=SynParse.noArgs);
  gramExpIde := NEW(SynParse.NonTerminal, name:=&quot;*gramIdent&quot;,
    args:=SynParse.noArgs);
  gramExpSequence := NEW(SynParse.NonTerminal, name:=&quot;*gramSequence&quot;,
    args:=SynParse.noArgs);
  gramExpChoice := NEW(SynParse.NonTerminal, name:=&quot;*gramChoice&quot;,
    args:=SynParse.noArgs);
  gramExpParens := NEW(SynParse.NonTerminal, name:=&quot;*gramParens&quot;,
    args:=SynParse.noArgs);
  gramExpIter := NEW(SynParse.NonTerminal, name:=&quot;*gramIter&quot;,
    args:=SynParse.noArgs);
  gramExpList := NEW(SynParse.NonTerminal, name:=&quot;*gramList&quot;,
    args:=SynParse.noArgs);
  action := NEW(SynParse.NonTerminal, name:=&quot;*action&quot;,
    args:=SynParse.noArgs);

  (* grammar ::=
     clauseSeq
  *)
  metaParser.Add(grammar.name,
          NEW(SynParse.Action,
              grammar:=SynParse.Store(1, clauseSeq),
              Build:=Builder.Grammar));

  (* clauseSeq ::=
     [ gramExpIde &quot;::=&quot; clauseExtends gramExp clauseRest ]
  *)
  metaParser.Add(clauseSeq.name,
          NEW(SynParse.Action, grammar :=
            NEW(SynParse.Sequence, items:=
              SynParse.List(
                SynParse.Store(1, gramExpIde),
                SynParse.Store(5, gramParamList),
                NEW(SynParse.GivenKeyword,
                    key:=SynScan.GetKeywordName(keyDefSyn)),
                SynParse.Store(2, clauseExtends),
                SynParse.Store(3, gramExp),
                SynParse.Store(4, clauseRest))),
            Build:=Builder.ClauseList));

  (* clauseRest ::=
     { &quot;EOF&quot; clauseSeq  }

     hack to avoid end of file problem
  *)
  metaParser.Add(clauseRest.name,
          NEW(SynParse.Choice, choice:=
            SynParse.List(
              NEW(SynParse.Sequence, items:=
                SynParse.List(NEW(SynParse.Eof))),
              clauseSeq)));

  (* the given keyword is int a sequence in order to generate NIL *)

  (* clauseExtends ::=
     { [ &quot;.&quot; &quot;.&quot; &quot;.&quot; { [ &quot;*&quot; { [ &quot;_&quot; int ] [] } ] [] } ] [] }
  *)
  metaParser.Add(
    clauseExtends.name,
    NEW(SynParse.Choice, choice:=
      SynParse.List(
        NEW(SynParse.Action, grammar:=
          NEW(SynParse.Sequence, items:=
            SynParse.List(
              NEW(SynParse.GivenDelimiter, delim:='.'),
              NEW(SynParse.GivenDelimiter, delim:='.'),
              NEW(SynParse.GivenDelimiter, delim:='.'),
              SynParse.Store(1,NEW(SynParse.Choice, choice:=
                SynParse.List(
                  NEW(SynParse.Action, grammar:=
                    NEW(SynParse.Sequence, items:=
                      SynParse.List(
                        NEW(SynParse.GivenKeyword,
                            key:=SynScan.GetKeywordName(keyStar)),
                        SynParse.Store(
                          2,NEW(SynParse.Choice,choice:=
                            SynParse.List(
                              NEW(
                                SynParse.Action, grammar:=
                                  NEW(SynParse.Sequence, items:=
                                    SynParse.List(
                                      NEW(SynParse.GivenDelimiter, delim:='_'),
                                      SynParse.Store(
                                        3, NEW(SynParse.Integer,
                                               Build:=MetaParser.IntegerToTree)))),
                                  Build:=Builder.ClauseExtendsIterPos),
                              NEW(SynParse.Action, grammar:=
                                NEW(SynParse.Sequence, items:=NIL),
                                Build:=Builder.ClauseExtendsIterNoPos)))))),
                    Build:=Builder.ClauseExtendsIter),
                  NEW(SynParse.Action, grammar:=
                    NEW(SynParse.Sequence, items:=NIL),
                    Build:=Builder.ClauseExtendsChoice)))))),
          Build:=Builder.ClauseExtendsYes),
        NEW(SynParse.Action,
            grammar := NEW(SynParse.Sequence, items:=NIL),
            Build:=Builder.ClauseExtendsNo))));

  (* gramExpIde ::=
     ide
  *)
  metaParser.Add(gramExpIde.name,
          NEW(SynParse.Identifier,
              Build:=Builder.Ide));

  (* gramExp ::=
     (gramExpBase  * { [ &quot;::&quot; { actionTermExp
                                [ &quot;^&quot; ide ]
                                string
                                int }
                       ]
                       [ &quot;::^&quot; ide ]
                       [ &quot;_&quot; int ] } )
  *)
  metaParser.Add(
    gramExp.name,
    NEW(SynParse.Iter,
        accum := TRUE,
        accumPosition := 1,
        base := gramExpBase,
        iter :=
          NEW(SynParse.Choice,choice :=
            SynParse.List(
              NEW(SynParse.Action, grammar:=
                NEW(SynParse.Sequence, items:=
                  SynParse.List(
                    NEW(SynParse.GivenKeyword,
                        key:=SynScan.GetKeywordName(keyTermSem)),
                    SynParse.Store(
                      3,
                      NEW(SynParse.Choice, choice :=
                        SynParse.List(
                          NEW( SynParse.Action, grammar :=
                            SynParse.Store(3,NEW(SynParse.Identifier,
                                                 Build:=MetaParser.IdentifierToTree)),
                            Build:=Builder.Action),
                          NEW( SynParse.Action, grammar :=
                            NEW( SynParse.Sequence, items :=
                              SynParse.List(
                                NEW(SynParse.GivenKeyword,
                                    key := SynScan.GetKeywordName(keyHat)),
                                SynParse.Store(3,NEW(SynParse.Identifier,
                                                     Build:=MetaParser.IdentifierToTree))
                                                              )),
                            Build:=Builder.AntiquotedAction),
                          NEW( SynParse.Action, grammar :=
                            SynParse.Store(3,NEW(SynParse.QuotedString,
                                                 Build:=MetaParser.StringToTree)),
                            Build:=Builder.ActionString),
                          NEW( SynParse.Action, grammar :=
                            SynParse.Store(3,NEW(SynParse.Integer,
                                                 Build:=MetaParser.IntegerToTree)),
                            Build:=Builder.ActionInteger)))))),
                Build := Fetch3),
              NEW(SynParse.Action, grammar :=
                NEW(SynParse.Sequence, items :=
                  SynParse.List(
                    NEW(SynParse.GivenKeyword,
                        key:=SynScan.GetKeywordName(keyTermSemHat)),
                    SynParse.Store(3,NEW(SynParse.Identifier,
                                         Build:=MetaParser.IdentifierToTree)))),
                Build:=Builder.AntiquotedAction),
              NEW(SynParse.Action, grammar:=
                NEW(SynParse.Sequence, items:=
                  SynParse.List(
                    NEW(SynParse.GivenDelimiter, delim:='_'),
                    SynParse.Store(3, NEW(SynParse.Integer,
                                          Build:=MetaParser.IntegerToTree)))),
                Build:=Builder.Storage)))));

  (*
     paramList ::=
     { [ &quot;&lt;&quot; paramList2_1 &quot;&gt;&quot; ] :: select1 [] }
  *)
  metaParser.Add(gramParamList.name,
          NEW(SynParse.Choice, choice :=
            SynParse.List(
              NEW(SynParse.Action, grammar :=
                NEW(SynParse.Sequence, items :=
                  SynParse.List(
                    NEW(SynParse.GivenKeyword,
                        key := SynScan.GetKeywordName(keyLess)),
                    SynParse.Store(1,gramParamList2),
                    NEW(SynParse.GivenKeyword,
                        key := SynScan.GetKeywordName(keyMore)))),
                Build := Fetch1),
              NEW(SynParse.Sequence, items := NIL))));

   (*
     paramList2 ::=
     { [ &quot;_&quot; int_1 { [ &quot;,&quot; paramList2_2 ] :: select2 [] }_2 ] :: cons [] }
   *)
  metaParser.Add(gramParamList2.name,
          NEW(SynParse.Choice, choice :=
            SynParse.List(
              NEW(SynParse.Action, grammar :=
                NEW(SynParse.Sequence, items :=
                  SynParse.List(
                    NEW(SynParse.GivenDelimiter, delim := '_'),
                    SynParse.Store(1,NEW(SynParse.Integer,
                                         Build:= MetaParser.IntegerToTree)),
                    SynParse.Store(2,NEW(SynParse.Choice, choice :=
                      SynParse.List(
                        NEW(SynParse.Action, grammar :=
                          NEW(SynParse.Sequence, items :=
                            SynParse.List(
                              NEW(SynParse.GivenDelimiter, delim := ',' ),
                              SynParse.Store(2, gramParamList2))),
                          Build := Fetch2),
                        NEW(SynParse.Sequence, items := NIL )))))),
                Build := Builder.ConsParam),
              NEW(SynParse.Sequence, items := NIL))));

  (* gramExpBase ::=
     { ide string &quot;ide&quot; &quot;name&quot; &quot;int&quot; &quot;EOF&quot; &quot;real&quot; &quot;char&quot; &quot;string&quot;
     gramExpSequence gramExpChoice gramExpParens }
  *)
  metaParser.Add(gramExpBase.name,
          NEW(SynParse.Choice, choice:=
            SynParse.List(
              NEW(SynParse.Action, grammar :=
                NEW(SynParse.Sequence, items :=
                  SynParse.List(
                    SynParse.Store(1,NEW(SynParse.Identifier,
                                         Build:= MetaParser.IdentifierToTree)),
                    SynParse.Store(2,gramParamList))),
                Build := Builder.GramIde2 ),
                NEW(SynParse.QuotedString,
                  Build:=Builder.GramString),
                NEW(SynParse.GivenKeyword,
                    key:=SynScan.GetKeywordName(keyEof),
                    Build:=Builder.GramKeyEof),
                NEW(SynParse.GivenKeyword,
                    key:=SynScan.GetKeywordName(keyIde),
                    Build:=Builder.GramKeyIde),
                NEW(SynParse.GivenKeyword,
                    key:=SynScan.GetKeywordName(keyName),
                    Build:=Builder.GramKeyName),
                NEW(SynParse.GivenKeyword,
                    key:=SynScan.GetKeywordName(keyInt),
                    Build:=Builder.GramKeyInt),
                NEW(SynParse.GivenKeyword,
                    key:=SynScan.GetKeywordName(keyReal),
                    Build:=Builder.GramKeyReal),
                NEW(SynParse.GivenKeyword,
                    key:=SynScan.GetKeywordName(keyChar),
                    Build:=Builder.GramKeyChar),
                NEW(SynParse.GivenKeyword,
                    key:=SynScan.GetKeywordName(keyString),
                    Build:=Builder.GramKeyString),
                gramExpSequence,
                gramExpChoice,
                gramExpParens)));

  (* gramExpSequence ::=
     [ &quot;[&quot; gramExpList &quot;]&quot; ]
  *)
  metaParser.Add(gramExpSequence.name,
          NEW(SynParse.Action, grammar:=
            NEW(SynParse.Sequence, items:=
              SynParse.List(
                NEW(SynParse.GivenDelimiter, delim:='['),
                SynParse.Store(1, gramExpList),
                NEW(SynParse.GivenDelimiter, delim:=']'))),
            Build:=Builder.GramExpSequence));

  (* gramExpChoice ::=
     [ &quot;{&quot; gramExpList &quot;}&quot; ]
  *)
  metaParser.Add(gramExpChoice.name,
          NEW(SynParse.Action, grammar:=
            NEW(SynParse.Sequence, items:=
              SynParse.List(
                NEW(SynParse.GivenDelimiter, delim:='{'),
                SynParse.Store(1, gramExpList),
                NEW(SynParse.GivenDelimiter, delim:='}'))),
            Build:=Builder.GramExpChoice));

  (* gramExpParens ::=
     [ &quot;(&quot; gramExp
     { [ &quot;*&quot; { [ &quot;_&quot; int gramExp ] gramExp } ] [] }
     &quot;)&quot; ]
  *)
  metaParser.Add(gramExpParens.name,
          NEW(SynParse.Action, grammar:=
            NEW(SynParse.Sequence, items:=
              SynParse.List(
                NEW(SynParse.GivenDelimiter, delim:='('),
                SynParse.Store(1, gramExp),
                SynParse.Store(6,NEW(SynParse.Choice, choice :=
                  SynParse.List(
                    NEW(SynParse.Action, grammar:=
                      NEW(SynParse.Sequence, items:=
                        SynParse.List(
                          NEW(SynParse.GivenKeyword,
                              key:=SynScan.GetKeywordName(keyStar)),
                          SynParse.Store(5,NEW(SynParse.Choice, choice:=
                            SynParse.List(
                              NEW(SynParse.Action, grammar:=
                                NEW(SynParse.Sequence, items:=
                                  SynParse.List(
                                    NEW(SynParse.GivenDelimiter,
                                        delim:='_'),
                                    SynParse.Store(4, NEW(SynParse.Integer,
                                                       Build:=MetaParser.IntegerToTree)),
                                    SynParse.Store(3, gramExp))),
                                Build:= Builder.GramExpIterPos),
                              NEW(SynParse.Action, grammar:=
                                SynParse.Store(3, gramExp),
                                Build:= Builder.GramExpIterNoPos)))))),
                      Build:=Builder.GramExpIter),
                    NEW(SynParse.Action,
                        grammar:=NEW(SynParse.Sequence, items:=NIL),
                        Build:=Builder.GramExpBase)))),
                NEW(SynParse.GivenDelimiter, delim:=')'))),
            Build:=Builder.GramExpParens));

  (* gramExpList ::=
     { [ gramExp gramExpList ] [] }
  *)
  metaParser.Add(gramExpList.name,
          NEW(SynParse.Choice, choice :=
            SynParse.List(
              NEW(SynParse.Action, grammar:=
                NEW(SynParse.Sequence, items:=
                  SynParse.List(
                    SynParse.Store(1, gramExp),
                    SynParse.Store(2, gramExpList))),
                Build:=Builder.GramList),
              NEW(SynParse.Sequence, items:=NIL))));
END Setup;

BEGIN
END Constructor.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
