<HTML>
<HEAD>
<TITLE>SRC Modula-3: metasyn/src/MetaParser.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>metasyn/src/MetaParser.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
INTERFACE <interface><A HREF="MetaParser.m3">MetaParser</A></interface> ;
IMPORT <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../synex/src/SynParse.i3">SynParse</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>;
</PRE> =============================================================================
   <PRE>
      This interface is the main interface for the MetaParser package
         See also the metaParser manpage.
         
         This metaparser can be used to produce a parser for
         an extensible grammar, from a BNF-like description of the grammar.
         It is based on the synex package.
   
</PRE>
   <PRE>
      Interpretation of rd and fileName
         ---------------------------------
         
         Several procedures and methods in this interface have arguments to specify 
   </PRE>
where their input should come from. These arguments come in couples:
   A reader and a fileName. 
   <PRE>
      
         If both fileName and rd are specified (i.e. non-NIL), the actual input will 
   </PRE>
come from rd, and the fileName is used when displaying error-messages. 
   (When there is a Syntax error, the scanner displays an error message, containing
   the line-number and the FILENAME where the error occured. See SynScan.i3 for 
   details) If FileName is equal to <CODE></CODE>, this means that the input is toplevel, 
   and this prevents the reader from being popped when there is an error. (To 
   avoid losing stdin)
   <PRE>
      
         If only a fileName is specified, then it is opened, and the input will come
   </PRE>
from this file. It will also be used for the error messages.
   <PRE>
      
         If only rd is specified, the input will come from rd, and the fileName used
   </PRE>
to display errror-messages will be <CODE>(unknown file)</CODE> if the rd is different from
   stdin, and <CODE></CODE> if rd is equal to stdin.
   <PRE>
      
         If neither a reader, nor a fileName will be specified, input will come from
   </PRE>
Stdio.stdin, and <CODE></CODE> will be used while displaying error messages.  
   <PRE>
      
         End of file handling
         --------------------
         When the scanner reaches the end of a file, it generates and EOF token if the
         genereateEOF flag has been set for this reader, and then it pops the reader 
         from the reader stack, and continues with the previous reader.
         Continuing parsing after popping the last reader causes a run-time error.
         See SynScan.i3 for details.
         
         ===============================================================================


<P>
<P><PRE>TYPE
  ActionProc = PROCEDURE(self: SynParse.Action; p: SynParse.T; base: INTEGER;
                         READONLY info: SynLocation.Info)
                         : SynParse.Tree RAISES {SynParse.Fail} ;
  (*
     | type of an action procedure
     |
     | base is the frame-pointer for the SynParse.Stack (see SynParse.i3)
     | SynParse.Stack[base+i] contains the argument stored at the position i
     |
     | info is a position descriptor to be used to display errors.
     | Transform it into an SynLocation.T using SynLocation.NewLineLocation(info), and
     stick it into the location field of the parse-tree you return. When some other
     Action won't be &quot;happy&quot; with this parse-tree, it can find out form which
     place in the text this parse-tree came from, in order to display the error.
     |
     | In order to display the location, use:
     |      SynLocation.PrintLocation(SynOut.out,tree.location,0);
     |
  *)

  ActionProcEntry = RECORD
    name : TEXT ;                 (* name of the action *)
    proc : ActionProc ;           (* procedure which implements the action *)
  END;
  (*
    | entry in the &quot;source&quot; action table
    | the &quot;source&quot; action table is juste an array of these.
    | To use it, it must first be transformed into a hash-table, using the
    | procedure TableFromArray
  *)

  ActionTable = TextRefTbl.T ;
  (* Hashed action-table to be passed to ReadGFile. It is genereated from
     | an array of ActionProcEntry's using ReadGFile
  *)

  ActionProcTable = ARRAY OF ActionProcEntry ;

  Grammar &lt;: Grammar_public;
  Grammar_public = BRANDED OBJECT
    env: SynParse.GrammarEnv := NIL;
    (* environment of non-terminals *)
    keySet: SynScan.KeywordSet := NIL;
    (* set of keywords of this grammar *)
  END; (* object *)
  (* grammar object *)

  ClauseList =
    SynParse.Tree BRANDED OBJECT
    ide: TextNode;
    args: SynParse.Args;
    extend, extendIter, iterPosPresent: BOOLEAN; iterPos: INTEGER;
    gram: SynParse.Grammar;
    rest:ClauseList;
  END;

  TextNode =
    SynParse.Tree BRANDED OBJECT
      text: TEXT;
    END;
</PRE> CAUTION: If you use multi-threading, put a lock around any call to Parse. 

<P><PRE>PROCEDURE <A HREF="MetaParser.m3#NewParser">NewParser</A>(swr: SynWr.T; actionTable : ActionTable; fileName: TEXT; rd: Rd.T)
    : SynParse.T
    RAISES {SynParse.Fail, SynScan.Fail, SynScan.NoReader};
</PRE><BLOCKQUOTE><EM> This procedure returns a new parser for the grammar read from rd;
    actionTable is a hashed actionTable used to translate the action strings 
   of the grammar file into procedures.  The parser writes messages to swr.
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MetaParser.m3#NewClauseList">NewClauseList</A>(actionTable : ActionTable; fileName: TEXT; rd: Rd.T)
    : ClauseList RAISES {SynParse.Fail, SynScan.Fail, SynScan.NoReader};
PROCEDURE <A HREF="MetaParser.m3#AddClauseList">AddClauseList</A>(tree: SynParse.Tree; p: SynParse.T)
    RAISES {SynParse.Fail};
</PRE><BLOCKQUOTE><EM> Main subroutines of NewParser. The clauselist returned by NewClauseList
   may be attached to multiple parsers via AddClauseList.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MetaParser.m3#Setup">Setup</A>() RAISES {SynParse.Fail};
</PRE><BLOCKQUOTE><EM> To be called before any other use of this module. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MetaParser.m3#PackageSetup">PackageSetup</A>() RAISES {SynParse.Fail};
</PRE><BLOCKQUOTE><EM> Call all the Setup functions in this package. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MetaParser.m3#NewActionTable">NewActionTable</A>(): ActionTable;
</PRE><BLOCKQUOTE><EM> returns a new, empty action table </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MetaParser.m3#Register">Register</A>(name: TEXT; proc: ActionProc;
                          table: ActionTable );

PROCEDURE <A HREF="MetaParser.m3#TableFromArray">TableFromArray</A>( sourceTable : ActionProcTable;
                          table: ActionTable ) ;
</PRE><BLOCKQUOTE><EM> merges an array of ActionProcEntry's (sourceTable) into a ActionTable,
  which can be passed to ReadGFile </EM></BLOCKQUOTE><PRE>

  PROCEDURE <A HREF="MetaParser.m3#PrintClauseList">PrintClauseList</A>(list: ClauseList);
</PRE> Basic routines to deal with the metaParser
   datatypes IntegerTemp, RealTemp, and TextTemp. 

<P><PRE>CONST defaultinfo = SynLocation.Info  { fileName :=&quot;dummy&quot; ,
                                           char := 0,
                                           line := 0,
                                           lineChar := 0 } ;
      (* too avoid passing info when we don't really need it *)

TYPE
  (* types to represent integers, reals, and strings as parse-trees  *)

  IntegerTemp =
    SynParse.Tree BRANDED OBJECT
    int: INTEGER;
  END;
  RealTemp =
    SynParse.Tree BRANDED OBJECT
    real: LONGREAL;
  END;
  TextTemp =
    SynParse.Tree BRANDED OBJECT
    text: TEXT ;
  END;
  (* TextTemp, represents Strings, Texts and Chars *)
  (* characters are just represented as one-length TextTemp's *)
</PRE> ==================================================================== 
 the following routines transform the given type into a SynParse.Tree 
 ==================================================================== 

<P><PRE>PROCEDURE <A HREF="MetaParser.m3#IdentifierToTree">IdentifierToTree</A>(self: SynParse.Identifier;
                     p: SynParse.T; name: TEXT;
                     READONLY info: SynLocation.Info := defaultinfo):
                                                             SynParse.Tree;

PROCEDURE <A HREF="MetaParser.m3#NameToTree">NameToTree</A>(self: SynParse.Name;
                     p: SynParse.T; name: TEXT;
                     READONLY info: SynLocation.Info := defaultinfo):
                                                             SynParse.Tree;

PROCEDURE <A HREF="MetaParser.m3#IntegerToTree">IntegerToTree</A>(self: SynParse.Integer;
                  p: SynParse.T; int: INTEGER;
                  READONLY info: SynLocation.Info := defaultinfo):
                                                          SynParse.Tree;

PROCEDURE <A HREF="MetaParser.m3#RealToTree">RealToTree</A>(self: SynParse.Real;
               p: SynParse.T; real: LONGREAL;
               READONLY info: SynLocation.Info := defaultinfo ):
                                                           SynParse.Tree;

PROCEDURE <A HREF="MetaParser.m3#CharToTree">CharToTree</A>(self: SynParse.QuotedChar;
               p: SynParse.T; char: CHAR;
               READONLY info: SynLocation.Info := defaultinfo): SynParse.Tree;

PROCEDURE <A HREF="MetaParser.m3#StringToTree">StringToTree</A>(self: SynParse.QuotedString;
                 p: SynParse.T; string: TEXT;
                 READONLY info: SynLocation.Info := defaultinfo): SynParse.Tree;

PROCEDURE <A HREF="MetaParser.m3#TextToTree">TextToTree</A>(self: SynParse.QuotedString;
                 p: SynParse.T; text: TEXT ;
                 READONLY info: SynLocation.Info := defaultinfo ): SynParse.Tree;
</PRE> ================================================================== 
 The G-routines <CODE>get</CODE> the requested type from location <CODE>loc</CODE> of the 
 SynParse.Stack . loc = base + position                             
 ================================================================== 

<P><PRE>PROCEDURE <A HREF="MetaParser.m3#GInt">GInt</A>(p: SynParse.T; loc : INTEGER): INTEGER RAISES {SynParse.Fail};
PROCEDURE <A HREF="MetaParser.m3#GReal">GReal</A>(p: SynParse.T; loc :INTEGER): LONGREAL RAISES {SynParse.Fail};
PROCEDURE <A HREF="MetaParser.m3#GText">GText</A>(p: SynParse.T; loc :INTEGER): TEXT RAISES {SynParse.Fail};
PROCEDURE <A HREF="MetaParser.m3#GBool">GBool</A>(p: SynParse.T; loc :INTEGER): BOOLEAN RAISES {SynParse.Fail};
</PRE> ============================================================== 
 the X-routines transform a SynParse.Tree to the requested type  
 ============================================================== 

<P><PRE>PROCEDURE <A HREF="MetaParser.m3#XInt">XInt</A>(tree: SynParse.Tree): INTEGER RAISES {SynParse.Fail};
PROCEDURE <A HREF="MetaParser.m3#XReal">XReal</A>(tree: SynParse.Tree): LONGREAL RAISES {SynParse.Fail};
PROCEDURE <A HREF="MetaParser.m3#XText">XText</A>(tree: SynParse.Tree): TEXT RAISES {SynParse.Fail};
PROCEDURE <A HREF="MetaParser.m3#XBool">XBool</A>(tree: SynParse.Tree): BOOLEAN RAISES {SynParse.Fail};
</PRE> ================================================================ 
 TypeError prints a type-error, using the location-info contained 
 in tree to tell the line and the file-name                       
 Text should contain the expected type                            
 ================================================================ 

<P><PRE>PROCEDURE <A HREF="MetaParser.m3#TypeError">TypeError</A>(type: TEXT ; tree : SynParse.Tree) RAISES {SynParse.Fail};

END MetaParser.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
