<HTML>
<HEAD>
<TITLE>SRC Modula-3: metasyn/src/MetaParser.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>metasyn/src/MetaParser.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
MODULE <module><implements><A HREF="MetaParser.i3">MetaParser</A></implements></module> ;

IMPORT <A HREF="Constructor.i3">Constructor</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../synex/src/SynParse.i3">SynParse</A>, <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>,
       <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="Builder.i3">Builder</A>, <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>,
       <A HREF="../../text/src/Text.i3">Text</A>;

&lt;* FATAL Crash *&gt;

REVEAL
  <A NAME="Grammar">Grammar</A> = Grammar_public BRANDED OBJECT
    gram: SynParse.Grammar := NIL;
  END; (* object *)

PROCEDURE <A NAME="NewClauseList"><procedure>NewClauseList</procedure></A>(actionTable : ActionTable; fileName: TEXT; rd: Rd.T)
    : ClauseList RAISES {SynParse.Fail, SynScan.Fail, SynScan.NoReader} =
  BEGIN
    Builder.actionTable := actionTable;
    SynScan.PushInput(Constructor.metaParser.Scanner(),
                      fileName, rd, TRUE, TRUE);
    RETURN Constructor.metaParser.Read(Constructor.grammar);
  END NewClauseList;

PROCEDURE <A NAME="AddClauseList"><procedure>AddClauseList</procedure></A>(tree: SynParse.Tree; p: SynParse.T)
    RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE tree OF
    | NULL =&gt; RETURN
    | ClauseList(clauseList) =&gt;
      MergeEnv(clauseList, p);
      BeKeywordsOfClauseList(clauseList,
        SynScan.GetKeywordSet(p.Scanner()));
    ELSE
      RAISE SynParse.Fail ;
    END;
  END AddClauseList;

PROCEDURE <A NAME="NewParser"><procedure>NewParser</procedure></A>(swr: SynWr.T; actionTable : ActionTable; fileName: TEXT; rd: Rd.T)
    : SynParse.T
    RAISES {SynParse.Fail, SynScan.Fail, SynScan.NoReader} =
  VAR clauseList: SynParse.Tree; parser: SynParse.T;
  BEGIN
    clauseList := NewClauseList(actionTable, fileName, rd);
    parser := SynParse.New(swr, SynParse.NewEnv());
    AddClauseList(clauseList, parser);
    RETURN parser;
  END NewParser;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
  END Setup;

PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() RAISES {SynParse.Fail} =
  BEGIN
    Constructor.Setup();
    Setup();
  END PackageSetup;

PROCEDURE <A NAME="NewActionTable"><procedure>NewActionTable</procedure></A>(): ActionTable =
  VAR
    actions: ActionTable;
  BEGIN
    actions := NEW(TextRefTbl.Default).init();

    (* link in default actions *)
    Constructor.LinkInSelects(actions);
    RETURN actions;
  END NewActionTable;

EXCEPTION Crash;

PROCEDURE <A NAME="TableFromArray"><procedure>TableFromArray</procedure></A>(&lt;*NOWARN*&gt;sourceTable : ActionProcTable;
                          table: ActionTable ) =
</PRE><BLOCKQUOTE><EM> transforms an array of (Text, Procedure) pairs into an actionTable </EM></BLOCKQUOTE><PRE>
VAR
  tmp : REF ActionProc ;

BEGIN
  IF table = NIL THEN
    RAISE Crash ;
  END;

  FOR i := FIRST(sourceTable) TO LAST(sourceTable) DO
    tmp := NEW(REF ActionProc);
    tmp^ := sourceTable[i].proc ;
    EVAL table.put(sourceTable[i].name,tmp );
  END;
END TableFromArray ;

PROCEDURE <A NAME="Register"><procedure>Register</procedure></A>(name: TEXT; proc: ActionProc;
                          table: ActionTable ) =
VAR
  ref : REF ActionProc ;
BEGIN
  IF table = NIL THEN
    RAISE Crash;
  END;
  ref := NEW(REF ActionProc);
  ref^ := proc;
  EVAL table.put(name,ref);
END Register;

PROCEDURE <A NAME="IdentifierToTree"><procedure>IdentifierToTree</procedure></A>(self: SynParse.Identifier;
                     p: SynParse.T; name: TEXT;
                     READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW( TextTemp,
           location := SynLocation.NewLineLocation(info) ,
           text := name );
  END IdentifierToTree;

PROCEDURE <A NAME="NameToTree"><procedure>NameToTree</procedure></A>(self: SynParse.Name;
                     p: SynParse.T; name: TEXT;
                     READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW( TextTemp,
           location := SynLocation.NewLineLocation(info) ,
           text := name );
  END NameToTree;

PROCEDURE <A NAME="IntegerToTree"><procedure>IntegerToTree</procedure></A>(self: SynParse.Integer;
                  p: SynParse.T; int: INTEGER;
                  READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW( IntegerTemp,
           location := SynLocation.NewLineLocation(info) ,
           int := int ) ;
  END IntegerToTree;

PROCEDURE <A NAME="RealToTree"><procedure>RealToTree</procedure></A>(self: SynParse.Real;
               p: SynParse.T; real: LONGREAL;
               READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW( RealTemp,
           location := SynLocation.NewLineLocation(info) ,
           real := real );
  END RealToTree;

PROCEDURE <A NAME="CharToTree"><procedure>CharToTree</procedure></A>(self: SynParse.QuotedChar;
               p: SynParse.T; char: CHAR;
               READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(TextTemp,
          location := SynLocation.NewLineLocation(info) ,
          text := Text.FromChar(char ) );
  END CharToTree;

PROCEDURE <A NAME="StringToTree"><procedure>StringToTree</procedure></A>(self: SynParse.QuotedString;
                 p: SynParse.T; string: TEXT;
                 READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(TextTemp,
          location := SynLocation.NewLineLocation(info) ,
          text := string);
  END StringToTree;

PROCEDURE <A NAME="TextToTree"><procedure>TextToTree</procedure></A>(self: SynParse.QuotedString;
                 p: SynParse.T; text: TEXT ;
                 READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(TextTemp,
          location := SynLocation.NewLineLocation(info) ,
          text := text );
  END TextToTree;

PROCEDURE <A NAME="GInt"><procedure>GInt</procedure></A>(p: SynParse.T; loc :INTEGER): INTEGER RAISES {SynParse.Fail}=
  BEGIN
    RETURN
      XInt(p.stack[loc]);
  END GInt;

PROCEDURE <A NAME="GReal"><procedure>GReal</procedure></A>(p: SynParse.T; loc :INTEGER): LONGREAL RAISES {SynParse.Fail}=
  BEGIN
    RETURN
      XReal(p.stack[loc]);
  END GReal;

PROCEDURE <A NAME="GText"><procedure>GText</procedure></A>(p: SynParse.T; loc :INTEGER): TEXT RAISES {SynParse.Fail}=
  BEGIN
    RETURN
      XText(p.stack[loc]);
  END GText;

PROCEDURE <A NAME="GBool"><procedure>GBool</procedure></A>(p: SynParse.T; loc: INTEGER): BOOLEAN RAISES {SynParse.Fail}=
  BEGIN
    RETURN
      XBool(p.stack[loc]);
  END GBool;

PROCEDURE <A NAME="XInt"><procedure>XInt</procedure></A>(tree: SynParse.Tree): INTEGER RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE tree OF
    | NULL =&gt;
    | IntegerTemp(node) =&gt; RETURN node.int ;
    ELSE
    END;
    TypeError(&quot;Text&quot;,tree);
    &lt;*ASSERT FALSE*&gt;
  END XInt;

PROCEDURE <A NAME="XReal"><procedure>XReal</procedure></A>(tree: SynParse.Tree): LONGREAL RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE tree OF
    | NULL =&gt;
    | RealTemp(node) =&gt; RETURN node.real ;
    ELSE
    END;
    TypeError(&quot;Text&quot;,tree);
    &lt;*ASSERT FALSE*&gt;
  END XReal;

PROCEDURE <A NAME="XText"><procedure>XText</procedure></A>(tree: SynParse.Tree): TEXT RAISES {SynParse.Fail}=
  BEGIN
    TYPECASE tree OF
    | NULL =&gt;
    | IntegerTemp(node) =&gt; RETURN Fmt.Int(node.int);
    | RealTemp(node)    =&gt; RETURN Fmt.LongReal(node.real);
    | TextTemp(node)    =&gt; RETURN node.text ;
    ELSE
    END;
    TypeError(&quot;Text&quot;,tree);
    &lt;*ASSERT FALSE*&gt;
  END XText;

PROCEDURE <A NAME="XBool"><procedure>XBool</procedure></A>(tree: SynParse.Tree): BOOLEAN RAISES {SynParse.Fail}=
  VAR
    text : TEXT;
    array : REF ARRAY OF CHAR;
    l : INTEGER;
  BEGIN
    TYPECASE tree OF
    | NULL =&gt;
    | IntegerTemp(node) =&gt; RETURN node.int # 0;
    | RealTemp(node)    =&gt; RETURN node.real # 0.0d0 ;
    | TextTemp(node)    =&gt;
      text := node.text;
      l := Text.Length(text);
      array := NEW( REF ARRAY OF CHAR, l );
      FOR i := 0 TO l - 1 DO
        array[i] := Text.GetChar(text,i);
      END;
      text := Text.FromChars(array^);
      IF Text.Equal(text,&quot;on&quot;) OR Text.Equal(text,&quot;true&quot;) THEN
        RETURN TRUE;
      ELSIF Text.Equal(text,&quot;off&quot;) OR Text.Equal(text,&quot;false&quot;) THEN
        RETURN FALSE;
      END;
    ELSE
    END;
    TypeError(&quot;Boolean&quot;,tree);
    &lt;*ASSERT FALSE*&gt;
  END XBool;

PROCEDURE <A NAME="TypeError"><procedure>TypeError</procedure></A>(type: TEXT; tree: SynParse.Tree) RAISES {SynParse.Fail}=
  BEGIN
    IF tree = NIL THEN
      SynWr.Text(SynWr.out, &quot;Got NIL pointer instead of &quot;&amp;type, loud:=TRUE);
    ELSE
      SynWr.Text(SynWr.out, type &amp; &quot; expected at &quot;, loud:=TRUE);
      SynLocation.PrintLocation(SynWr.out, tree.location);
    END;
    SynWr.Text(SynWr.out, &quot;\n&quot;, loud:=TRUE);
    SynWr.Flush(SynWr.out, loud:=TRUE);
    RAISE SynParse.Fail;
  END TypeError;

  PROCEDURE <A NAME="MergeEnv"><procedure>MergeEnv</procedure></A>(list: ClauseList; p: SynParse.T) RAISES {SynParse.Fail} =
    BEGIN
      LOOP
        IF list=NIL THEN RETURN END;
	IF list.extend THEN
	  IF list.extendIter THEN
	    p.ExtendIter(list.ide.text, list.iterPosPresent, list.iterPos,
		list.gram, list.args);
	  ELSE
	    p.Extend(list.ide.text, list.gram, list.args);
	  END;
	ELSE
	  p.Add(list.ide.text, list.gram, list.args);
	END;
        list := list.rest;
      END;
    END MergeEnv;
</PRE><P>
  PROCEDURE BeKeywords(list: ClauseList; keySet: SynScan.KeywordSet) RAISES {SynParse.Fail} =
    BEGIN
      LOOP
        IF list=NIL THEN RETURN END;
	BeKeywordsOfGram(list.gram, keySet);
        list := list.rest;
      END;
    END BeKeywords;


<P>  <PRE>PROCEDURE <A NAME="BeKeywordsOfGramList"><procedure>BeKeywordsOfGramList</procedure></A>(list: SynParse.GrammarList; keySet: SynScan.KeywordSet) RAISES {SynParse.Fail} =
    BEGIN
      LOOP
        IF list=NIL THEN RETURN END;
	BeKeywordsOfGram(list.first, keySet);
        list := list.rest;
      END;
    END BeKeywordsOfGramList;

    (* AK following procedure added *)
  PROCEDURE <A NAME="BeKeywordsOfClauseList"><procedure>BeKeywordsOfClauseList</procedure></A>(list: ClauseList; keySet: SynScan.KeywordSet) RAISES {SynParse.Fail} =
    BEGIN
      LOOP
        IF list=NIL THEN RETURN END;
	BeKeywordsOfGram(list.gram, keySet);
        list := list.rest;
      END;
    END BeKeywordsOfClauseList;

  PROCEDURE <A NAME="BeKeywordsOfGram"><procedure>BeKeywordsOfGram</procedure></A>(gram: SynParse.Grammar; keySet: SynScan.KeywordSet) RAISES {SynParse.Fail} =
    BEGIN
      TYPECASE gram OF
      | NULL =&gt;
      | SynParse.NonTerminal =&gt;
      | SynParse.Storage(node) =&gt; BeKeywordsOfGram(node.item, keySet);
      | SynParse.Action(node) =&gt; BeKeywordsOfGram(node.grammar, keySet);
      | SynParse.GivenKeyword(node) =&gt;
	  EVAL SynScan.BeKeyword(node.key, keySet);
      | SynParse.Identifier, SynParse.Name, SynParse.QuotedChar,
          SynParse.Integer, SynParse.Real, SynParse.QuotedString,
          SynParse.GivenDelimiter =&gt;
      | SynParse.Sequence(node) =&gt;
	  BeKeywordsOfGramList(node.items, keySet);
      | SynParse.Choice(node) =&gt; BeKeywordsOfGramList(node.choice, keySet);
      | SynParse.Iter(node) =&gt;
	  BeKeywordsOfGram(node.base, keySet);
	  BeKeywordsOfGram(node.iter, keySet);
      | SynParse.GivenName =&gt;
      | SynParse.Eof =&gt;
      ELSE &lt;*ASSERT FALSE*&gt;
      END;
    END BeKeywordsOfGram;

    PROCEDURE <A NAME="PrintGram"><procedure>PrintGram</procedure></A>(gram : SynParse.Grammar )=
      BEGIN
      TYPECASE gram OF
      | NULL =&gt;
      | SynParse.NonTerminal(node) =&gt;
        SynWr.Text(SynWr.out, node.name);
      | SynParse.Storage(node) =&gt;
        PrintGram(node.item);
        SynWr.Text(SynWr.out, Fmt.Int(node.position));
      | SynParse.Action(node) =&gt;
        PrintGram(node.grammar);
        SynWr.Text(SynWr.out, &quot; :: Action &quot;);
      | SynParse.GivenKeyword(node) =&gt;
        SynWr.Text(SynWr.out, &quot;\&quot;&quot; &amp; node.key &amp; &quot;\&quot;&quot; );
      | SynParse.GivenName(node) =&gt;
        SynWr.Text(SynWr.out, &quot;\&quot;~&quot; &amp; node.text &amp; &quot;\&quot;&quot; );
      | SynParse.Identifier =&gt;
        SynWr.Text(SynWr.out, &quot; identifier &quot;);
      | SynParse.QuotedChar =&gt;
        SynWr.Text(SynWr.out, &quot; quoted char &quot;);
      | SynParse.Integer =&gt;
        SynWr.Text(SynWr.out, &quot; integer &quot;);
      | SynParse.Real =&gt;
        SynWr.Text(SynWr.out, &quot; real &quot;);
      | SynParse.QuotedString =&gt;
        SynWr.Text(SynWr.out, &quot; quoted string &quot;);
      | SynParse.GivenDelimiter(node) =&gt;
        SynWr.Text(SynWr.out, &quot;\' &quot;);
        SynWr.Char(SynWr.out, node.delim);
        SynWr.Text(SynWr.out, &quot;\' &quot;);
      | SynParse.Sequence(node) =&gt;
        SynWr.Text(SynWr.out, &quot; [ &quot;);
        PrintGramList(node.items);
        SynWr.Text(SynWr.out, &quot; ] &quot;);
      | SynParse.Choice(node) =&gt;
        SynWr.Text(SynWr.out, &quot; { &quot;);
        PrintGramList(node.choice);
        SynWr.Text(SynWr.out, &quot; } &quot;);
      | SynParse.Iter(node) =&gt;
        SynWr.Text(SynWr.out, &quot; ( &quot;);
        PrintGram(node.base);
        SynWr.Text(SynWr.out, &quot; * &quot;);
        PrintGram(node.base);
        SynWr.Text(SynWr.out, &quot; ) &quot;);
      | SynParse.Eof =&gt;
        SynWr.Text(SynWr.out, &quot;EOF&quot;);
      ELSE &lt;*ASSERT FALSE*&gt;
      END;
    END PrintGram;

  PROCEDURE <A NAME="PrintGramList"><procedure>PrintGramList</procedure></A>(list: SynParse.GrammarList) =
  BEGIN
    WHILE list#NIL DO
      PrintGram(list.first);
      list:=list.rest;
      SynWr.Char(SynWr.out, ' ');
    END;
  END PrintGramList;

  PROCEDURE <A NAME="PrintClauseList"><procedure>PrintClauseList</procedure></A>(list: ClauseList) =
  BEGIN
    WHILE list#NIL DO
      SynWr.Text(SynWr.out, &quot; &quot; &amp; list.ide.text);
      SynWr.Text(SynWr.out, &quot;::= &quot; );
      PrintGram(list.gram);
      (* IF list.extend OR list.extendIter THEN
         SynWr.Text(SynWr.out, &quot;(extended)&quot;);
      END; *)
      list:=list.rest;
      SynWr.Char(SynWr.out, '\n');
    END;
  END PrintClauseList;

BEGIN
END MetaParser .
</PRE><P>
<P>
  PROCEDURE UndoMergeEnv(list: ClauseList; p: SynParse.T) 
      RAISES {SynParse.Fail} ;
<P>
  PROCEDURE UndoMergeEnv(list: ClauseList; p: SynParse.T) RAISES {SynParse.Fail} =
    BEGIN
      LOOP
        IF list=NIL THEN RETURN END;
	IF list.inserted THEN
	  IF list.extend THEN
	    IF list.extendIter THEN
	      p.UndoExtendIter(list.ide.text, list.gram);
	    ELSE
	      p.UndoExtend(list.ide.text, list.gram);
	    END;
	  ELSE
	    p.UndoAdd(list.ide.text);
	  END;
	END;
	list.inserted := FALSE;
        list := list.rest;
      END;
    END UndoMergeEnv;
<P>
 MergeEnv:    list.inserted := TRUE;
<P>
   Note that
   AddClauseList has a side-effect on the <CODE>inserted</CODE> fields of clauseList,
   which are used (only) to undo grammar extensions.
   <P>


</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
