<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/Animate.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/Animate.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P><PRE>INTERFACE <interface><A HREF="Animate.m3">Animate</A></interface>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="MG.i3">MG</A>, <A HREF="MGV.i3">MGV</A>, <A HREF="R2.i3">R2</A>, <A HREF="R2Path.i3">R2Path</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  TimeFunction = OBJECT
              METHODS
                &lt;* LL = {v.mu} *&gt;
                map (t: REAL): REAL;
                (* map range [0.0, 1.0] onto itself *)
              END;
  (* A TimeFunction controls the rate of change within an animation. An
     animation moves uniformly through the values 0.0 to 1.0 for t.
     TimeFunction.map adjusts t to have a different behaviour. *)

  <A HREF="Animate.m3#TimeDiscrete">TimeDiscrete</A> &lt;: TimeDiscretePublic;
  TimeDiscretePublic = TimeFunction OBJECT
                &lt;* LL = {v.mu} *&gt;
                values: REF ARRAY OF
                              RECORD
                                step : REAL;
                                value: REAL
                              END;
              END;
  (* A TimeDiscrete.map(t) returns TimeDiscrete.values[i].value where i is the
     first TDiscrete.values[i].step &gt;= t. *)

  <A HREF="Animate.m3#TimeStep">TimeStep</A> &lt;: TimeStepPublic;
  TimeStepPublic = TimeFunction OBJECT
            &lt;* LL = {v.mu} *&gt;
            steps := 1;
          END;
</PRE><BLOCKQUOTE><EM> A TimeState.map(t) returns FLOOR(t * steps) / steps </EM></BLOCKQUOTE><PRE>

VAR
  tfZero   : TimeFunction;          (* tfLinear.map(t) returns 0.0 *)
  tfOne    : TimeFunction;          (* tfLinear.map(t) returns 1.0 *)
  tfLinear : TimeFunction;          (* tfLinear.map(t) returns t *)
  tfInverse: TimeFunction;          (* tfInverse.map(t) returns 1.0 - t *)

TYPE
  T = MGV.AnimateT;

REVEAL
  T &lt;: TPublic;

TYPE
  TPublic = OBJECT
        &lt;* LL = {v.mu} *&gt;
        tf: TimeFunction := NIL;   (* NIL =&gt; tfLinear *)
      METHODS
        &lt;* LL &lt; v.mu *&gt;
        init (tf: TimeFunction := NIL): T; (* Default assigns tfLinear to &quot;tf&quot;
                                           if NIL *)

        &lt;* LL &lt;= VBT.mu *&gt;
        start(v: MG.V);
        end(v: MG.V);
        length(v: MG.V; mg: MG.T): INTEGER;
        (* number of animation steps *)

        &lt;* LL &lt;= VBT.mu *&gt;
        doStep (time, timePrev: REAL; v: MG.V; mg: MG.T);
        (* Do a step in the animation from &quot;timePrev&quot; to &quot;time&quot;.
           &quot;time&quot; and &quot;timePrev&quot;have already been transformed by self.tf.map.
           &quot;time&quot; may be greater than, equal to or less than &quot;timePrev&quot;
          *)
      END;

TYPE
  Composite = OBJECT t: T; mg: MG.T END;

TYPE
  Group = MGV.AnimateGroup;

REVEAL
  Group &lt;: GroupPublic;

TYPE
  GroupPublic = T OBJECT
    elems: RefList.T := NIL; (* RefList of &quot;Composite&quot;s *)
  METHODS
    (* must call init method *)
    &lt;* LL = {v.mu} *&gt;
    add(v: MG.V; composite: Composite);
    remove(v: MG.V; composite: Composite);

    iterate(gi: GroupIterator): BOOLEAN;
  END;

TYPE
  GroupIterator = OBJECT
    v: MG.V;
  METHODS
    proc(comp: Composite): BOOLEAN;
  END;

&lt;* LL &lt; v.mu for following procedures *&gt;
PROCEDURE <A HREF="Animate.m3#AddToGroup">AddToGroup</A>(g: Group; v: MG.V; comp: Composite);
PROCEDURE <A HREF="Animate.m3#RemoveFromGroup">RemoveFromGroup</A>(g: Group; v: MG.V; comp: Composite);
PROCEDURE <A HREF="Animate.m3#IterateGroup">IterateGroup</A>(g: Group; v: MG.V; iter: GroupIterator): BOOLEAN;

TYPE
  (* Animation effects *)
  <A HREF="Animate.m3#Linear">Linear</A> &lt;: LinearPublic;
  LinearPublic = T OBJECT
    &lt;* LL = {v.mu} *&gt;
    (* READONLY use methods to set *)
    vector: R2.T;
  METHODS
    (* must call init method *)
    &lt;* LL = {v.mu} *&gt;
    setVector(v: MG.V; READONLY vector: R2.T)
  END;

  <A HREF="Animate.m3#Rotate">Rotate</A> &lt;: RotatePublic;
  RotatePublic = T OBJECT
    &lt;* LL = {v.mu} *&gt;
    (* READONLY use methods to set *)
    origin: R2.T;
    angle: REAL; (* degrees *)
  METHODS
    (* must call init method *)
    &lt;* LL = {v.mu} *&gt;
    setRotate(v: MG.V; READONLY origin: R2.T; angle: REAL);
  END;
  (* rotate &quot;angle&quot; degrees around &quot;origin&quot; clockwise *)

  <A HREF="Animate.m3#Scale">Scale</A> &lt;: ScalePublic;
  ScalePublic = T OBJECT
    &lt;* LL = {v.mu} *&gt;
    (* READONLY use methods to set *)
    wrt: R2.T;
    factor: R2.T;
  METHODS
    (* must call init method *)
    &lt;* LL = {v.mu} *&gt;
    setScale(v: MG.V; READONLY wrt, factor: R2.T);
  END;
  (* &quot;wrt&quot; remains constant in the animation *)

  Path = R2Path.T;

  <A HREF="Animate.m3#Translate">Translate</A> &lt;: TranslatePublic;
  TranslatePublic = T OBJECT
       &lt;* LL = {v.mu} *&gt;
    (* READONLY use methods to set *)
    path: Path;
   METHODS
    (* must call init method *)
    &lt;* LL = {v.mu} *&gt;
    setTranslate(v: MG.V; path: Path);
  END;

  <A HREF="Animate.m3#Weight">Weight</A> &lt;: WeightPublic;
  WeightPublic = T OBJECT
       &lt;* LL = {v.mu} *&gt;
    (* READONLY use methods to set *)
    delta: REAL;
   METHODS
    (* must call init method *)
    &lt;* LL = {v.mu} *&gt;
    setWeightDelta(v: MG.V; delta: REAL);
  END;

  <A HREF="Animate.m3#Highlight">Highlight</A> &lt;: HighlightPublic;
  HighlightPublic = T OBJECT
    (* must call init method *)
  END;
  (* length = 30 *)

  <A HREF="Animate.m3#Visibility">Visibility</A> &lt;: VisibilityPublic;
  VisibilityPublic = T OBJECT
    (* must call init method *)
  END;
  (* length = 30 *)

PROCEDURE <A HREF="Animate.m3#Do">Do</A>(t: T; mg: MG.T; v: MG.V; duration := 1.0) RAISES {Thread.Alerted};
  (* call t.doStep(t.tf.map(time), v, mg) where time increases (roughly linearly)
     from 0.0 to 1.0 so that the animation takes duration seconds.  If
     &quot;duration&quot; = 0.0 then only the last scene (time = 1.0) of the animation
     occurs. t.start is called at the start of the animation and t.end is called
     at the end.  Thread.Alerted may be called before or after any frame
     in the animation.
     LL &lt;= VBT.mu *)
PROCEDURE <A HREF="Animate.m3#Undo">Undo</A>(t: T; mg: MG.T; v: MG.V; duration := 1.0) RAISES {Thread.Alerted};
  (* call t.doStep(t.tf.map(time), v, mg) where time decreases (roughly linearly)
     from 1.0 to 0.0 so that the animation takes duration seconds.  If
     &quot;duration&quot; = 0.0 then only the last scene (time = 0.0) of the animation
     occurs. t.start is called at the start of the animation and t.end is called
     at the end. Thread.Alerted may be called before or after any frame
     in the animation.
     LL &lt;= VBT.mu *)
</PRE> Animations are kept semi-synchronous by maintaining a global <CODE>animation
   time</CODE> based on real time.  Animation time is the real time that has 
   taken place, scaled by the current animation speed.  Each active animation
   calls <CODE>ATime</CODE> to determine the current time of the animation to display.
<P>
   Clients should call ResetAnimationTime at appropriate intervals between
   animations.  A call to Animate.Do/Undo without an intervening <CODE>ResetATime</CODE>
   will only display the final scene of the animation.
<P>
   Calling ResetATime or SetDuration during an animation will have
   undefined results.


<P><PRE>&lt;* LL = Arbitrary *&gt;
PROCEDURE <A HREF="Animate.m3#ATime">ATime</A>(): REAL;
  (* Returns the current animation time.  *)

PROCEDURE <A HREF="Animate.m3#ResetATime">ResetATime</A>();
  (* Resets animation time to 0.  *)

PROCEDURE <A HREF="Animate.m3#SetDuration">SetDuration</A>(seconds: REAL);
  (* Makes 1 second of animation time last &quot;seconds&quot; seconds of real time  *)

END Animate.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
