<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/Animate.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/Animate.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P>
<P><PRE>MODULE <module><implements><A HREF="Animate.i3">Animate</A></implements></module>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="MG.i3">MG</A>, <A HREF="../../vbtkitutils/src/Pts.i3">Pts</A>, <A HREF="R2.i3">R2</A>, <A HREF="R2Box.i3">R2Box</A>, <A HREF="../../formsvbt/src/RefListUtils.i3">RefListUtils</A>, <A HREF="../../geometry/src/Region.i3">Region</A>,
  <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../time/src/Common/Time.i3">Time</A>;

VAR
  etMu := NEW(MUTEX);
  &lt;* LL = etMu *&gt;
  etScale: LONGREAL := 1.0D0; (* = MIN(1000000.0, 1.0/etSeconds) *)
  etStart: Time.T;

PROCEDURE <A NAME="ATime"><procedure>ATime</procedure></A> (): REAL =
  &lt;* LL = arbitrary *&gt;
  BEGIN
    LOCK etMu DO RETURN FLOAT(etScale * (Time.Now() - etStart)) END;
  END ATime;

PROCEDURE <A NAME="ResetATime"><procedure>ResetATime</procedure></A> () =
  BEGIN
    LOCK etMu DO etStart := Time.Now() END
  END ResetATime;

PROCEDURE <A NAME="SetDuration"><procedure>SetDuration</procedure></A> (seconds: REAL) =
  BEGIN
    LOCK etMu DO
      IF seconds = 0.0 THEN etScale := 1.0D0
      ELSE etScale := FLOAT(MIN(1000000.0, 1.0 / seconds), LONGREAL)
      END
    END
  END SetDuration;

&lt;* INLINE *&gt; PROCEDURE <A NAME="DoOneAnimation"><procedure>DoOneAnimation</procedure></A> (t             : T;
                                       time, timePrev: REAL;
                                       v             : MG.V;
                                       mg            : MG.T  ) =
  BEGIN
    t.doStep(t.tf.map(time), t.tf.map(timePrev), v, mg);
  END DoOneAnimation;

PROCEDURE <A NAME="DoAnimation"><procedure>DoAnimation</procedure></A> (t: T; time, timePrev: REAL; v: MG.V; mg: MG.T)
  RAISES {Thread.Alerted} =
  BEGIN
    IF Thread.TestAlert() THEN RAISE Thread.Alerted END;
    DoOneAnimation(t, time, timePrev, v, mg);
    v.mgRedisplay(Region.Empty);
  END DoAnimation;

PROCEDURE <A NAME="Do"><procedure>Do</procedure></A> (t: T; mg: MG.T; v: MG.V; duration := 1.0) RAISES {Thread.Alerted} =
  VAR
    timePrev       := 0.0;
    time           := ATime();
    dt      : REAL;
  BEGIN
    t.start(v);
    dt := duration / FLOAT(MAX(1, t.length(v, mg)));
    WHILE time &lt; duration DO
      WITH pause = dt - (time - timePrev) DO
        IF pause &gt; 0.0 THEN &lt;* ASSERT (pause &lt; 60.0) *&gt;
          Thread.AlertPause(FLOAT(pause, LONGREAL));
        END;
      END;
      DoAnimation(t, time / duration, timePrev / duration, v, mg);
      timePrev := time;
      time := ATime();
    END;
    IF duration = 0.0 THEN
      DoAnimation(t, 1.0, 0.0, v, mg);
    ELSE
      DoAnimation(t, 1.0, timePrev / duration, v, mg);
    END;
    t.end(v);
  END Do;

PROCEDURE <A NAME="Undo"><procedure>Undo</procedure></A> (t: T; mg: MG.T; v: MG.V; duration := 1.0) RAISES {Thread.Alerted} =
  VAR
    timePrev       := 0.0;
    time           := ATime();
    dt      : REAL;
  BEGIN
    t.start(v);
    dt := duration / FLOAT(MAX(1, t.length(v, mg)));
    WHILE time &lt; duration DO
      WITH pause = dt - (time - timePrev) DO
        IF pause &gt; 0.0 THEN &lt;* ASSERT (pause &lt; 60.0) *&gt;
          Thread.AlertPause(FLOAT(pause, LONGREAL));
        END;
      END;
      DoAnimation(t, (duration - time) / duration,
                  (duration - timePrev) / duration, v, mg);
      timePrev := time;
      time := ATime();
    END;
    IF duration = 0.0 THEN
      DoAnimation(t, 0.0, 1.0, v, mg);
    ELSE
      DoAnimation(t, 0.0, (duration - timePrev) / duration, v, mg);
    END;
    t.end(v);
  END Undo;

REVEAL
  <A NAME="T">T</A> = TPublic BRANDED OBJECT
      OVERRIDES
        init   := InitT;
        start  := StartDefault;
        end    := EndDefault;
        length := DefaultLength; (* sic *)
        doStep := DoStepError;
      END;

PROCEDURE <A NAME="InitT"><procedure>InitT</procedure></A> (t: T; tf: TimeFunction := NIL): T =
  BEGIN
    IF tf = NIL THEN t.tf := tfLinear ELSE t.tf := tf END;
    RETURN t;
  END InitT;
PROCEDURE <A NAME="StartDefault"><procedure>StartDefault</procedure></A> (&lt;* UNUSED *&gt; t: T; &lt;* UNUSED *&gt; v: MG.V) =
  BEGIN
  END StartDefault;
PROCEDURE <A NAME="EndDefault"><procedure>EndDefault</procedure></A> (&lt;* UNUSED *&gt; t: T; &lt;* UNUSED *&gt; v: MG.V) =
  BEGIN
  END EndDefault;
PROCEDURE <A NAME="DefaultLength"><procedure>DefaultLength</procedure></A> (&lt;* UNUSED *&gt; t : T;
                         &lt;* UNUSED *&gt; v : MG.V;
                         &lt;* UNUSED *&gt; mg: MG.T  ): INTEGER =
  BEGIN
    RETURN 30
  END DefaultLength;
PROCEDURE <A NAME="DoStepError"><procedure>DoStepError</procedure></A> (&lt;* UNUSED *&gt; t             : T;
                       &lt;* UNUSED *&gt; time, timePrev: REAL;
                       &lt;* UNUSED *&gt; v             : MG.V;
                       &lt;* UNUSED *&gt; mg            : MG.T  ) =
  BEGIN                         &lt;* ASSERT FALSE *&gt;
  END DoStepError;

PROCEDURE <A NAME="MaxLength"><procedure>MaxLength</procedure></A> (v: MG.V; x, y: REAL): INTEGER =
  BEGIN
    RETURN ROUND(MAX(Pts.ToPixels(v, ABS(x), Axis.T.Hor),
               Pts.ToPixels(v, ABS(y), Axis.T.Ver)));
  END MaxLength;

REVEAL
  <A NAME="Group">Group</A> = GroupPublic BRANDED OBJECT
  OVERRIDES
    start := StartGroup;
    end := EndGroup;
    length := LengthGroup;
    doStep := DoStepGroup;
    add := GroupAdd; (* sic *)
    remove := GroupRemove; (* sic *)
    iterate := GroupIterate; (* sic *)
  END;

PROCEDURE <A NAME="Starter"><procedure>Starter</procedure></A>(iter: GroupIterator; comp: Composite): BOOLEAN =
  BEGIN
    comp.t.start(iter.v);
    RETURN TRUE;
  END Starter;

PROCEDURE <A NAME="StartGroup"><procedure>StartGroup</procedure></A>(group: Group; v: MG.V) =
  BEGIN
    EVAL group.iterate(NEW(GroupIterator, v:= v, proc := Starter));
  END StartGroup;

PROCEDURE <A NAME="Ender"><procedure>Ender</procedure></A>(iter: GroupIterator; comp: Composite): BOOLEAN =
  BEGIN
    comp.t.end(iter.v);
    RETURN TRUE;
  END Ender;

PROCEDURE <A NAME="EndGroup"><procedure>EndGroup</procedure></A>(group: Group; v: MG.V) =
  BEGIN
    EVAL group.iterate(NEW(GroupIterator, v:= v, proc := Ender));
  END EndGroup;

TYPE
  IterLength = GroupIterator OBJECT
    length: INTEGER;
  OVERRIDES
    proc := Lengther;
  END;

PROCEDURE <A NAME="Lengther"><procedure>Lengther</procedure></A>(iter: IterLength; comp: Composite): BOOLEAN =
  BEGIN
    iter.length := MAX(iter.length, comp.t.length(iter.v, comp.mg));
    RETURN TRUE;
  END Lengther;

PROCEDURE <A NAME="LengthGroup"><procedure>LengthGroup</procedure></A> (group: Group; v: MG.V; &lt;* UNUSED *&gt; mg: MG.T):
  INTEGER =
  BEGIN
    WITH iter = NEW(IterLength, v := v, length := 0) DO
      EVAL group.iterate(iter);
      RETURN iter.length;
    END;
  END LengthGroup;

TYPE
  IterDoStep = GroupIterator OBJECT
    time, timePrev: REAL;
  OVERRIDES
    proc := DoStepper;
  END;

PROCEDURE <A NAME="DoStepper"><procedure>DoStepper</procedure></A> (iter: IterDoStep; comp: Composite): BOOLEAN =
  BEGIN
    DoOneAnimation(comp.t, iter.time, iter.timePrev, iter.v, comp.mg);
    RETURN TRUE;
  END DoStepper;

PROCEDURE <A NAME="DoStepGroup"><procedure>DoStepGroup</procedure></A> (             group         : Group;
                                    time, timePrev: REAL;
                                    v             : MG.V;
                       &lt;* UNUSED *&gt; mg            : MG.T   ) =
  BEGIN
    EVAL group.iterate(
      NEW(IterDoStep, v := v, time := time, timePrev := timePrev));
  END DoStepGroup;

PROCEDURE <A NAME="AddToGroup"><procedure>AddToGroup</procedure></A>(g: Group; v: MG.V; comp: Composite) =
  BEGIN
    LOCK v.mu DO g.add(v, comp) END
  END AddToGroup;

PROCEDURE <A NAME="RemoveFromGroup"><procedure>RemoveFromGroup</procedure></A>(g: Group; v: MG.V; comp: Composite) =
  BEGIN
    LOCK v.mu DO g.remove(v, comp) END;
  END RemoveFromGroup;

PROCEDURE <A NAME="IterateGroup"><procedure>IterateGroup</procedure></A> (g: Group; v: MG.V; iter: GroupIterator): BOOLEAN =
  BEGIN
    LOCK v.mu DO iter.v := v; RETURN g.iterate(iter) END;
  END IterateGroup;

PROCEDURE <A NAME="GroupAdd"><procedure>GroupAdd</procedure></A> (group: Group; &lt;* UNUSED *&gt; v: MG.V; comp: Composite) =
  BEGIN
    group.elems := RefList.Cons(comp, group.elems);
  END GroupAdd;

PROCEDURE <A NAME="GroupRemove"><procedure>GroupRemove</procedure></A> (group: Group; &lt;* UNUSED *&gt; v: MG.V; comp: Composite) =
  BEGIN
    RefListUtils.DeleteQ(group.elems, comp);
  END GroupRemove;

PROCEDURE <A NAME="GroupIterate"><procedure>GroupIterate</procedure></A> (group: Group; iter: GroupIterator): BOOLEAN =
  VAR f := group.elems;
  BEGIN
    WHILE f # NIL DO
      WITH comp = NARROW(f.head, Composite) DO
        IF NOT iter.proc(comp) THEN RETURN FALSE; END;
      END;
      f := f.tail;
    END;
    RETURN TRUE
  END GroupIterate;

REVEAL
  <A NAME="Linear">Linear</A> = LinearPublic BRANDED OBJECT
           OVERRIDES
             setVector := SetVector;
             length := LengthLinear;
             doStep := DoStepLinear;
           END;

PROCEDURE <A NAME="SetVector"><procedure>SetVector</procedure></A>(t: Linear;  &lt;* UNUSED *&gt; v: MG.V; READONLY vector: R2.T) =
  BEGIN
    t.vector := vector;
  END SetVector;

PROCEDURE <A NAME="LengthLinear"><procedure>LengthLinear</procedure></A> (t: Linear; v: MG.V; &lt;* UNUSED *&gt; mg: MG.T):
  INTEGER =
  BEGIN
    RETURN MaxLength(v, t.vector[0], t.vector[1]);
  END LengthLinear;

PROCEDURE <A NAME="DoStepLinear"><procedure>DoStepLinear</procedure></A> (t: Linear; time, timePrev: REAL; v: MG.V; mg: MG.T) =
  BEGIN
    LOCK v.mu DO
      MG.RTranslateLocked(mg, v, R2.Scale(time - timePrev, t.vector));
    END;
  END DoStepLinear;

REVEAL
  <A NAME="Rotate">Rotate</A> = RotatePublic BRANDED OBJECT
  OVERRIDES
    setRotate := SetRotate;
    length := LengthRotate;
    doStep := DoStepRotate;
  END;

PROCEDURE <A NAME="SetRotate"><procedure>SetRotate</procedure></A>(t: Rotate;  &lt;* UNUSED *&gt; v: MG.V; READONLY origin: R2.T; angle: REAL) =
  BEGIN
    t.origin := origin;
    t.angle := angle;
  END SetRotate;

PROCEDURE <A NAME="Furthest"><procedure>Furthest</procedure></A> (pt: R2.T; bounds: R2Box.T): R2.T =
  BEGIN
    RETURN R2.T{MAX(ABS(bounds[0].lo - pt[0]), ABS(bounds[0].hi - pt[0])),
                MAX(ABS(bounds[1].lo - pt[1]), ABS(bounds[1].hi - pt[1]))}
  END Furthest;

CONST
  DToR = Math.Pi / 180.0;
</PRE> 2 * pi * r * angle / 360 
<PRE>PROCEDURE <A NAME="LengthRotate"><procedure>LengthRotate</procedure></A> (t: Rotate; v: MG.V; mg: MG.T): INTEGER =
  VAR
    r     : R2.T;
    bounds: R2Box.T;
  BEGIN
    LOCK v.mu DO bounds := MG.BoundingBoxLocked(mg, v); END;
    r := Furthest(t.origin, bounds);
    RETURN MaxLength(v, t.angle * DToR * r[0], t.angle * DToR * r[1]);
  END LengthRotate;

PROCEDURE <A NAME="DoStepRotate"><procedure>DoStepRotate</procedure></A> (t: Rotate; time, timePrev: REAL; v: MG.V; mg: MG.T) =
  BEGIN
    LOCK v.mu DO
      MG.RotateLocked(mg, v, (time - timePrev) * t.angle, t.origin);
    END;
  END DoStepRotate;

REVEAL
  <A NAME="Scale">Scale</A> = ScalePublic BRANDED OBJECT
          OVERRIDES
            setScale := SetScale;
            length := LengthScale;
            doStep := DoStepScale;
          END;

PROCEDURE <A NAME="SetScale"><procedure>SetScale</procedure></A>(t: Scale;  &lt;* UNUSED *&gt; v: MG.V; READONLY wrt, factor: R2.T) =
  BEGIN
    t.wrt := wrt;
    t.factor := factor;
  END SetScale;

PROCEDURE <A NAME="LengthScale"><procedure>LengthScale</procedure></A> (t: Scale; v: MG.V; mg: MG.T): INTEGER =
  VAR r: R2.T;
  BEGIN
    LOCK v.mu DO r := Furthest(t.wrt, MG.BoundingBoxLocked(mg, v)); END;
    RETURN MaxLength(v, ABS(t.factor[0] - 1.0) * r[0],
                     ABS(t.factor[1] - 1.0) * r[1]);
  END LengthScale;

PROCEDURE <A NAME="ScaleStep"><procedure>ScaleStep</procedure></A> (time, timePrev, factor: REAL): REAL =
  VAR
    num   := 1.0 + time * (factor - 1.0);
    denom := 1.0 + timePrev * (factor - 1.0);
  BEGIN
    IF denom = 0.0 THEN
      IF num = 0.0 THEN RETURN 1.0 ELSE &lt;* ASSERT FALSE *&gt; END;
    ELSE
      RETURN num / denom;
    END;
  END ScaleStep;
</PRE> scale in arithmetic steps 
<PRE>PROCEDURE <A NAME="DoStepScale"><procedure>DoStepScale</procedure></A> (t: Scale; time, timePrev: REAL; v: MG.V; mg: MG.T) =
  VAR
    dsx := ScaleStep(time, timePrev, t.factor[0]);
    dsy := ScaleStep(time, timePrev, t.factor[1]);
  BEGIN
    LOCK v.mu DO MG.ScaleLocked(mg, v, R2.T{dsx, dsy}, t.wrt) END;
  END DoStepScale;

REVEAL
  <A NAME="Translate">Translate</A> = TranslatePublic BRANDED OBJECT
              OVERRIDES
                setTranslate := SetTranslate;
                start        := StartTranslate;
                end          := EndTranslate;
                length       := LengthTranslate;
                doStep       := DoStepTranslate;
              END;

PROCEDURE <A NAME="SetTranslate"><procedure>SetTranslate</procedure></A>(t: Translate; &lt;* UNUSED *&gt; v: MG.V; path: Path) =
  BEGIN
    t.path := path;
  END SetTranslate;

PROCEDURE <A NAME="StartTranslate"><procedure>StartTranslate</procedure></A> (&lt;* UNUSED *&gt; t: Translate; &lt;* UNUSED *&gt; v: MG.V) =
  BEGIN &lt;* ASSERT FALSE *&gt;
  END StartTranslate;
PROCEDURE <A NAME="EndTranslate"><procedure>EndTranslate</procedure></A> (&lt;* UNUSED *&gt; t: Translate; &lt;* UNUSED *&gt; v: MG.V) =
  BEGIN &lt;* ASSERT FALSE *&gt;
  END EndTranslate;
PROCEDURE <A NAME="LengthTranslate"><procedure>LengthTranslate</procedure></A> (&lt;* UNUSED *&gt; t : Translate;
                            &lt;* UNUSED *&gt; v : MG.V;
                            &lt;* UNUSED *&gt; mg: MG.T       ): INTEGER =
  BEGIN &lt;* ASSERT FALSE *&gt;
  END LengthTranslate;
PROCEDURE <A NAME="DoStepTranslate"><procedure>DoStepTranslate</procedure></A> (&lt;* UNUSED *&gt; t             : Translate;
                           &lt;* UNUSED *&gt; time, timePrev: REAL;
                           &lt;* UNUSED *&gt; v             : MG.V;
                           &lt;* UNUSED *&gt; mg            : MG.T       ) =
  BEGIN &lt;* ASSERT FALSE *&gt;
  END DoStepTranslate;

REVEAL <A NAME="Weight">Weight</A> = WeightPublic BRANDED OBJECT
  OVERRIDES
    setWeightDelta := SetWeightDelta;
    length := LengthWeight;
    doStep := DoStepWeight;
  END;

PROCEDURE <A NAME="SetWeightDelta"><procedure>SetWeightDelta</procedure></A>(t: Weight; &lt;* UNUSED *&gt; v: MG.V; delta: REAL) =
  BEGIN
    t.delta := delta;
  END SetWeightDelta;

PROCEDURE <A NAME="LengthWeight"><procedure>LengthWeight</procedure></A> (t: Weight; v: MG.V; &lt;* UNUSED *&gt; mg: MG.T): INTEGER =
  BEGIN
    RETURN MaxLength(v, t.delta, t.delta)
  END LengthWeight;

PROCEDURE <A NAME="DoStepWeight"><procedure>DoStepWeight</procedure></A> (t: Weight; time, timePrev: REAL; v: MG.V; mg: MG.T) =
  BEGIN
    LOCK v.mu DO
      mg.setWeight(v, mg.weight + (time - timePrev) * t.delta);
    END;
  END DoStepWeight;

REVEAL <A NAME="Highlight">Highlight</A> = HighlightPublic BRANDED OBJECT
  OVERRIDES
    length := LengthHighlight;
    doStep := DoStepHighlight;
  END;

PROCEDURE <A NAME="LengthHighlight"><procedure>LengthHighlight</procedure></A> (&lt;* UNUSED *&gt; t: Highlight; &lt;* UNUSED *&gt; v: MG.V; &lt;* UNUSED *&gt; mg: MG.T): INTEGER =
  BEGIN
    RETURN 30;
  END LengthHighlight;

PROCEDURE <A NAME="DoStepHighlight"><procedure>DoStepHighlight</procedure></A> (&lt;* UNUSED *&gt; t             : Highlight;
                                        time, timePrev: REAL;
                                        v             : MG.V;
                                        mg            : MG.T       ) =
  BEGIN
    LOCK v.mu DO mg.setHighlight(v, mg.highlight + (time - timePrev)); END;
  END DoStepHighlight;

REVEAL <A NAME="Visibility">Visibility</A> = VisibilityPublic BRANDED OBJECT
  OVERRIDES
    length := LengthVisible;
    doStep := DoStepVisible;
  END;

PROCEDURE <A NAME="LengthVisible"><procedure>LengthVisible</procedure></A> (&lt;* UNUSED *&gt; t : Visibility;
                         &lt;* UNUSED *&gt; v : MG.V;
                         &lt;* UNUSED *&gt; mg: MG.T        ): INTEGER =
  BEGIN
    RETURN 30;
  END LengthVisible;

PROCEDURE <A NAME="DoStepVisible"><procedure>DoStepVisible</procedure></A> (&lt;* UNUSED *&gt; t             : Visibility;
                                      time, timePrev: REAL;
                                      v             : MG.V;
                                      mg            : MG.T        ) =
  BEGIN
    LOCK v.mu DO mg.setVisible(v, mg.visible + (time - timePrev)) END;
  END DoStepVisible;

PROCEDURE <A NAME="TFZero"><procedure>TFZero</procedure></A> (&lt;* UNUSED *&gt; tf: TimeFunction; &lt;* UNUSED *&gt; t: REAL): REAL =
  BEGIN
    RETURN 0.0
  END TFZero;

PROCEDURE <A NAME="TFOne"><procedure>TFOne</procedure></A> (&lt;* UNUSED *&gt; tf: TimeFunction; &lt;* UNUSED *&gt; t: REAL): REAL =
  BEGIN
    RETURN 1.0
  END TFOne;

PROCEDURE <A NAME="TFLinear"><procedure>TFLinear</procedure></A> (&lt;* UNUSED *&gt; tf: TimeFunction; t: REAL): REAL =
  BEGIN
    RETURN t
  END TFLinear;

PROCEDURE <A NAME="TFInverse"><procedure>TFInverse</procedure></A> (&lt;* UNUSED *&gt; tf: TimeFunction; t: REAL): REAL =
  BEGIN
    RETURN 1.0 - t
  END TFInverse;

REVEAL
  <A NAME="TimeDiscrete">TimeDiscrete</A> =
    TimeDiscretePublic BRANDED OBJECT OVERRIDES map := TFDiscrete END;

PROCEDURE <A NAME="TFDiscrete"><procedure>TFDiscrete</procedure></A> (tf: TimeDiscrete; t: REAL): REAL =
  BEGIN
    FOR i := 0 TO LAST(tf.values^) DO
      IF tf.values[i].step &gt;= t THEN
        RETURN tf.values[i].value
      END;
    END;
    RETURN tf.values[LAST(tf.values^)].value
  END TFDiscrete;

REVEAL
  <A NAME="TimeStep">TimeStep</A> = TimeStepPublic BRANDED OBJECT OVERRIDES map := TFSteps; END;

PROCEDURE <A NAME="TFSteps"><procedure>TFSteps</procedure></A> (tf: TimeStep; t: REAL): REAL =
  BEGIN
    IF tf.steps = 0 THEN
      RETURN 0.0
    ELSE
      RETURN FLOAT(FLOOR(t * FLOAT(tf.steps))) / FLOAT(tf.steps);
    END;
  END TFSteps;

BEGIN
  tfZero := NEW(TimeFunction, map := TFZero);
  tfOne := NEW(TimeFunction, map := TFOne);
  tfLinear := NEW(TimeFunction, map := TFLinear);
  tfInverse := NEW(TimeFunction, map := TFInverse);
END Animate.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
