<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/Appearances.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/Appearances.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P><PRE>INTERFACE <interface><A HREF="Appearances.m3">Appearances</A></interface>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="MG.i3">MG</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="R2.i3">R2</A>;

TYPE Appearance = MG.Appearance;

TYPE
  <A HREF="Appearances.m3#DropShadow">DropShadow</A> &lt;: DSPublic;
  DSPublic = Appearance OBJECT
               color: PaintOp.ColorScheme;
               delta: R2.T;
             END;
</PRE><BLOCKQUOTE><EM> A DropShadow appearance paints an MG.T twice.  First it paints the
   object offsetting the object's position by <CODE>delta</CODE> and its color to
   <CODE>color</CODE>.  Then it paints the object with its original position and
   color. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="Appearances.m3#DropShadowHighlight">DropShadowHighlight</A> &lt;: DSHPublic;
  DSHPublic = DropShadow;
</PRE><BLOCKQUOTE><EM> A drop shadow appearance where the drop shadow <CODE>delta</CODE> is scaled by the
   object's highlight value.  In an animation that changes the highlight
   value, the effect is to increase the shadow's width and highlight
   increases. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="Appearances.m3#WeightUnderlay">WeightUnderlay</A> &lt;: WUPublic;
  WUPublic = Appearance OBJECT
               weight: REAL;
               color : PaintOp.ColorScheme;
             END;
</PRE><BLOCKQUOTE><EM> A WeightUnderlay appearance paints an MG.T twice.  First it paints the
   object using weight <CODE>weight</CODE> and color <CODE>color</CODE>.  Then it paints the
   object with its original weight and color. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="Appearances.m3#WeightUnderlayHighlight">WeightUnderlayHighlight</A> &lt;: WUHPublic;
  WUHPublic = WeightUnderlay;
</PRE><BLOCKQUOTE><EM> A WeightUnderlay appearance where the weight underlay <CODE>weight</CODE> is scaled
   by the object's highlight value.  In an animation that changes the
   highlight value, the effect is to widen the underlay as highlight
   increases. </EM></BLOCKQUOTE><PRE>

TYPE
  Side = {Left, Right, Top, Bottom};
  Sides = SET OF Side;

  <A HREF="Appearances.m3#Clipped">Clipped</A> &lt;: ClippedPublic;
  ClippedPublic = MG.AppearanceDefault OBJECT
                    sides: Sides := Sides{Side.Left.. Side.Bottom};
                  END;
</PRE><BLOCKQUOTE><EM> A Clipped appearance clips an MG.T proportionally based on the object's
   highlight value.  When highlight = 0, the object is unclipped.  When
   highlight = 1, the object is completely clipped.
<P>
   The clipping rectangle shrinks in from the sides in <CODE>self.sides</CODE>.  If
   two opposing sides are given, the clipping rectangle shrinks to meet in
   the middle.  Otherwise, the clipping rectangle shrinks toward the
   opposite side.
<P>
   In an animation that changes the highlight value, the effect is for the
   shrink as highlight increases. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="Appearances.m3#ColorLineHighlight">ColorLineHighlight</A> &lt;: CLHPublic;
  CLHPublic = Appearance OBJECT
                highlightColor: PaintOp.ColorScheme;
                fromFrom                              := TRUE;
              END;
</PRE><BLOCKQUOTE><EM> A ColorLineHighlight appearance paints an MG.Line in two colors based on
   the line's highlight value.  In an animation that changes the highlight
   value, the effect is to change the color of the line starting at one
   endpoint and moving to the other.  If fromFrom is TRUE, then the color
   change starts at the <CODE>from</CODE> endpoint of the line, otherwise it starts at
   the <CODE>to</CODE> endpoint.
<P>
   It is an error to apply a ColorLineHighlight to an object that isn't a
   subtype of a MG.Line </EM></BLOCKQUOTE><PRE>

END Appearances.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
