<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/CirclePixmapCache.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/CirclePixmapCache.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison 
 

<P><PRE>MODULE <module><implements><A HREF="CirclePixmapCache.i3">CirclePixmapCache</A></implements></module>;

IMPORT <A HREF="CirclePixmap.i3">CirclePixmap</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>;
</PRE> We maintain a cache of circles (ellipses).  There is only one pixmap
   held for each unique width, height, border width and fill mode
   combination.  The /cache/ field in a CirclePixmapCache.T is an array of
   previously-computed pixmaps.  We use an existing pixmap if we already
   have one of the right size, otherwise we create and remember a new one.
   Simple. 

<P><PRE>REVEAL
  <A NAME="T">T</A> = T_Public BRANDED OBJECT
        cache: REF ARRAY OF CacheEntry := NIL;
        count := 0;
      OVERRIDES
        create := Create;
        purge := Purge;
      END;

TYPE
  Config = RECORD
             width, height, border: CARDINAL;
             fill: BOOLEAN;
           END;

  CacheEntry = RECORD
                 pixmap: Pixmap.T;
                 config: Config;
               END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (remember := DEFAULT_REMEMBER): T =
  VAR r := MAX(1, remember);
  BEGIN
    RETURN NEW(T, cache := NEW(REF ARRAY OF CacheEntry, r));
  END New;

PROCEDURE <A NAME="CompareConfig"><procedure>CompareConfig</procedure></A> (READONLY a, b: Config): [-1 .. +1] =
  BEGIN
    IF a.height &lt; b.height THEN
      RETURN -1;
    ELSIF a.height &gt; b.height THEN
      RETURN +1;

    ELSIF a.width &lt; b.width THEN
      RETURN -1;
    ELSIF a.width &gt; b.width THEN
      RETURN +1;

    ELSIF a.border &lt; b.border THEN
      RETURN -1;
    ELSIF a.border &gt; b.border THEN
      RETURN +1;

    ELSIF a.fill &lt; b.fill THEN
      RETURN -1;
    ELSIF a.fill &gt; b.fill THEN
      RETURN +1;
    END;

    RETURN 0;
  END CompareConfig;

PROCEDURE <A NAME="Create"><procedure>Create</procedure></A> (self         : T;
                  width, height: CARDINAL;
                  border       : CARDINAL   := 0;
                  fill                      := TRUE): Pixmap.T =
  VAR
    low, mid, cond := 0;
    high := self.count - 1;
    config := Config{width, height, border, fill};
  BEGIN
    WHILE low &lt;= high DO
      mid := (low + high) DIV 2;
      WITH test = self.cache[mid] DO
        cond := CompareConfig(config, test.config);
      END;
      IF cond &lt; 0 THEN
        high := mid - 1;
      ELSIF cond &gt; 0 THEN
        low := mid + 1;
      ELSE
        RETURN self.cache[mid].pixmap;
      END;
    END;

    (* An ellipse pixmap for these dimensions does not exist---create a new
       one. *)
    VAR insert_at := 0;
    BEGIN
      IF self.count &gt;= NUMBER(self.cache^) THEN
        Purge(self);
      ELSE
        insert_at := self.count;
        FOR i := 0 TO self.count - 1 DO
          WITH test = self.cache[i],
               cond = CompareConfig(config, test.config) DO
            (* Table got unsorted---we're hosed. *)
            &lt;* ASSERT cond # 0 *&gt;
            IF cond &lt; 0 THEN insert_at := i; EXIT; END;
          END;
        END;

        FOR i := self.count TO insert_at + 1 BY -1 DO
          self.cache[i] := self.cache[i - 1];
        END;
      END;

      self.cache[insert_at] :=
        CacheEntry{CirclePixmap.New(width, height, border, fill), config};
      INC(self.count);

      RETURN self.cache[insert_at].pixmap;
    END;
  END Create;

PROCEDURE <A NAME="Purge"><procedure>Purge</procedure></A> (self: T) =
  BEGIN
    self.count := 0;
  END Purge;

BEGIN
END CirclePixmapCache.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
