<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/Fuzzy.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/Fuzzy.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created by stolfi on Thu Jan 26 13:50:19 1989               </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="Fuzzy.m3">Fuzzy</A></interface>;
</PRE>  Interval arithmetic.
<P>
    This interface defines the basic types procedures for interval
    arithmetic. A Fuzzy.T is a closed interval [lo _ hi] of REAL
    numbers (or the empty set).  An interval operation F(I1, I2, ...)
    returns a (hopefully small) interval that contains the result
    of F(x1, x2, ...) for all possible choices of xi in each Ii.
<P>
    Index: numerical routines; interval arithmetic; fuzzy arithmetic
<P>


<P>  NOTE: The routines below (and those in companion interfaces)
    try their best to compensate for floating point rounding errors,
    but do not always succeed.  Clients can compensate for that by
    artificially widening the intervals that are passed to and/or
    returned by these procedures. 

<P><PRE>TYPE
  T = RECORD lo, hi: REAL END;
     (*
       Represents the set of real numbers between &quot;lo&quot; and &quot;hi&quot;, inclusive;
       or the empty set if &quot;lo &gt; hi&quot;. *)

  Pair = ARRAY [0..1] OF T;
</PRE> --- Basics --- 

<P><PRE>CONST Empty = T{1.0, 0.0}; (* The empty set *)
      Full = T{FIRST(REAL), LAST(REAL)}; (* The full set *)
</PRE> --- Test --- 

<P><PRE>PROCEDURE <A HREF="Fuzzy.m3#IsEmpty">IsEmpty</A>(READONLY a: T): BOOLEAN; (* Whether a is empty *)

PROCEDURE <A HREF="Fuzzy.m3#Member">Member</A>(n: REAL; READONLY a: T): BOOLEAN;
  (* whether a real is in an interval *)

PROCEDURE <A HREF="Fuzzy.m3#Overlap">Overlap</A>(READONLY a, b: T): BOOLEAN;
  (* whether two intervals overlap *)

PROCEDURE <A HREF="Fuzzy.m3#Subset">Subset</A>(READONLY a, b: T): BOOLEAN;
  (* wheter a is a subset of b *)
</PRE> --- Transformation --- 

<P><PRE>PROCEDURE <A HREF="Fuzzy.m3#Scale">Scale</A> (s: REAL; READONLY a: T): T ;
  (* Multiplies all points in &quot;a&quot; by the number &quot;s&quot; *)

PROCEDURE <A HREF="Fuzzy.m3#Shift">Shift</A> (s: REAL; READONLY a: T): T ;
  (* Increments all points in &quot;a&quot; by the number &quot;s&quot; *)

PROCEDURE <A HREF="Fuzzy.m3#Expand">Expand</A> (s: REAL; READONLY a: T): T;
  (* Equivalent to Join(Fuzzy.T{s,s}, a) *)

PROCEDURE <A HREF="Fuzzy.m3#Add">Add</A> (READONLY a, b: T): T ;
  (* Addition *)

PROCEDURE <A HREF="Fuzzy.m3#Sub">Sub</A> (READONLY a, b: T): T ;
  (* Subtraction *)

PROCEDURE <A HREF="Fuzzy.m3#Mul">Mul</A> (READONLY a, b: T): T ;
  (* Multiplication *)

PROCEDURE <A HREF="Fuzzy.m3#Sqr">Sqr</A> (READONLY a: T): T ;
  (* Squaring. FAster, and sometimes tighter than Mul(a,a) *)

PROCEDURE <A HREF="Fuzzy.m3#Minus">Minus</A> (READONLY a: T): T;
  (* Negates all points in &quot;a&quot;. *)

PROCEDURE <A HREF="Fuzzy.m3#ClipHi">ClipHi</A> (READONLY a: T; hi: REAL): T;
  (* Chops the top of &quot;a&quot; at &quot;hi&quot;. No-op if hi &gt;= a.hi. *)

PROCEDURE <A HREF="Fuzzy.m3#ClipLo">ClipLo</A> (READONLY a: T; lo: REAL): T;
  (* Chops the bottom of &quot;a&quot; at &quot;lo&quot;. No-op if lo &lt;=  a.lo. *)

PROCEDURE <A HREF="Fuzzy.m3#Sqrt">Sqrt</A> (READONLY a: T): T ;
  (* Set square root. Requires a.lo &gt;= 0.0 *)

PROCEDURE <A HREF="Fuzzy.m3#Join">Join</A> (READONLY a, b: T): T;
  (* Set union *)

PROCEDURE <A HREF="Fuzzy.m3#Meet">Meet</A> (READONLY a, b: T): T;
  (* Set intersection *)

PROCEDURE <A HREF="Fuzzy.m3#Inset">Inset</A>(READONLY a: T; amount: REAL): T ;
  (* Moves both endpoints of &quot;a&quot; inwards by the given amount
    (wich may be negative). *)

PROCEDURE <A HREF="Fuzzy.m3#InsetPair">InsetPair</A>(READONLY a: Pair; amount: REAL): Pair ;
  (* Insets a[0], a[1] by the given amount. *)

PROCEDURE <A HREF="Fuzzy.m3#Fudge">Fudge</A> (READONLY a: T; f: REAL := 0.0001): T;
  (* Widens &quot;a&quot; by &quot;f&quot; times its largest point *)

PROCEDURE <A HREF="Fuzzy.m3#ToText">ToText</A>(READONLY a: T): TEXT;

END Fuzzy.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
