<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/Fuzzy.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/Fuzzy.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created by stolfi on Thu Jan 26 13:55:01 1989               </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="Fuzzy.i3">Fuzzy</A></implements></module>;

IMPORT <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A> (READONLY a: T): BOOLEAN =
  BEGIN
    RETURN a.lo &gt; a.hi
  END IsEmpty;

PROCEDURE <A NAME="Member"><procedure>Member</procedure></A> (n: REAL; READONLY a: T): BOOLEAN =
  BEGIN
    RETURN n &gt;= a.lo AND n &lt;= a.hi
  END Member;

PROCEDURE <A NAME="Overlap"><procedure>Overlap</procedure></A> (READONLY a, b: T): BOOLEAN =
  BEGIN
    RETURN a.hi &gt;= b.lo AND a.lo &lt;= b.hi
  END Overlap;

PROCEDURE <A NAME="Subset"><procedure>Subset</procedure></A> (READONLY a, b: T): BOOLEAN =
  BEGIN
    RETURN a.lo &gt;= b.lo AND a.hi &lt;= b.hi
  END Subset;

PROCEDURE <A NAME="Scale"><procedure>Scale</procedure></A> (s: REAL; READONLY a: T): T =
  BEGIN
    IF a.lo &gt; a.hi THEN RETURN Empty END;
    IF s &lt; 0.0 THEN
      RETURN T{a.hi * s, a.lo * s}
    ELSIF s &gt; 0.0 THEN
      RETURN T{a.lo * s, a.hi * s}
    ELSE (* s = 0.0 *)
      RETURN T{0.0, 0.0}
    END;
  END Scale;

PROCEDURE <A NAME="Shift"><procedure>Shift</procedure></A> (s: REAL; READONLY a: T): T =
  BEGIN
    IF a.lo &gt; a.hi THEN RETURN Empty ELSE RETURN T{a.lo + s, a.hi + s} END
  END Shift;

PROCEDURE <A NAME="Expand"><procedure>Expand</procedure></A> (s: REAL; READONLY a: T): T =
  BEGIN
    IF a.lo &gt; a.hi THEN
      RETURN T{s, s}
    ELSE
      RETURN T{MIN(a.lo, s), MAX(a.hi, s)}
    END;
  END Expand;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (READONLY a, b: T): T =
  BEGIN
    IF a.lo &gt; a.hi OR b.lo &gt; b.hi THEN
      RETURN Empty
    ELSE
      RETURN T{a.lo + b.lo, a.hi + b.hi}
    END
  END Add;

PROCEDURE <A NAME="Sub"><procedure>Sub</procedure></A> (READONLY a, b: T): T =
  BEGIN
    IF a.lo &gt; a.hi OR b.lo &gt; b.hi THEN
      RETURN Empty
    ELSE
      RETURN T{a.lo - b.hi, a.hi - b.lo}
    END;
  END Sub;

PROCEDURE <A NAME="Mul"><procedure>Mul</procedure></A> (READONLY a, b: T): T =
  BEGIN
    IF a.lo &gt; a.hi OR b.lo &gt; b.hi THEN RETURN Empty END;
    IF a.lo &gt;= 0.0 THEN
      IF b.lo &gt;= 0.0 THEN
        RETURN T{a.lo * b.lo, a.hi * b.hi}
      ELSIF b.hi &lt;= 0.0 THEN
        RETURN T{a.hi * b.lo, a.lo * b.hi}
      ELSE
        RETURN T{a.hi * b.lo, a.hi * b.hi}
      END
    ELSIF a.hi &lt;= 0.0 THEN
      IF b.lo &gt;= 0.0 THEN
        RETURN T{a.lo * b.hi, a.hi * b.lo}
      ELSIF b.hi &lt;= 0.0 THEN
        RETURN T{a.hi * b.hi, a.lo * b.lo}
      ELSE
        RETURN T{a.lo * b.hi, a.lo * b.lo}
      END
    ELSE
      IF b.lo &gt;= 0.0 THEN
        RETURN T{a.lo * b.hi, a.hi * b.hi}
      ELSIF b.hi &lt;= 0.0 THEN
        RETURN T{a.hi * b.lo, a.lo * b.lo}
      ELSE
        RETURN T{MIN(a.lo * b.hi, a.hi * b.lo),
                 MAX(a.lo * b.lo, a.hi * b.hi)}
      END
    END;
  END Mul;

PROCEDURE <A NAME="Sqr"><procedure>Sqr</procedure></A> (READONLY a: T): T =
  BEGIN
    IF a.lo &gt; a.hi THEN RETURN Empty END;
    IF a.lo &gt;= 0.0 THEN
      RETURN T{a.lo * a.lo, a.hi * a.hi}
    ELSIF a.hi &lt;= 0.0 THEN
      RETURN T{a.hi * a.hi, a.lo * a.lo}
    ELSE
      RETURN T{0.0, MAX(-a.lo, a.hi) * MAX(-a.lo, a.hi)}
    END;
  END Sqr;

PROCEDURE <A NAME="Minus"><procedure>Minus</procedure></A> (READONLY a: T): T =
  BEGIN
    IF a.lo &gt; a.hi THEN RETURN Empty ELSE RETURN T{-a.hi, -a.lo} END;
  END Minus;

PROCEDURE <A NAME="Sqrt"><procedure>Sqrt</procedure></A> (READONLY a: T): T =
  BEGIN
    IF a.lo &gt; a.hi THEN
      RETURN Empty
    ELSE
      RETURN T{FLOAT(Math.sqrt(FLOAT(a.lo, LONGREAL))),
               FLOAT(Math.sqrt(FLOAT(a.hi, LONGREAL)))}
    END;
  END Sqrt;

PROCEDURE <A NAME="ClipHi"><procedure>ClipHi</procedure></A> (READONLY a: T; hi: REAL): T =
  BEGIN
    IF hi &gt;= a.hi THEN
      RETURN a
    ELSIF a.lo &gt; hi THEN
      RETURN Empty
    ELSE
      RETURN T{a.lo, hi}
    END
  END ClipHi;

PROCEDURE <A NAME="ClipLo"><procedure>ClipLo</procedure></A> (READONLY a: T; lo: REAL): T =
  BEGIN
    IF lo &lt;= a.lo THEN
      RETURN a
    ELSIF lo &gt; a.hi THEN
      RETURN Empty
    ELSE
      RETURN T{lo, a.hi}
    END
  END ClipLo;

PROCEDURE <A NAME="Inset"><procedure>Inset</procedure></A>(READONLY a: T; amount: REAL): T =
  VAR b: T;
  BEGIN
    IF a.lo &gt; a.hi THEN RETURN Empty END;
    b.lo := a.lo + amount;
    b.hi := a.hi - amount;
    IF b.lo &gt; b.hi THEN RETURN Empty END;
    RETURN b
  END Inset;

PROCEDURE <A NAME="InsetPair"><procedure>InsetPair</procedure></A>(READONLY a: Pair; amount: REAL): Pair =
  BEGIN
    RETURN Pair{Inset(a[0], amount), Inset(a[1], amount)}
  END InsetPair;

PROCEDURE <A NAME="Fudge"><procedure>Fudge</procedure></A> (READONLY a: T; f: REAL := 0.0001): T =
  VAR d: REAL;
      b: T;
  BEGIN
    IF a.lo &gt; a.hi THEN RETURN Empty END;
    d := 0.0;
    IF ABS(a.lo) # LAST(REAL) THEN d := MAX(d, f * ABS (a.lo)) END;
    IF ABS(a.hi) # LAST(REAL) THEN d := MAX(d, f * ABS (a.hi)) END;
    IF d = 0.0 THEN RETURN a END;
    IF a.lo &gt; FIRST(REAL) + d THEN b.lo := a.lo - d ELSE b.lo := a.lo END;
    IF a.hi &lt; LAST(REAL) - d THEN b.hi := a.hi + d ELSE b.hi := a.hi END;
    RETURN b
  END Fudge;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A> (READONLY a, b: T): T =
  BEGIN
    IF a.lo &gt; a.hi THEN
      RETURN b
    ELSIF b.lo &gt; b.hi THEN
      RETURN a
    ELSE
      RETURN T{MIN(a.lo, b.lo), MAX(a.hi, b.hi)}
    END
  END Join;

PROCEDURE <A NAME="Meet"><procedure>Meet</procedure></A> (READONLY a, b: T): T =
  VAR t: T;
  BEGIN
    t.lo := MAX(a.lo, b.lo);
    t.hi := MIN(a.hi, b.hi);
    IF t.lo &gt; t.hi THEN
      RETURN Empty
    ELSE
      RETURN t
    END
  END Meet;

PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A>(READONLY a: T): TEXT =
BEGIN
  RETURN &quot;[&quot; &amp; Fmt.Real(a.lo) &amp; &quot;_&quot; &amp; Fmt.Real(a.hi) &amp; &quot;]&quot;
END ToText;

BEGIN
END Fuzzy.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
