<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/MG.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/MG.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P><PRE>INTERFACE <interface><A HREF="MG.m3">MG</A></interface>;

&lt;* PRAGMA LL *&gt;
</PRE> All R2.T coordinates are in Cartesian (XY) space with x increasing
   to the right and y increasing upward 

<P><PRE>IMPORT <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="Matrix2D.i3">Matrix2D</A>, <A HREF="MGV.i3">MGV</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="R2.i3">R2</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="R2Path.i3">R2Path</A>,
<A HREF="R2Box.i3">R2Box</A>;

TYPE
  V = MGV.V;

TYPE
  T = MGV.MGT;

REVEAL
  T &lt;: TPublic;

TYPE
  TPublic =
    OBJECT
      (* all fields READONLY except at initialization or through
         methods *)
      id := NoID;
      (* The ID provided by the algorithm that is associated with
         this element.  Output events from the algorithm are in
         terms of an id which is mapped by the v.lookup method to
         the element.  Input events to the algorithm are in terms
         of the id associated with the element *)

      m := Matrix2D.Identity;
      (* The position of self is m * R2.Origin which is the tx ty
         of a matrix translation. *)

      highlight := 0.0;         (* 0.0 -&gt; normal, 1.0 -&gt; highlit *)
      visible   := 1.0;         (* 0.0 -&gt; invisible, 1.0 -&gt; visible *)
      color     : PaintOp.ColorScheme;  (* !!!  := PaintOp.bgFg*)
      weight                            := 1.0;
      label                             := &quot;&quot;;
      font                              := DefaultFont;
      alignment                         := Alignment.Center;
      appearance: Appearance;

      dirty := FALSE;           (* internal bookkeeping field *)
    METHODS
      &lt;* LL &lt; v.mu *&gt;
      init (v: V := NIL; parent: Group := NIL): T;
      (* If self.appearance is NIL then appearance gets
         AppearanceDefault (paints the object &quot;as is&quot;)

         init also adds self to the group &quot;parent&quot; or, if
         &quot;parent&quot; is NIL and &quot;v&quot; is not NIL, to &quot;v&quot;'s display
         list.

         init also registers self with the lookup table for &quot;v&quot;
         if v is not NIL and self.id is not NoID. *)

      &lt;* LL = v.mu *&gt;
      setColor (v: V; color: PaintOp.ColorScheme (* := PaintOp.bgFg *));
      setFont  (v: V; font := DefaultFont);
      setHighlight  (v: V; highlight := 0.0);
      setVisible    (v: V; visible := 1.0);
      setWeight     (v: V; weight := 1.0);
      setAlignment  (v: V; alignment := Alignment.Center);
      setLabel      (v: V; label := &quot;&quot;);
      setAppearance (v: V; appearance := NIL);
      (* appearance = NIL =&gt; AppearanceDefault;
         appearance.prevAppearance gets set unless appearance =
         NIL *)

      transform (v: V; READONLY m: Matrix2D.T);
      (* apply the 2D transformation to self.  The default
         transform method transforms self.m, subtypes with other
         values must transform the other values themselves or
         either when the transform method is called or when the
         values are read. *)

      render (v: V; VAR (* IN/OUT *) clip: Rect.T);
      (* renders self to the screen.

         repaintRect should be updated to include any dirty
         elements painted (normally only changed when painting a
         group or an appearance.

         Do not call directly, call self.appearance.paint (which
         uses render) *)

      bounds (v: V): R2Box.T;
      (* returns the bounding rectangle of the element (possibly ignoring
         the label).  Do not call directly, call
         self.appearance.boundingBox (which uses boundingBox) *)

      rgn (v: V): Region.T;
      (* returns the (conservative) region the element occupies
         in v in screen pixels (mostly for use by appearance).
         Do not call directly, call self.appearance.region (which
         calls region) *)
    END;

TYPE
  ID = INTEGER;

CONST
  NoID: INTEGER = -1;
  DefaultFont = Font.T{fnt := 923199216};

TYPE
  Alignment = {N, NW, W, SW, S, SE, E, NE, Center};
  (* Label is located outside the bounding box in the direction
     specified by the alignment *)

TYPE
  <A HREF="MG.m3#AppearanceDefault">AppearanceDefault</A> &lt;: Appearance;

VAR
  appearanceDefault: AppearanceDefault;
  (* paints the object &quot;as is&quot; (i.e. no effects) *)

TYPE
  (* An appearance handles highlight effects (drop shadows, underlays,
     marquees, blinking, partial color changes) and other special effects.

     The intention is for an appearance object to be independent of the
     object it affects, so that an apperance can be applied to a group and
     will affect all of the elements in the group.
  *)
  <A HREF="MG.m3#Appearance">Appearance</A> &lt;: AppearancePublic;
  AppearancePublic =
    OBJECT
      &lt;* LL = v.mu *&gt;
      prevAppearance: Appearance := NIL;
      (* the previous appearance of the object for composing appearances *)
    METHODS
      &lt;* LL = v.mu *&gt;
      paint (t: T; v: V; VAR clip: Rect.T);

      boundingBox (t: T; v: V): R2Box.T;
      (* returns the bounding rectagle of the element (possibly ignoring
         the label) *)

      region (t: T; v: V): Region.T;
      (* returns the (conservative) region the element occupies in v in
         screen pixels (mostly for internal use) *)
    END;
</PRE> ------------------------------------------------------------------
    See the Appearances interface for some predefined appearances 
------------------------------------------------------------------ 

<P><PRE>TYPE
  GroupIterator = OBJECT        &lt;* LL = v.mu *&gt;
                    v          : V;
                    recursively: BOOLEAN;
                    fromBack   : BOOLEAN;
                  METHODS       &lt;* LL = v.mu *&gt;
                    proc (t: T): (* more *) BOOLEAN
                  END;

TYPE
  Group = MGV.MGGroup;

REVEAL
  Group &lt;: GroupPublic;

TYPE
  GroupPublic =
    T OBJECT
      &lt;* LL = v.mu *&gt;
      elems: REF ARRAY OF T;
      (* elements are stored in visual back to front order.  elems # NIL *)
      cntElems: INTEGER := 0;   (* cnt of non-nil elements *)
    METHODS
      init (elemsSize               := 4;
            v          : V          := NIL;
            parentGroup: Group      := NIL   ): Group;
      (* initializes elems to an array of &quot;elemsSize&quot; elements (all
         NIL), *)

      &lt;* LL = v.mu *&gt;
      iterate (gi: GroupIterator; recursively := FALSE; fromBack := TRUE):
               BOOLEAN;
      (* iterate over all the elements of the group calling gi.proc until
         it returns FALSE.  Result is false if any proc returned FALSE else
         TRUE *)

      addAfter (v: V; t: T; prev: T := NIL);
      (* prev = NIL -&gt; add as first element
         &quot;t&quot; gets painted on top of (after) &quot;prev&quot;
         first element in the group is on the bottom
       *)
      addBefore (v: V; t: T; next: T := NIL);
      (* next = NIL -&gt; add as last element
         &quot;t&quot; gets painted underneath (before) &quot;next&quot;
         last element of the group is on top
      *)

      top    (v: V; t: T);
      (* make &quot;t&quot; the last element in the group *)
      bottom (v: V; t: T);
      (* make &quot;t&quot; the first element in the group *)

      remove (v: V; t: T);
      (* remove &quot;t&quot; from the group *)
    END;

TYPE
  <A HREF="MG.m3#Label">Label</A> &lt;: LabelPublic;
  LabelPublic = T OBJECT (* must call init method *) END;

TYPE
  <A HREF="MG.m3#Line">Line</A> &lt;: LinePublic;
  LinePublic =
    T OBJECT
      style         := VBT.EndStyle.Round;
      to   : R2.T;
      (* Pos(self) is &quot;from&quot; point of the line self.m * self.to is &quot;to&quot;
         point.  Call &quot;MGPublic.LineTo&quot; or &quot;MG.LineToLocked&quot; to get the
         &quot;to&quot; position of the line. &quot;weight&quot; is interpreted as the
         thickness of the line.  If &quot;weight&quot; &lt;= 0 the line is invisible. *)
    METHODS
      init (READONLY from, to: R2.T; v: V := NIL; group: Group := NIL):
            Line;

      (* LL = v.mu *)
      setStyle (v: V; style := VBT.EndStyle.Round);
      reshape  (v: V; READONLY from, to: R2.T);
    END;

TYPE
  <A HREF="MG.m3#LineEnd">LineEnd</A> &lt;: LineEndPublic;
  LineEndPublic = T OBJECT
    line: Line := NIL;
    controlsFrom := TRUE;
  METHODS
    (* must call init method *)
  END;
  (* Identical behaviour to line except that the transform method
     only affects the from or to endpoint (depending on controlsFrom).
     Only the &quot;from&quot; end of a line repaints it.

     This is useful for creating a group affecting only one endpoint of
     the line.

     (Uses standard init method)
   *)

TYPE
  <A HREF="MG.m3#Rectangle">Rectangle</A> &lt;: RectanglePublic;
  RectanglePublic =
    T OBJECT
      ne: R2.T;                 (* Pos(self) is southwest corner of the
                                   rectangle.  self.m * self.ne is
                                   northeast corner. *)
    METHODS
      init (READONLY corner1, corner2: R2.T;
                     v               : V          := NIL;
                     group           : Group      := NIL   ): Rectangle;

      (* LL = v.mu *)
      reshape (v: V; READONLY corner1, corner2: R2.T);
    END;
    (* The rectangle is painted in the background color of the paint scheme.
       The weight is interpreted as the thickness of an inset border
       around the rectangle.  The color of the border is the foreground
       color of the color scheme *)

TYPE
  <A HREF="MG.m3#Ellipse">Ellipse</A> &lt;: EllipsePublic;
  EllipsePublic =
    T OBJECT
      ne: R2.T;                 (* Pos(self) is southwest corner of the
                                   ellipse.  self.m * self.ne is
                                   northeast corner. *)
    METHODS
      init (READONLY corner1, corner2: R2.T;
                     v          : V          := NIL;
                     group      : Group      := NIL   ): Ellipse;

      (* LL = v.mu *)
      reshape (v: V; READONLY corner1, corner2: R2.T);
    END;
    (* The ellipse is painted in the background color of the color scheme.
       The weight is interpreted as the thickness of an
       inset border around the ellipse.  The color of the border is the
       foreground color of the color scheme. *)

TYPE
  <A HREF="MG.m3#Shape">Shape</A> &lt;: ShapePublic;
  ShapePublic =
    T OBJECT
    METHODS
      init (READONLY origin: R2.T;
            READONLY path: R2Path.T;
            READONLY fill := TRUE;
                     v          : V          := NIL;
                     group      : Group      := NIL   ): Shape;

      (* LL = v.mu *)
      reshape (v: V; READONLY origin: R2.T; READONLY path: R2Path.T; READONLY fill := TRUE);
    END;
  (* A filled shape uses odd winding to determine the inside/outside of the shape.
     &quot;weight&quot; is interpreted as the thickness of the stroke following the path.
     If &quot;weight&quot; is &lt;= 0, then the stroke is invisible.  *)

&lt;* LL = v.mu for following procedures *&gt;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#PosLocked">PosLocked</A> (t: T; v: V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#SetPosLocked">SetPosLocked</A> (t: T; READONLY pos: R2.T; v: V);

&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#LineFromLocked">LineFromLocked</A> (line: Line; v: V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#LineToLocked">LineToLocked</A> (line: Line; v: V): R2.T;

&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#RectangleSWLocked">RectangleSWLocked</A> (rectangle: Rectangle; v: V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#RectangleNELocked">RectangleNELocked</A> (rectangle: Rectangle; v: V): R2.T;

&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#EllipseSWLocked">EllipseSWLocked</A> (ellipse: Ellipse; v: V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#EllipseNELocked">EllipseNELocked</A> (ellipse: Ellipse; v: V): R2.T;

&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#ShapeOriginLocked">ShapeOriginLocked</A> (shape: Shape; v: V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#ShapePathLocked">ShapePathLocked</A> (shape: Shape; v: V): R2Path.T;

&lt;* INLINE *&gt;
  PROCEDURE <A HREF="MG.m3#BoundingBoxLocked">BoundingBoxLocked</A> (t: T; v: V): R2Box.T;

PROCEDURE <A HREF="MG.m3#RTranslateLocked">RTranslateLocked</A> (t: T; v: V; READONLY by: R2.T);
PROCEDURE <A HREF="MG.m3#TranslateToLocked">TranslateToLocked</A> (         t     : T;
                                      v     : V;
                             READONLY dest  : R2.T;
                                      center         := FALSE);
PROCEDURE <A HREF="MG.m3#ScaleLocked">ScaleLocked</A> (         t     : T;
                                v     : V;
                       READONLY factor      := R2.Ones;
                       READONLY wrt         := R2.Origin);
PROCEDURE <A HREF="MG.m3#RotateLocked">RotateLocked</A> (         t     : T;
                                 v     : V;
                                 angle : REAL;
                        READONLY origin         := R2.Origin);
</PRE><BLOCKQUOTE><EM> Rotate by <CODE>angle</CODE> degrees counter clockwise around <CODE>origin</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#TransformLocked">TransformLocked</A> (t: T; v: V; READONLY m: Matrix2D.T);
</PRE> Conversion procedures 
<PRE>&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#ScreenPointToMGC">ScreenPointToMGC</A> (v: V; READONLY pt: Point.T): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#MGCToScreenPoint">MGCToScreenPoint</A> (v: V; READONLY p: R2.T): Point.T;
&lt;* INLINE *&gt;
PROCEDURE <A HREF="MG.m3#MGCToScreenRect">MGCToScreenRect</A> (v: V; READONLY corner1, corner2: R2.T):
  Rect.T;
</PRE><BLOCKQUOTE><EM> MGCToScreenRect will produce Rect.Empty if the screen points of corner1 and corner2
   coincide.  Use:
     Rect.Join(Rect.FromPoint(MGCToScreenPoint(corner1)), 
               Rect.FromPoint(MGCScreenPoint(corner2)))
   if you need a non-empty rectangle </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#ResetLookupsLocked">ResetLookupsLocked</A>(v: V);
</PRE><BLOCKQUOTE><EM> Clear the lookup table for <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

END MG.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
