<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/MGPaintOp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/MGPaintOp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P><PRE>MODULE <module><implements><A HREF="MGPaintOp.i3">MGPaintOp</A></implements></module>;

IMPORT <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="../../ui/src/vbt/Palette.i3">Palette</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/PlttFrnds.i3">PlttFrnds</A>, <A HREF="../../ui/src/vbt/ScrnColorMap.i3">ScrnColorMap</A>, <A HREF="../../ui/src/vbt/ScrnPaintOp.i3">ScrnPaintOp</A>,
       <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTRep.i3">VBTRep</A>;

TYPE
  Closure = Palette.OpClosure OBJECT
    rgb: RGB;
  OVERRIDES
    apply := Apply;
  END;

VAR
  mu := NEW(MUTEX);
  (* protects table *)
  table := NEW(IntRefTbl.Default).init();

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (rgb: RGB): PaintOp.T =
  VAR
    cl := NEW(Closure, rgb := rgb);
    op := Palette.FromOpClosure(cl);
  BEGIN
    LOCK mu DO EVAL table.put(op.op, cl); END;
    RETURN op
  END New;

PROCEDURE <A NAME="RGBTo24BitPixel"><procedure>RGBTo24BitPixel</procedure></A> (rgb: RGB): INTEGER =
  BEGIN
    RETURN ROUND(rgb.r * 255.0) * 256 * 256
             + ROUND(rgb.g * 255.0) * 256 + ROUND(rgb.b * 255.0)
  END RGBTo24BitPixel;

&lt;* FATAL TrestleComm.Failure, ScrnPaintOp.Failure *&gt;
PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (cl: Closure; st: VBT.ScreenType): ScrnPaintOp.T =
  VAR
    cmap: ScrnColorMap.T;
    pix : INTEGER;
    t   : ScrnPaintOp.T;
  BEGIN
    IF st.depth = 24 THEN
      t := st.op.opaque(RGBTo24BitPixel(cl.rgb));
    ELSIF st.cmap = NIL THEN
      t := st.op.opaque(1);
    ELSE
      TRY
        cmap := st.cmap.standard();
        pix := cmap.new(1).lo;
      EXCEPT
      | ScrnColorMap.Failure =&gt; RETURN st.op.opaque(1);
      END;
      t := st.op.opaque(pix);
      TRY
        cmap.write(ARRAY [0 .. 0] OF
                     ScrnColorMap.Entry{ScrnColorMap.Entry{pix, cl.rgb}});
      EXCEPT
      | ScrnColorMap.Failure =&gt;
      END;
    END;
    RETURN t
  END Apply;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (st: VBT.ScreenType; op: PaintOp.T; rgb: RGB) =
  VAR
    cl: Closure;
    ra: REFANY;
  BEGIN
    LOCK mu DO
      EVAL table.get(op.op, ra);
      cl := NARROW(ra, Closure);
    END;
    cl.rgb := rgb;
    IF st.depth = 24 THEN
</PRE><BLOCKQUOTE><EM><P>
      VAR po := st.ops[op.op];
      BEGIN
        po.pix := RGBTo24BitPixel(rgb);
      END;
</EM></BLOCKQUOTE><PRE>
    ELSE
      IF st.cmap # NIL THEN
        VAR
          cmap := st.cmap.standard();
          po   := st.ops[op.op];
        BEGIN
          IF po = NIL OR po = PlttFrnds.noOp THEN
            po := Palette.ResolveOp(st, op)
          END;
          TRY
            cmap.write(
              ARRAY [0 .. 0] OF
                ScrnColorMap.Entry{ScrnColorMap.Entry{po.pix, rgb}});
          EXCEPT
          | ScrnColorMap.Failure =&gt;
          END;
        END;
      END;
    END;
  END Set;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (op: PaintOp.T): RGB =
  VAR
    ra: REFANY;
  BEGIN
    LOCK mu DO
      EVAL table.get(op.op, ra);
      RETURN NARROW(ra, Closure).rgb;
    END;
  END Get;

BEGIN
END MGPaintOp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
