<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/MGPublic.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/MGPublic.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P>
<P><PRE>INTERFACE <interface><A HREF="MG.m3">MGPublic</A></interface>;

&lt;* PRAGMA LL *&gt;
</PRE> This interface provides the convenience routines for manipulating MG
   elements 
   
<P><PRE>IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="Matrix2D.i3">Matrix2D</A>, <A HREF="MG.i3">MG</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="R2.i3">R2</A>, <A HREF="R2Box.i3">R2Box</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="R2Path.i3">R2Path</A>;

&lt;* LL &lt; v.mu for all procedures *&gt;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#Pos">Pos</A>(t: MG.T; v: MG.V): R2.T;
</PRE><BLOCKQUOTE><EM> Return the position of t.  Exact interpretation depends on the 
   subtype.  Logically it returns t.m * R2.Origin </EM></BLOCKQUOTE><PRE>

&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#LineFrom">LineFrom</A>(line: MG.Line; v: MG.V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#LineTo">LineTo</A>(line: MG.Line; v: MG.V): R2.T;

&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#RectangleSW">RectangleSW</A>(rectangle: MG.Rectangle; v: MG.V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#RectangleNE">RectangleNE</A>(rectangle: MG.Rectangle; v: MG.V): R2.T;

&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#EllipseSW">EllipseSW</A>(ellipse: MG.Ellipse; v: MG.V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#EllipseNE">EllipseNE</A>(ellipse: MG.Ellipse; v: MG.V): R2.T;

&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#ShapeOrigin">ShapeOrigin</A>(shape: MG.Shape; v: MG.V): R2.T;
&lt;* INLINE *&gt; PROCEDURE <A HREF="MG.m3#ShapePath">ShapePath</A>(shape: MG.Shape; v: MG.V := NIL): R2Path.T;

PROCEDURE <A HREF="MG.m3#IterateGroup">IterateGroup</A> (group      : MG.Group;
                        iter       : MG.GroupIterator;
                        recursively                     := FALSE;
                        fromBack                        := TRUE   ):
  BOOLEAN;
</PRE><BLOCKQUOTE><EM> If <CODE>recursively</CODE> then groups within <CODE>group</CODE> are also iterated so that
   all leaf nodes are depth first.  Group nodes are visited after all of
   their descendants.
<P>
   IF <CODE>fromBack</CODE> then the nodes are visited in visual back to front order
   else from front to back.
<P>
   Result is false if any proc returned FALSE else TRUE </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#AddToGroup">AddToGroup</A> (group: MG.Group; v: MG.V; t: MG.T; atTop := TRUE);
PROCEDURE <A HREF="MG.m3#AddToGroupAfter">AddToGroupAfter</A> (group: MG.Group;
                           v    : MG.V;
                           t    : MG.T;
                           prev : MG.T       := NIL);
PROCEDURE <A HREF="MG.m3#AddToGroupBefore">AddToGroupBefore</A> (group: MG.Group;
                            v    : MG.V;
                            t    : MG.T;
                            next : MG.T       := NIL);
PROCEDURE <A HREF="MG.m3#RemoveFromGroup">RemoveFromGroup</A> (group: MG.Group; v: MG.V; t: MG.T);
PROCEDURE <A HREF="MG.m3#TopInGroup">TopInGroup</A> (group: MG.Group; v: MG.V; t: MG.T);
PROCEDURE <A HREF="MG.m3#BottomInGroup">BottomInGroup</A> (group: MG.Group; v: MG.V; t: MG.T);

PROCEDURE <A HREF="MG.m3#Register">Register</A> (v: MG.V; id: MG.ID; t: MG.T);
</PRE><BLOCKQUOTE><EM> Register <CODE>t</CODE> in <CODE>v</CODE>'s with <CODE>id</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#Lookup">Lookup</A> (v: MG.V; id: MG.ID): MG.T;
</PRE><BLOCKQUOTE><EM> Lookup <CODE>id</CODE> in <CODE>v</CODE>'s lookup table and return the corresponding element.
   Returns NIL if id = NoID or id is not registered with v. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#Clear">Clear</A>(v: MG.V);
</PRE><BLOCKQUOTE><EM> Clear <CODE>v</CODE> of any visual state -
   Reset the lookup table, clear the display list, delete any animations </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#ResetLookups">ResetLookups</A>(v: MG.V);
</PRE><BLOCKQUOTE><EM> Clear the lookup table for <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#BoundingBox">BoundingBox</A> (t: MG.T; v: MG.V): R2Box.T;
PROCEDURE <A HREF="MG.m3#SetColor">SetColor</A> (t: MG.T; v: MG.V; color: PaintOp.ColorScheme);
PROCEDURE <A HREF="MG.m3#SetFont">SetFont</A> (t: MG.T; v: MG.V; font: Font.T);
PROCEDURE <A HREF="MG.m3#SetHighlight">SetHighlight</A> (t: MG.T; v: MG.V; highlight := 1.0);
PROCEDURE <A HREF="MG.m3#SetVisible">SetVisible</A> (t: MG.T; v: MG.V; visible := 1.0);
PROCEDURE <A HREF="MG.m3#SetWeight">SetWeight</A> (t: MG.T; v: MG.V; weight := 1.0);
PROCEDURE <A HREF="MG.m3#SetAlignment">SetAlignment</A> (t: MG.T; v: MG.V; alignment := MG.Alignment.Center);
PROCEDURE <A HREF="MG.m3#SetLabel">SetLabel</A> (t: MG.T; v: MG.V; label := &quot;&quot;);
PROCEDURE <A HREF="MG.m3#SetAppearance">SetAppearance</A> (t: MG.T; v: MG.V; appearance: MG.Appearance := NIL);

PROCEDURE <A HREF="MG.m3#SetLineStyle">SetLineStyle</A> (line: MG.Line; v: MG.V; style := VBT.EndStyle.Round);
PROCEDURE <A HREF="MG.m3#SetLineReshape">SetLineReshape</A> (line: MG.Line; v: MG.V; READONLY from, to: R2.T);
PROCEDURE <A HREF="MG.m3#SetRectangleReshape">SetRectangleReshape</A> (         rect            : MG.Rectangle;
                                        v               : MG.V;
                               READONLY corner1, corner2: R2.T          );

PROCEDURE <A HREF="MG.m3#RTranslate">RTranslate</A> (t: MG.T; v: MG.V; READONLY by: R2.T);
</PRE><BLOCKQUOTE><EM> translate t.pos by <CODE>by</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#TranslateTo">TranslateTo</A> (         t     : MG.T;
                                v     : MG.V;
                       READONLY dest  : R2.T;
                                center         := FALSE);
</PRE><BLOCKQUOTE><EM> Convenience procedures to move t.pos to <CODE>dest</CODE> (or to center t around
   <CODE>dest</CODE> if <CODE>center</CODE>) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#Scale">Scale</A> (         t     : MG.T;
                          v     : MG.V;
                 READONLY factor         := R2.Ones;
                 READONLY wrt            := R2.Origin);
</PRE><BLOCKQUOTE><EM> scale t by <CODE>factor[0]</CODE> horizontally and <CODE>factor[1]</CODE> vertically, with
   respect to the point <CODE>wrt</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#Rotate">Rotate</A> (         t     : MG.T;
                           v     : MG.V;
                           angle : REAL;
                  READONLY origin         := R2.Origin);
</PRE><BLOCKQUOTE><EM> Rotate t around <CODE>origin</CODE> by <CODE>angle</CODE> degrees </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MG.m3#Transform">Transform</A> (t: MG.T; v: MG.V; READONLY m: Matrix2D.T);
</PRE><BLOCKQUOTE><EM> Transform <CODE>t</CODE> by <CODE>m</CODE> </EM></BLOCKQUOTE><PRE>

&lt;* LL arbitrary for following procedures *&gt;
VAR defaultColor: PaintOp.ColorScheme;

PROCEDURE <A HREF="MG.m3#OpFromName">OpFromName</A> (name: TEXT; mode := PaintOp.Mode.Accurate):
  PaintOp.T;

PROCEDURE <A HREF="MG.m3#ColorFromText">ColorFromText</A> (bg, fg: TEXT := NIL; mode := PaintOp.Mode.Accurate):
  PaintOp.ColorScheme;
PROCEDURE <A HREF="MG.m3#ColorFromRGB">ColorFromRGB</A> (bg, fg: Color.T; mode := PaintOp.Mode.Accurate):
  PaintOp.ColorScheme;
</PRE><BLOCKQUOTE><EM> Returns the color scheme for the colors specifed by <CODE>bg</CODE> and <CODE>fg</CODE> (for
   <CODE>color</CODE> the texts are interpreted by ColorName.ToRGB) </EM></BLOCKQUOTE><PRE>

END MGPublic.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
