<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/MGV.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/MGV.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P><PRE>INTERFACE <interface><A HREF="MGV.m3">MGV</A></interface>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="R2.i3">R2</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="MGV.m3#V">V</A> &lt;: VPublic;
  VPublic =
    VBT.Leaf OBJECT
      mu: MUTEX;                &lt;* LL: VBT.mu &lt; Z.mu &lt; v.mu &lt; v *&gt;
      (* At the MG level, VBT.mu may or may not be held, Z.mu is normally
         held, v.mu is held or is acquired, v is not held.

         v.mu protects all fields listed below, and all elements associated
         with v *)

      &lt;* LL = self.mu *&gt;

      border := ARRAY Axis.T OF REAL{10.0, 10.0};
      (* a border around the displayed graphics *)

      animations: AnimateGroup := NIL;
      (* the list of pending animations.  Use self.animations.add to
         add a pending animation.  Operations that produce animations
         must call Animate at some point to activate the animations.
       *)

      nonOverlappingElements: BOOLEAN := FALSE;
      (* nonOverlappingElements is an efficiency hint to procedures which
         alter the visual state of MG elements.

         If there are overlapping elements, then the region
         corresponding to the changed element is added to the
         dirty region and the window is marked for repainting.

         If there are no overlapping elements, then the changed
         element can be repainted immediately.
      *)

      view: VBT.T; (* View.T *)
      (* the view containing self.  Needed for feedback events *)

      selector: Selector := NIL;
      (* self.selector.select is called when a mouse click is received by
         self.mouse.  A NIL selector defaults to closestSelector. *)

      selectee: Selectee := NIL;
      (* self.selectee.select is called with the result of
         self.selector.select when a mouse click is received.  A NIL
         selectee defaults to a selectee that does nothing. *)

      (* The mouse/selector/selectee methods combine to define the
         selection actions on a V.  The mouse method normally just
         translates the mouse point from screen coordinates to MG
         coordinates.

         selector.select does low-level, element oriented selection.  It is
         called with v.mu locked and finds the element(s) that are
         selected.  The default selector returns the closest element, but
         other selectors could return the closest group, a group of the
         elements within some distance, the group containing the closest
         ellipse, etc.

         selectee.select handles the higher-level actions of the selection.
         It is called with whatever elements the selector returns.  It is
         normally view specific and handles the highlight actions
         associated with the selection and the input events to the
         algorithm.  The default selectee does nothing. *)

      doubleBuffer: BOOLEAN := TRUE;

      displayList: MGGroup;
      (* all elements in the displayList will paint on V's screen *)

      lookup: IntRefTbl.T;
      (* The table mapping element IDs provided by the algorithm to
         elements in the view. *)

      (* READONLY except at initialization or through methods *)
      nw := R2.Origin;
      (* nw is the offset of the north west corner of the window relative
         to the MG origin *)

      dirtyRegion := Rect.Empty;
      (* Internal bookkeeping field

         Any action on an element in the display list, that could leave a
         portion of the screen out of date, should add that area to the
         dirtyRegion.  During Repaint and Redisplay that area will get
         repainted. *)

      paintVBT: VBT.Leaf;
      (* this is the VBT that painting actions are done on (for double
         buffering) *)

      shapeVBT: VBT.Leaf;
      (* this is the VBT that shape painting is done on (for path
         rendering) *)
    METHODS
      &lt;* LL &lt; self.mu *&gt;
      init (): V;               (* allocates empty displayList *)

      &lt;* LL = VBT.mu *&gt;
      setDoubleBuffer (yes: BOOLEAN);

      &lt;* LL &lt;=VBT.mu *&gt;
      mgRedisplay(READONLY br: Region.T);
      (* Similar to the VBT redisplay method, except that the
         LL is more liberal - can be called without VBT.mu *)

      &lt;* LL = self.mu *&gt;
      setNW       (nw := R2.Origin);
      setSelector (selector: Selector := NIL);
      (* sets self.selector to selectorClosest if &quot;selector&quot; = NIL *)
      setSelectee (selectee: Selectee := NIL);
      (* sets self.selectee to a default selectee if &quot;selectee&quot; = NIL *)
    END;

TYPE
  <A HREF="MGV.m3#Selector">Selector</A> &lt;: SelectorPublic;
  SelectorPublic = OBJECT
    METHODS
      &lt;* LL = {VBT.mu, Z.mu, v.mu *&gt;
      select(v: V; READONLY pos: R2.T; READONLY cd: VBT.MouseRec): MGT;
      (* v.selector.select is called synchronously in VBT event time when a
         mouse event is received by v.  It can implement any policy it
         wishes to select and return an element (or none) *)
    END;

VAR
  selectorClosest: Selector;
  (* returns the first element (in top down visual order) which contains
     &quot;pos&quot; in its bounding box or the element whose bounding box is closest
     to &quot;pos&quot; *)
</PRE> ------------------------------------------------------------------
    See the TypeSelector interface for generating some types of selectors 
------------------------------------------------------------------ 

<P><PRE>TYPE
  <A HREF="MGV.m3#Selectee">Selectee</A> &lt;: SelecteePublic;
  SelecteePublic = OBJECT
    METHODS
      &lt;* LL = {VBT.mu, Z.mu} *&gt;
      select(v: V; t: MGT; READONLY cd: VBT.MouseRec);
      (*  v.selectee.select is called synchronously in VBT event time with the
         result of calling v.selector.select.  It may perform any action
         on t or any other element.
      *)
    END;
</PRE><PRE>
      Here are 2 potential Shape methods.  ShapeStretchy is the default 
    </PRE>
for an MGV.T
<P>
   ShapeFixed returns a size range of {pref, pref, pref + 1}
<P>
   ShapeStretchy returns a size range of 
     {0, pref, MAX(pref + 1, VBT.DefaultShape.hi)}
 
<PRE>PROCEDURE <A HREF="MGV.m3#ShapeFixed">ShapeFixed</A>(v: V; ax: Axis.T; n: CARDINAL): VBT.SizeRange;
PROCEDURE <A HREF="MGV.m3#ShapeStretchy">ShapeStretchy</A>(v: V; ax: Axis.T; n: CARDINAL): VBT.SizeRange;
</PRE> Here are 2 potential Reshape methods.  ReshapeSWOrigin is the 
   default for an MGV.T.
<P>
   ReshapeSWOrigin moves the MG graphical origin to the south west
   corner of <CODE>v</CODE>.
<P>
   ReshapeLeaveOrigin leaves the MG graphical origin alone when
   <CODE>v</CODE> is reshaped.  It leaves the v.nw value unchanged so
   that views that display themselves relative to the NW corner
   of the window or which set v.nw should use this reshape 
   method.

<PRE>PROCEDURE <A HREF="MGV.m3#ReshapeSWOrigin">ReshapeSWOrigin</A>(v: V; READONLY cd: VBT.ReshapeRec);
PROCEDURE <A HREF="MGV.m3#ReshapeLeaveOrigin">ReshapeLeaveOrigin</A>(v: V; READONLY cd: VBT.ReshapeRec);

PROCEDURE <A HREF="MGV.m3#AddAnimation">AddAnimation</A> (v: V; animation: AnimateT; mg: MGT);
&lt;* LL &lt; v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Add <CODE>animation</CODE> applied to <CODE>mg</CODE> to the group of animations
   pending on <CODE>v</CODE>.  The animation may be <CODE>played</CODE> by calling
   Animation(v). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MGV.m3#AddAnimationLocked">AddAnimationLocked</A> (v: V; animation: AnimateT; mg: MGT);
&lt;* LL.sup = v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Like AddAnimation, but locked. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MGV.m3#Animation">Animation</A>(v: V; duration := 1.0) RAISES {Thread.Alerted};
&lt;* LL &lt; v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Play the pending animations on <CODE>v</CODE> in duration seconds. If 
   <CODE>duration</CODE> = 0.0 then the animation will occur in a single
   update.  </EM></BLOCKQUOTE><PRE>
</PRE> the following definitions are for interface structural reasons 
<PRE>TYPE
  MGT &lt;: REFANY; (* A MGT is actually an MG.T *)
  MGGroup &lt;: REFANY; (* A MGGroup is actually an MG.Group *)
  AnimateT &lt;: REFANY; (* An AnimateT is actually an Animate.T *)
  AnimateGroup &lt;: REFANY; (* An AnimateGroup is actually an Animate.Group *)

END MGV.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
