<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/MGV.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/MGV.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P>
<P>
<P>
<P><PRE>MODULE <module><implements><A HREF="MGV.i3">MGV</A></implements></module>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="Animate.i3">Animate</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/trestle/InstalledVBT.i3">InstalledVBT</A>, <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="MG.i3">MG</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../geometry/src/Point.i3">Point</A>,
       <A HREF="../../vbtkitutils/src/Pts.i3">Pts</A>, <A HREF="R2.i3">R2</A>, <A HREF="R2Box.i3">R2Box</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="../../ui/src/vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>,
       <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>;

REVEAL
  <A NAME="V">V</A> = VPublic BRANDED OBJECT
      OVERRIDES
        rescreen        := RescreenV;
        reshape         := ReshapeSWOrigin;
        shape           := ShapeStretchy;
        repaint         := RepaintV;
        redisplay       := RedisplayV;
        mouse           := MouseV;
        init            := InitV;
        setNW           := SetNW;
        setDoubleBuffer := SetDoubleBuffer;
        setSelector     := SetSelector;
        setSelectee     := SetSelectee;
        mgRedisplay     := MGRedisplay;
      END;

PROCEDURE <A NAME="InitV"><procedure>InitV</procedure></A>(v: V): V =
  BEGIN
    v.mu := NEW(MUTEX);
    v.displayList := NEW(MG.Group).init();
    v.lookup := NEW(IntRefTbl.Default).init();
    v.paintVBT := v;
    IF v.selector = NIL THEN v.selector := selectorClosest END;
    IF v.selectee = NIL THEN v.selectee := selecteeDefault END;
    RETURN v;
  END InitV;

PROCEDURE <A NAME="RedisplayV"><procedure>RedisplayV</procedure></A>(v: V) =
  BEGIN
    v.mgRedisplay(Region.Empty);
  END RedisplayV;

PROCEDURE <A NAME="SetSelector"><procedure>SetSelector</procedure></A> (v: V; selector: Selector) =
  BEGIN
    IF selector = NIL THEN selector := selectorClosest END;
    v.selector := selector;
  END SetSelector;

PROCEDURE <A NAME="SetSelectee"><procedure>SetSelectee</procedure></A> (v: V; selectee: Selectee) =
  BEGIN
    IF selectee = NIL THEN selectee := selecteeDefault END;
    v.selectee := selectee;
  END SetSelectee;

PROCEDURE <A NAME="SetNW"><procedure>SetNW</procedure></A> (v: V; nw := R2.Origin) =
  BEGIN
    v.nw := nw;
    v.displayList.dirty := TRUE;
    v.dirtyRegion := Rect.Full;
    VBT.Mark(v);
  END SetNW;
</PRE> SCG July 28, 1992: Now there is always an offscreen VBT for the
   shapeVBT.  If doubleBuffering is on, then the paintVBT shares
   it.  Kinda backwards.... 
<PRE>PROCEDURE <A NAME="SetDoubleBuffer"><procedure>SetDoubleBuffer</procedure></A> (v: V; yes: BOOLEAN) =
  VAR dom: Rect.T;
  BEGIN
    v.doubleBuffer := yes;
    IF v.paintVBT # v THEN
      Trestle.Delete(v.paintVBT);
      VBT.Discard(v.paintVBT);
      v.paintVBT := v;
    END;
    v.shapeVBT := NEW(VBT.Leaf);
    IF yes THEN v.paintVBT := v.shapeVBT; v.dirtyRegion := Rect.Full; END;
    dom := VBT.Domain(v);
    VAR
      tso := Trestle.ScreenOf(v, Point.Origin);
      trsl := tso.trsl;
      stInstall := VBT.ScreenTypeOf(InstalledVBT.Child(v));
      st   := VBT.ScreenTypeOf(v);
    &lt;* FATAL TrestleComm.Failure *&gt;
    BEGIN
      IF trsl # NIL AND st # NIL THEN
        WITH filter = NEW(Filter.T).init(v.shapeVBT) DO
          Trestle.Attach(filter, trsl);
          (* install a Filter above the shapeVBT so that it can have a
             ScreenType that Trestle likes in the case where shapeVBT has
             an &quot;unusual&quot; screen type (i.e.  there is a scale filter) *)
          Trestle.InstallOffscreen(
            filter, dom.east - dom.west, dom.south - dom.north, stInstall);
          IF filter.st # st THEN
            (* duke it out with trestle to set the screen type and
               domain *)
            VBTClass.Rescreen(v.shapeVBT, st);
            VBTClass.Reshape(v.shapeVBT, filter.domain, Rect.Empty);
          END;
        END;
      END;
    END;
  END SetDoubleBuffer;

PROCEDURE <A NAME="RepaintV"><procedure>RepaintV</procedure></A> (v: V; READONLY br: Region.T) =
  BEGIN
    VBT.PaintTint(v.paintVBT, br.r, PaintOp.Bg);
    v.mgRedisplay(br);
  END RepaintV;

&lt;* LL &lt;= VBT.mu *&gt;
PROCEDURE <A NAME="MGRedisplay"><procedure>MGRedisplay</procedure></A> (v: V; READONLY br: Region.T) =
  VAR
    clip                    := Rect.Join(br.r, v.dirtyRegion);
    dom, dom2: Rect.T;
    brCap    : Region.T;
    pixmap   : ScrnPixmap.T;
  &lt;* FATAL TrestleComm.Failure *&gt;
  BEGIN
    IF Rect.IsEmpty(VBT.Domain(v)) THEN RETURN END;
    LOCK v.mu DO
      VBT.BeginGroup(v);
      VBT.PaintTint(v.paintVBT, v.dirtyRegion, PaintOp.Bg);
      v.displayList.render(v, clip);
      v.dirtyRegion := Rect.Empty;
      IF NOT v.doubleBuffer THEN VBT.EndGroup(v.paintVBT); RETURN END;
      dom := VBT.Domain(v);
      dom2 := VBT.Domain(v.paintVBT);
      IF NOT Rect.IsEmpty(dom) THEN
        pixmap := VBT.Capture(v.paintVBT, dom2, brCap);
        IF pixmap # NIL THEN
          VBT.PaintScrnPixmap(
            v, src := pixmap,
            delta := Point.Sub(Rect.NorthWest(dom), Rect.NorthWest(dom2)));
          VBT.EndGroup(v);
          VBT.Sync(v);
        END;
      END;
    END;
    IF pixmap # NIL THEN pixmap.free() END;
  END MGRedisplay;

PROCEDURE <A NAME="RescreenV"><procedure>RescreenV</procedure></A> (v: V; &lt;* UNUSED *&gt; READONLY cd: VBT.RescreenRec) =
  BEGIN
    LOCK v.mu DO v.dirtyRegion := Rect.Full; END;
  END RescreenV;

PROCEDURE <A NAME="ReshapeSWOrigin"><procedure>ReshapeSWOrigin</procedure></A> (v: V; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    LOCK v.mu DO
      v.setNW(R2.Origin);       (* don't let current nw get in way of
                                   conversion *)
      v.setNW(MG.ScreenPointToMGC(v, Point.T{0, -Rect.VerSize(cd.new)}));
    END;
    ReshapeLeaveOrigin(v, cd);
  END ReshapeSWOrigin;

PROCEDURE <A NAME="ReshapeLeaveOrigin"><procedure>ReshapeLeaveOrigin</procedure></A> (v: V; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    LOCK v.mu DO v.dirtyRegion := Rect.Full END;
    v.setDoubleBuffer(v.doubleBuffer);
    v.repaint(Region.FromRect(cd.new));
  END ReshapeLeaveOrigin;

PROCEDURE <A NAME="ShapeFixed"><procedure>ShapeFixed</procedure></A> (v: V; axis: Axis.T; &lt;* UNUSED *&gt; nn: CARDINAL):
  VBT.SizeRange =
  VAR
    bounds: R2Box.T;
    size  : R2.T;
  BEGIN
    LOCK v.mu DO
      bounds := v.displayList.bounds(v);
      size := R2Box.Size(bounds);
      IF axis = Axis.T.Hor THEN
        WITH p = Pts.ToScreenPixels(v, size[0], Axis.T.Hor) DO
          RETURN VBT.SizeRange{lo := p, pref := p, hi := p + 1};
        END;
      ELSE
        WITH p = Pts.ToScreenPixels(v, size[1], Axis.T.Ver) DO
          RETURN VBT.SizeRange{lo := p, pref := p, hi := p + 1};
        END;
      END;
    END
  END ShapeFixed;

PROCEDURE <A NAME="ShapeStretchy"><procedure>ShapeStretchy</procedure></A> (v: V; axis: Axis.T; &lt;* UNUSED *&gt; nn: CARDINAL):
  VBT.SizeRange =
  VAR bounds: R2Box.T;
      size: R2.T;
  BEGIN
    LOCK v.mu DO
      bounds := v.displayList.bounds(v);
      size := R2Box.Size(bounds);
      size[0] := MAX(0.0, size[0]);
      size[1] := MAX(0.0, size[1]);
      IF axis = Axis.T.Hor THEN
        WITH p = Pts.ToScreenPixels(v, size[0], Axis.T.Hor) DO
          RETURN VBT.SizeRange{lo := 0, pref := p, hi :=
                               MAX(p + 1, VBT.DefaultShape.hi)};
        END;
      ELSE
        WITH p = Pts.ToScreenPixels(v, size[1], Axis.T.Ver) DO
          RETURN VBT.SizeRange{lo := 0, pref := p, hi :=
                               MAX(p + 1, VBT.DefaultShape.hi)};
        END;
      END;
    END
  END ShapeStretchy;

PROCEDURE <A NAME="MouseV"><procedure>MouseV</procedure></A> (v: V; READONLY cd: VBT.MouseRec) =
  VAR sel: MG.T;
  BEGIN
    LOCK v.mu DO
      sel := v.selector.select(v, MG.ScreenPointToMGC(v, cd.cp.pt), cd);
    END;
    v.selectee.select(v, sel, cd);
  END MouseV;

REVEAL
  <A NAME="Selectee">Selectee</A> = SelecteePublic BRANDED OBJECT END;

PROCEDURE <A NAME="SelecteeDefault"><procedure>SelecteeDefault</procedure></A> (&lt;* UNUSED *&gt;          s : Selectee;
                           &lt;* UNUSED *&gt;          v : V;
                           &lt;* UNUSED *&gt;          t : MG.T;
                           &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec) =
  BEGIN
  END SelecteeDefault;

VAR
  selecteeDefault := NEW(Selectee, select := SelecteeDefault);

REVEAL
  <A NAME="Selector">Selector</A> = SelectorPublic BRANDED OBJECT END;

TYPE
  SelectorIter = MG.GroupIterator OBJECT
    closest: MG.T := NIL;
    dist   : REAL := 999999999.0;
    pos: R2.T;
  OVERRIDES
    proc := SelectorProc;
  END;

PROCEDURE <A NAME="SelectorClosest"><procedure>SelectorClosest</procedure></A> (&lt;* UNUSED *&gt;          s  : Selector;
                                                 v  : V;
                                        READONLY pos: R2.T;
                           &lt;* UNUSED *&gt; READONLY cd : VBT.MouseRec): MG.T =
  VAR iter := NEW(SelectorIter, v := v, pos := pos);
  BEGIN
    EVAL v.displayList.iterate(iter, TRUE, FALSE);
    RETURN iter.closest;
  END SelectorClosest;

PROCEDURE <A NAME="SelectorProc"><procedure>SelectorProc</procedure></A> (iter: SelectorIter; t: MG.T): BOOLEAN =
  VAR
    dx, dy, dist: REAL;
    pos                            := iter.pos;
    bounds := t.appearance.boundingBox(t, iter.v);
  BEGIN
    IF pos[0] &lt; bounds[0].lo THEN
      dx := bounds[0].lo - pos[0]
    ELSIF pos[0] &gt; bounds[0].hi THEN
      dx := pos[0] - bounds[0].hi;
    ELSE
      dx := 0.0;
    END;
    IF pos[1] &lt; bounds[1].lo THEN
      dy := bounds[1].lo - pos[1]
    ELSIF pos[1] &gt; bounds[1].hi THEN
      dy := pos[1] - bounds[1].hi
    ELSE
      dy := 0.0;
    END;
    IF dx = 0.0 AND dy = 0.00 THEN
      iter.closest := t;
      iter.dist := 0.0;
      RETURN FALSE
    ELSE
      dist := dx * dx + dy * dy;
      IF dist &lt; iter.dist THEN iter.closest := t; iter.dist := dist; END;
      RETURN TRUE;
    END;
  END SelectorProc;

PROCEDURE <A NAME="AddAnimation"><procedure>AddAnimation</procedure></A> (v: V; anim: Animate.T; mg: MG.T) =
  BEGIN
    LOCK v.mu DO AddAnimationLocked(v, anim, mg); END;
  END AddAnimation;

PROCEDURE <A NAME="AddAnimationLocked"><procedure>AddAnimationLocked</procedure></A> (v: V; anim: Animate.T; mg: MG.T) =
  BEGIN
    IF v.animations = NIL THEN
      v.animations := NEW(Animate.Group).init();
    END;
    v.animations.add(v, NEW(Animate.Composite, t := anim, mg := mg));
  END AddAnimationLocked;

PROCEDURE <A NAME="Animation"><procedure>Animation</procedure></A> (v: V; duration := 1.0) RAISES {Thread.Alerted} =
  VAR a: Animate.Group;
  BEGIN
    LOCK v.mu DO a := v.animations; v.animations := NIL; END;
    IF a # NIL THEN
      Animate.Do(a, NIL, v, duration);
    ELSE
      v.mgRedisplay(Region.Empty);
    END;
  END Animation;

BEGIN
  selectorClosest := NEW(Selector, select := SelectorClosest);
END MGV.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
