<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/Matrix2D.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/Matrix2D.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison and Steve Glassman 
                                                                           

<P><PRE>INTERFACE <interface><A HREF="Matrix2D.m3">Matrix2D</A></interface>;
</PRE> A Matrix.T is a simplified representation of a true 3 x 3 matrix.  We
   assume the last column is always {0, 0, 1} so we do not explicitly hold
   it.
<P>
   Here is the layout of the elements of our matrix.  A number is the
   corresponding index into the array, `x' means the element is not held
   explicitly.
<P>
<PRE>
            Column
           0   1   2
         +---+---+---+
        0| 0 | 1 | x |
      R  +---+---+---+
      o 1| 2 | 3 | x |
      w  +---+---+---+
        2| 4 | 5 | x |
         +---+---+---+
</PRE>
   

<P><PRE>IMPORT <A HREF="R2.i3">R2</A>;

TYPE T = ARRAY [0 .. 5] OF REAL;

CONST
  Identity = T{1.0, 0.0,        (* 0.0 *)
               0.0, 1.0,        (* 0.0 *)
               0.0, 0.0};       (* 1.0 *)

PROCEDURE <A HREF="Matrix2D.m3#Scale">Scale</A>(READONLY sx, sy: REAL): T;
PROCEDURE <A HREF="Matrix2D.m3#Translate">Translate</A>(READONLY tx, ty: REAL): T;
PROCEDURE <A HREF="Matrix2D.m3#Rotate">Rotate</A>(READONLY radians: REAL): T;
</PRE><BLOCKQUOTE><EM> positive radians are clockwise </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Matrix2D.m3#Concat">Concat</A>(READONLY m, n: T): T;
PROCEDURE <A HREF="Matrix2D.m3#Concat3">Concat3</A>(READONLY l, m, n: T): T;

PROCEDURE <A HREF="Matrix2D.m3#Inverse">Inverse</A> (READONLY m: T): T;

PROCEDURE <A HREF="Matrix2D.m3#Transform">Transform</A>(READONLY m: T; READONLY p: R2.T): R2.T;

END Matrix2D.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
