<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/Matrix2D.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/Matrix2D.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison and Steve Glassman 
                                                                           

<P><PRE>MODULE <module><implements><A HREF="Matrix2D.i3">Matrix2D</A></implements></module>;

IMPORT <A HREF="R2.i3">R2</A>, <A HREF="../../arith/src/Math.i3">Math</A>;

PROCEDURE <A NAME="Scale"><procedure>Scale</procedure></A>(READONLY sx, sy: REAL): T =
  BEGIN
    RETURN
      T{sx,  0.0,
        0.0, sy,
        0.0, 0.0};
  END Scale;

PROCEDURE <A NAME="Translate"><procedure>Translate</procedure></A>(READONLY tx, ty: REAL): T =
  BEGIN
    RETURN
      T{1.0, 0.0,
        0.0, 1.0,
        tx,  ty};
  END Translate;

PROCEDURE <A NAME="Rotate"><procedure>Rotate</procedure></A>(READONLY theta: REAL): T =
  VAR
    s := FLOAT(Math.sin(FLOAT(theta, LONGREAL)));
    c := FLOAT(Math.cos(FLOAT(theta, LONGREAL)));
  BEGIN
    RETURN
      T{ c, s,
        -s, c,
         0.0, 0.0};
  END Rotate;

PROCEDURE <A NAME="Concat"><procedure>Concat</procedure></A> (READONLY m, n: T): T =
  BEGIN
    RETURN T{m[0] * n[0] + m[1] * n[2], m[0] * n[1] + m[1] * n[3],
             m[2] * n[0] + m[3] * n[2], m[2] * n[1] + m[3] * n[3],
             m[4] * n[0] + m[5] * n[2] + n[4],
             m[4] * n[1] + m[5] * n[3] + n[5]};
  END Concat;
</PRE><PRE>
      from maple:
                                     </PRE>
[ a  b  0 ]
                                     [         ]
                                A := [ c  d  0 ]
                                     [         ]
                                     [ e  f  1 ]
<P>
<P>
   inverse(A);
                        [      d             b        ]
                        [  ---------   - ---------  0 ]
                        [  a d - c b     a d - c b    ]
                        [                             ]
                        [       c           a         ]
                        [ - ---------   ---------   0 ]
                        [   a d - c b   a d - c b     ]
                        [                             ]
                        [  c f - d e     a f - b e    ]
                        [  ---------   - ---------  1 ]
                        [  a d - c b     a d - c b    ]


<P><PRE>PROCEDURE <A NAME="Inverse"><procedure>Inverse</procedure></A> (READONLY m: T): T =
  VAR det := m[0] * m[3] - m[1] * m[2];
  BEGIN
    RETURN T{ m[3] / det,
             -m[1] / det,
             -m[2] / det,
              m[0] / det,
             (m[2] * m[5] - m[3] * m[4]) / det,
             (m[1] * m[4] - m[0] * m[5]) / det};
  END Inverse;

PROCEDURE <A NAME="Concat3"><procedure>Concat3</procedure></A> (READONLY l, m, n: T): T =
  BEGIN
    RETURN T{(l[0] * m[0] + l[1] * m[2]) * n[0]
               + (l[0] * m[1] + l[1] * m[3]) * n[2],
             (l[0] * m[0] + l[1] * m[2]) * n[1]
               + (l[0] * m[1] + l[1] * m[3]) * n[3],
             (l[2] * m[0] + l[3] * m[2]) * n[0]
               + (l[2] * m[1] + l[3] * m[3]) * n[2],
             (l[2] * m[0] + l[3] * m[2]) * n[1]
               + (l[2] * m[1] + l[3] * m[3]) * n[3],
             (l[4] * m[0] + l[5] * m[2] + m[4]) * n[0]
               + (l[4] * m[1] + l[5] * m[3] + m[5]) * n[2] + n[4],
             (l[4] * m[0] + l[5] * m[2] + m[4]) * n[1]
               + (l[4] * m[1] + l[5] * m[3] + m[5]) * n[3] + n[5]};
  END Concat3;

PROCEDURE <A NAME="Transform"><procedure>Transform</procedure></A>(READONLY m: T; READONLY p: R2.T): R2.T =
  BEGIN
    RETURN
      R2.T{p[0] * m[0] + p[1] * m[2] + m[4],
           p[0] * m[1] + p[1] * m[3] + m[5]};
  END Transform;

BEGIN
END Matrix2D.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
