<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/PathPrivate.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/PathPrivate.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> PathPrivate.def, by Mark Kent Fri Feb 20 22:10:03 1987 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> This interface defines the representation of a Path.T. 

<P><PRE>INTERFACE <interface><A HREF="../../geometry/src/Path.m3">PathPrivate</A></interface>;

IMPORT <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Path.i3">Path</A>, <A HREF="../../word/src/Word.i3">Word</A>;

TYPE
  ArrayRef = REF ARRAY OF Word.T;

REVEAL Path.<A NAME="T">T</A> = BRANDED OBJECT
    points: ArrayRef := NIL; (* data for the path *)
    start, next, current, end: ADDRESS := NIL;
    curveCount: CARDINAL := 0
  END;
</PRE> The current data for the path is packed in [start^..next^),
   and the space [next^..end^) is available for additional segments.
<P>
   If <CODE>points # NIL</CODE>, then the space between start and end is 
   contained in the array points^.  If <CODE>points = NIL</CODE>, then
   the path is read-only.
   <P>
   The value of <CODE>current</CODE> is the record for the <CODE>MoveTo</CODE> that
   started the last subpath, if it is open, and equal to <CODE>next</CODE> 
   otherwise. 

<P><PRE>TYPE Lock = UNTRACED REF Word.T;

PROCEDURE <A HREF="../../geometry/src/Path.m3#Freeze">Freeze</A>(path: Path.T): Lock;
PROCEDURE <A HREF="../../geometry/src/Path.m3#Thaw">Thaw</A>(l: Lock);
</PRE> To read the address fields of a path, you must first call <CODE>Freeze</CODE>, 
   preventing the allocator from moving the data in points.  You must
   then call <CODE>Thaw</CODE>, passing the result of the call to <CODE>Freeze</CODE> when you
   no longer need the pointers to be maintained correctly. 

<P><PRE>TYPE
  Type = {Curve, Line, Move, Close};
  Ttype = BITS Word.Size FOR Type;
  PCurve = UNTRACED REF CurveRec;
  CurveRec = RECORD ct: Ttype; p, q, r: Point.T; END;
  PLine = UNTRACED REF LineRec;
  LineRec = RECORD ct: Ttype; p: Point.T END;

  (* in a &quot;PCurve&quot;, the &quot;ct&quot; field is &quot;Curve&quot;.  in a &quot;PLIne&quot;, the &quot;ct&quot;
     field is either Line, Move, or Close.   If &quot;ct&quot; is &quot;Close&quot;,
     then &quot;p&quot; is the startpoint of the subpath that it closes.  *)

END PathPrivate.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
