<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/R2Box.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/R2Box.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created by stolfi on Thu Mar 22 8:35:20 PST 1990 </EM></BLOCKQUOTE><PRE>
</PRE> A box in R2 

<P><PRE>INTERFACE <interface><A HREF="R2Box.m3">R2Box</A></interface>;

IMPORT <A HREF="R2.i3">R2</A>, <A HREF="Fuzzy.i3">Fuzzy</A>;

TYPE T = ARRAY R2.Axis OF Fuzzy.T;
</PRE><BLOCKQUOTE><EM> An R2Box.T describes a box in R^2, i.e., an axis-aligned rectangle. </EM></BLOCKQUOTE><PRE>

CONST
  Empty = T{Fuzzy.Empty, Fuzzy.Empty};
  Full = T{Fuzzy.Full, Fuzzy.Full};
</PRE> ---- construction ---- 

<P><PRE>PROCEDURE <A HREF="R2Box.m3#FromEdges">FromEdges</A> (h1, h2, v1, v2: REAL): T;
</PRE><BLOCKQUOTE><EM> If <CODE>h1 &gt;= h2</CODE> or <CODE>v1 &gt;= v2</CODE> return <CODE>Empty</CODE>, else return <CODE>T{Fuzzy.T{h1,
   h2}, Fuzzy.T{v1, v2}}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2Box.m3#FromAbsEdges">FromAbsEdges</A> (h1, h2, v1, v2: REAL): T;
</PRE><BLOCKQUOTE><EM> Return
<PRE>
      FromEdges(MIN(h1, h2), MAX(h1, h2),
                MIN(v1, v2), MAX(v1, v2))
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2Box.m3#FromCorners">FromCorners</A> (READONLY p, q: R2.T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromAbsEdges(p[0],q[0],p[1],q[1])</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> ---- transformation ---- 

<P><PRE>PROCEDURE <A HREF="R2Box.m3#Meet">Meet</A> (READONLY a, b: T): T;
</PRE><BLOCKQUOTE><EM> Intersection of boxes <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2Box.m3#Join">Join</A> (READONLY a, b: T): T;
</PRE><BLOCKQUOTE><EM> Smallest box that contains both <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2Box.m3#Inset">Inset</A> (READONLY a: T; by: REAL): T;
</PRE><BLOCKQUOTE><EM> Make <CODE>a</CODE> smaller by <CODE>by</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2Box.m3#Extend">Extend</A> (READONLY a: T; p: R2.T): T;
</PRE><BLOCKQUOTE><EM> Extend <CODE>a</CODE> to include the point <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2Box.m3#Translate">Translate</A> (READONLY a: T; p: R2.T): T;
</PRE><BLOCKQUOTE><EM> Translate <CODE>a</CODE> by <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> ---- selection ---- 

<P><PRE>PROCEDURE <A HREF="R2Box.m3#NorthWest">NorthWest</A> (READONLY a: T): R2.T;

PROCEDURE <A HREF="R2Box.m3#NorthEast">NorthEast</A> (READONLY a: T): R2.T;

PROCEDURE <A HREF="R2Box.m3#SouthWest">SouthWest</A> (READONLY a: T): R2.T;

PROCEDURE <A HREF="R2Box.m3#SouthEast">SouthEast</A> (READONLY a: T): R2.T;

PROCEDURE <A HREF="R2Box.m3#Middle">Middle</A> (READONLY a: T): R2.T;
</PRE><BLOCKQUOTE><EM> Center of box <CODE>a</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2Box.m3#Size">Size</A> (READONLY a: T): R2.T;
PROCEDURE <A HREF="R2Box.m3#HalfSize">HalfSize</A> (READONLY a: T): R2.T;
</PRE><BLOCKQUOTE><EM> Size(width and height) of box <CODE>a</CODE>.  HalfSize is half the size. </EM></BLOCKQUOTE><PRE>
</PRE> ---- test ---- 

<P><PRE>PROCEDURE <A HREF="R2Box.m3#IsEmpty">IsEmpty</A> (READONLY a: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE iff <CODE>a</CODE> is empty </EM></BLOCKQUOTE><PRE>
</PRE> ---- utils ---- 

<P><PRE>PROCEDURE <A HREF="R2Box.m3#ToText">ToText</A> (READONLY a: T): TEXT;
</PRE><BLOCKQUOTE><EM> Return a text representation of <CODE>a</CODE>. </EM></BLOCKQUOTE><PRE>

END R2Box.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
