<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/R2Box.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/R2Box.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created by stolfi on Sat Mar 3 0:08:44 PST 1990 </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="R2Box.i3">R2Box</A></implements></module>;

IMPORT <A HREF="R2.i3">R2</A>, <A HREF="Fuzzy.i3">Fuzzy</A>;

PROCEDURE <A NAME="FromEdges"><procedure>FromEdges</procedure></A> (h1, h2, v1, v2: REAL): T =
  BEGIN
    IF h1 &gt;= h2 OR v1 &gt;= v2 THEN RETURN Empty END;

    RETURN T{Fuzzy.T{h1, h2}, Fuzzy.T{v1, v2}};
  END FromEdges;

PROCEDURE <A NAME="FromAbsEdges"><procedure>FromAbsEdges</procedure></A> (h1, h2, v1, v2: REAL): T =
  BEGIN
    RETURN FromEdges(MIN(h1, h2), MAX(h1, h2), MIN(v1, v2), MAX(v1, v2))
  END FromAbsEdges;

PROCEDURE <A NAME="FromCorners"><procedure>FromCorners</procedure></A> (READONLY p, q: R2.T): T =
  BEGIN
    RETURN FromAbsEdges(p[0], q[0], p[1], q[1]);
  END FromCorners;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A> (READONLY a: T): BOOLEAN =
  BEGIN
    RETURN a[0].lo &gt; a[0].hi OR a[1].lo &gt; a[1].hi;
  END IsEmpty;

PROCEDURE <A NAME="Meet"><procedure>Meet</procedure></A> (READONLY a, b: T): T =
  BEGIN
    IF a[0].lo &gt; a[0].hi OR a[1].lo &gt; a[1].hi OR b[0].lo &gt; b[0].hi
         OR b[1].lo &gt; b[1].hi THEN
      RETURN Empty
    ELSE
      RETURN T{Fuzzy.T{MAX(a[0].lo, b[0].lo), MIN(a[0].hi, b[0].hi)},
               Fuzzy.T{MAX(a[1].lo, b[1].lo), MIN(a[1].hi, b[1].hi)}};
    END
  END Meet;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A> (READONLY a, b: T): T =
  BEGIN
    IF a[0].lo &gt; a[0].hi OR a[1].lo &gt; a[1].hi THEN RETURN b END;
    IF b[0].lo &gt; b[0].hi OR b[1].lo &gt; b[1].hi THEN RETURN a END;
    RETURN T{Fuzzy.T{MIN(a[0].lo, b[0].lo), MAX(a[0].hi, b[0].hi)},
             Fuzzy.T{MIN(a[1].lo, b[1].lo), MAX(a[1].hi, b[1].hi)}};
  END Join;

PROCEDURE <A NAME="NorthWest"><procedure>NorthWest</procedure></A> (READONLY a: T): R2.T =
  BEGIN
    RETURN R2.T{a[0].lo, a[1].hi};
  END NorthWest;

PROCEDURE <A NAME="NorthEast"><procedure>NorthEast</procedure></A> (READONLY a: T): R2.T =
  BEGIN
    RETURN R2.T{a[0].hi, a[1].hi};
  END NorthEast;

PROCEDURE <A NAME="SouthWest"><procedure>SouthWest</procedure></A> (READONLY a: T): R2.T =
  BEGIN
    RETURN R2.T{a[0].lo, a[1].lo};
  END SouthWest;

PROCEDURE <A NAME="SouthEast"><procedure>SouthEast</procedure></A> (READONLY a: T): R2.T =
  BEGIN
    RETURN R2.T{a[0].hi, a[1].lo};
  END SouthEast;

PROCEDURE <A NAME="Middle"><procedure>Middle</procedure></A> (READONLY a: T): R2.T =
  BEGIN
    IF a[0].lo &gt; a[0].hi OR a[1].lo &gt; a[1].hi THEN
      RETURN R2.Origin;
    ELSE
      RETURN R2.T{0.5 * a[0].lo + 0.5 * a[0].hi,
                  0.5 * a[1].lo + 0.5 * a[1].hi};
    END;
  END Middle;

PROCEDURE <A NAME="Size"><procedure>Size</procedure></A> (READONLY a: T): R2.T =
  BEGIN
    IF a[0].lo &gt; a[0].hi OR a[1].lo &gt; a[1].hi THEN
      RETURN R2.Origin;
    ELSE
      RETURN R2.T{a[0].hi - a[0].lo, a[1].hi - a[1].lo};
    END;
  END Size;

PROCEDURE <A NAME="HalfSize"><procedure>HalfSize</procedure></A> (READONLY a: T): R2.T =
  BEGIN
    IF a[0].lo &gt; a[0].hi OR a[1].lo &gt; a[1].hi THEN
      RETURN R2.Origin;
    ELSE
      RETURN R2.T{0.5 * a[0].hi - 0.5 * a[0].lo,
                  0.5 * a[1].hi - 0.5 * a[1].lo};
    END;
  END HalfSize;

PROCEDURE <A NAME="Inset"><procedure>Inset</procedure></A> (READONLY a: T; by: REAL): T =
  BEGIN
    RETURN T{Fuzzy.Inset(a[0], by), Fuzzy.Inset(a[1], by)};
  END Inset;

PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A> (READONLY a: T; p: R2.T): T =
  BEGIN
    RETURN T{Fuzzy.Expand(p[0], a[0]), Fuzzy.Expand(p[1], a[1])};
  END Extend;

PROCEDURE <A NAME="Translate"><procedure>Translate</procedure></A> (READONLY a: T; p: R2.T): T =
  BEGIN
    RETURN T{Fuzzy.Shift(p[0], a[0]), Fuzzy.Shift(p[1], a[1])};
  END Translate;

PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A> (READONLY a: T): TEXT =
  BEGIN
    IF a[0].lo &gt; a[0].hi OR a[1].lo &gt; a[1].hi THEN
      RETURN &quot;(empty)&quot;;
    ELSE
      RETURN &quot;(&quot; &amp; Fuzzy.ToText(a[0]) &amp; &quot;, &quot; &amp; Fuzzy.ToText(a[1]) &amp; &quot;)&quot;;
    END;
  END ToText;

BEGIN
END R2Box.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
