<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/R2Path.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/R2Path.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison and Steve Glassman 
                                                                           

<P> After Path.m3---see that file for authors. 

<P><PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="R2Path.i3">R2Path</A></implements></module>;

IMPORT <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="Matrix2D.i3">Matrix2D</A>, <A HREF="R2.i3">R2</A>, <A HREF="R2Box.i3">R2Box</A>;

CONST
  PATH_INITIAL_ELEMENTS = 1;
  PATH_GROWTH_FACTOR = 1.61;		 (* The golden gizmo *)

TYPE
  Element = BRANDED OBJECT END;

  LineElem = Element BRANDED OBJECT
    pt: R2.T;
  END;

  MoveElem = Element BRANDED OBJECT
    pt: R2.T;
  END;

  CloseElem = Element BRANDED OBJECT
    pt: R2.T;
  END;

  CurveElem = Element BRANDED OBJECT
    p, q, r: R2.T;
  END;

  ArcElem = Element BRANDED OBJECT
    center: R2.T;
    radius, ang1, ang2: REAL
  END;

  ElemList = REF ARRAY OF Element;

REVEAL
  <A NAME="T">T</A> = PublicT BRANDED OBJECT
    elemList: ElemList := NIL;		 (* Empty path *)
    nextElement := 0;			 (* Where to place the next element *)
  OVERRIDES
    init := Init;
    moveTo := MoveTo;
    lineTo := LineTo;
    arcTo := ArcTo;
    curveTo := CurveTo;
    close := Close;
    isEmpty := IsEmpty;
    translate := Translate;
    map := Map;
    bbox := BBox;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(self: T) =
  BEGIN
    self.elemList := NIL;
    self.nextElement := 0;
  END Init;

PROCEDURE <A NAME="MoveTo"><procedure>MoveTo</procedure></A>(self: T; READONLY pt: R2.T) =
  BEGIN
    Append(self, NEW(MoveElem, pt := pt));
  END MoveTo;

PROCEDURE <A NAME="LineTo"><procedure>LineTo</procedure></A>(self: T; READONLY pt: R2.T) =
  BEGIN
    Append(self, NEW(LineElem, pt := pt));
  END LineTo;

PROCEDURE <A NAME="ArcTo"><procedure>ArcTo</procedure></A>(self: T;
                READONLY center: R2.T;
                READONLY radius, ang1, ang2: REAL) =
  BEGIN
    Append(self, NEW(ArcElem, center := center, radius := radius, ang1 := ang1, ang2 := ang2));
  END ArcTo;

PROCEDURE <A NAME="CurveTo"><procedure>CurveTo</procedure></A>(self: T; READONLY p, q, r: R2.T) =
  BEGIN
    Append(self, NEW(CurveElem, p := p, q := q, r := r));
  END CurveTo;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(self: T) =
  BEGIN
    Append(self, NEW(CloseElem));
  END Close;

PROCEDURE <A NAME="Append"><procedure>Append</procedure></A>(VAR path: T; READONLY elem: Element) =
  BEGIN
    IF path.elemList = NIL THEN
      path.elemList := NEW(ElemList, PATH_INITIAL_ELEMENTS);
      path.nextElement := 0;
    END; (* if *)

    IF path.nextElement &gt; LAST(path.elemList^) THEN
      VAR
        (* Increase size by at least 1 each time *)
        l := MAX(NUMBER(path.elemList^) + 1,
                 ROUND(FLOAT(NUMBER(path.elemList^)) * PATH_GROWTH_FACTOR));
        newPath := NEW(ElemList, l);
      BEGIN
        SUBARRAY(newPath^, 0, NUMBER(path.elemList^)) := path.elemList^;
        path.elemList := newPath;
      END (* block *)
    END; (* if *)

    path.elemList[path.nextElement] := elem;
    INC(path.nextElement);
  END Append;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A>(self: T): BOOLEAN =
  BEGIN
    RETURN self.elemList = NIL OR self.nextElement = 0;
  END IsEmpty;

PROCEDURE <A NAME="Translate"><procedure>Translate</procedure></A>(self: T; READONLY delta: R2.T): T =
  VAR
    newPath := Copy(self);
  BEGIN
    FOR i := 0 TO newPath.nextElement - 1 DO
      TYPECASE newPath.elemList[i] OF
      | MoveElem(e) =&gt;
          e.pt := R2.Add(e.pt, delta);
      | LineElem(e) =&gt;
          e.pt := R2.Add(e.pt, delta);
      | CloseElem(e) =&gt;
          e.pt := R2.Add(e.pt, delta);
      | CurveElem(e) =&gt;
          e.p := R2.Add(e.p, delta);
          e.q := R2.Add(e.q, delta);
          e.r := R2.Add(e.r, delta);
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END; (* typecase *)
    END; (* for *)

    RETURN newPath;
  END Translate;

PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A>(self: T): T =
  VAR
    newPath := NEW(T);
  BEGIN
    Init(self);

    FOR i := 0 TO self.nextElement - 1 DO
      TYPECASE self.elemList[i] OF
      | MoveElem(e) =&gt;
          Append(newPath, NEW(MoveElem, pt := e.pt));
      | LineElem(e) =&gt;
          Append(newPath, NEW(LineElem, pt := e.pt));
      | ArcElem(e) =&gt;
          Append(newPath, NEW(ArcElem, center := e.center, radius := e.radius, ang1 := e.ang1, ang2 := e.ang2));
      | CloseElem(e) =&gt;
          Append(newPath, NEW(CloseElem, pt := e.pt));
      | CurveElem(e) =&gt;
          Append(newPath, NEW(CurveElem, p := e.p, q := e.q, r := e.r));
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END; (* typecase *)
    END; (* for *)

    RETURN newPath;
  END Copy;

PROCEDURE <A NAME="Map"><procedure>Map</procedure></A>(self: T; map: MapObject) =
  BEGIN
    FOR i := 0 TO self.nextElement - 1 DO
      TYPECASE self.elemList[i] OF
      | MoveElem(e) =&gt;
          map.move(e.pt);
      | LineElem(e) =&gt;
          map.line(e.pt);
      | CloseElem =&gt;
          map.close();
      | ArcElem(e) =&gt;
          map.arc(e.center, e.radius, e.ang1, e.ang2)
      | CurveElem(e) =&gt;
          map.curve(e.p, e.q, e.r);
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END; (* typecase *)
    END; (* for *)
  END Map;

PROCEDURE <A NAME="FindArcPoint"><procedure>FindArcPoint</procedure></A>(READONLY center: R2.T; READONLY radius, angle: REAL): R2.T =
  BEGIN
    RETURN R2.T{center[0] + radius * FLOAT(Math.cos(FLOAT(angle, LONGREAL))),
		center[1] + radius * FLOAT(Math.sin(FLOAT(angle, LONGREAL)))};
  END FindArcPoint;

PROCEDURE <A NAME="BBox"><procedure>BBox</procedure></A>(self: T; READONLY matrix := Matrix2D.Identity): R2Box.T =
  VAR
    bounds := R2Box.Empty;

  PROCEDURE extendBBox(READONLY pt: R2.T) =
    BEGIN
      bounds := R2Box.Extend(bounds, Matrix2D.Transform(matrix, pt));
    END extendBBox;

  BEGIN
    FOR i := 0 TO self.nextElement - 1 DO
      TYPECASE self.elemList[i] OF
      | MoveElem(e) =&gt;
          extendBBox(e.pt);
      | LineElem(e) =&gt;
          extendBBox(e.pt);
      | CloseElem =&gt;
      | ArcElem(e) =&gt;
	  extendBBox(FindArcPoint(e.center, e.radius, e.ang1));
	  extendBBox(FindArcPoint(e.center, e.radius, e.ang2));
      | CurveElem(e) =&gt;
          extendBBox(e.p);
          extendBBox(e.q);
          extendBBox(e.r);
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END; (* typecase *)
    END; (* for *)

    RETURN bounds;
  END BBox;

BEGIN
  &lt;* ASSERT PATH_GROWTH_FACTOR &gt; 0.0 *&gt;
  &lt;* ASSERT PATH_INITIAL_ELEMENTS &gt; 0 *&gt;
END R2Path.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
