<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/R2PathExtra.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/R2PathExtra.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison 
 

<P> This interface provides operations on objects of type Path.T and of type
   R2Path.T.  A Path.T is the path represented on an integer grid, a
   R2Path.T is a path represented by coordinates which are reals. 

<P><PRE>INTERFACE <interface><A HREF="R2PathExtra.m3">R2PathExtra</A></interface>;

IMPORT <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="MG.i3">MG</A>, <A HREF="../../geometry/src/Path.i3">Path</A>, <A HREF="R2Path.i3">R2Path</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="Matrix2D.i3">Matrix2D</A>;

PROCEDURE <A HREF="R2PathExtra.m3#TranslatePath">TranslatePath</A> (READONLY path: Path.T; READONLY delta: Point.T):
  Path.T;
</PRE><BLOCKQUOTE><EM> Return <CODE>path</CODE> translated by <CODE>delta</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2PathExtra.m3#R2PathToPath">R2PathToPath</A> (         v       : MG.V;
                          READONLY R2Path: R2Path.T;
                          READONLY matrix := Matrix2D.Identity): Path.T;
</PRE><BLOCKQUOTE><EM> Convert <CODE>R2Path</CODE> to the equivalent <CODE>Path.T</CODE> on an integer grid
   transformed by <CODE>matrix</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE
  Element = RECORD
              pt: Point.T;
              steps: INTEGER;
            END;

  SubPath = RECORD
              start: Point.T;
              elems: REF ARRAY OF Element := NIL;
              closed: BOOLEAN;
            END;

  <A HREF="R2PathExtra.m3#Segments">Segments</A> &lt;: PublicSegments;
  PublicSegments = OBJECT subPaths: REF ARRAY OF SubPath := NIL;  END;

PROCEDURE <A HREF="R2PathExtra.m3#PathToSegments">PathToSegments</A> (v: MG.V; READONLY path: Path.T): Segments;
</PRE><BLOCKQUOTE><EM> Convert <CODE>path</CODE> to the corresponding <CODE>Segment</CODE> structure. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="R2PathExtra.m3#PathBounds">PathBounds</A> (READONLY path: Path.T): Rect.T;
</PRE><BLOCKQUOTE><EM> Return the integer bounds of <CODE>path</CODE>. </EM></BLOCKQUOTE><PRE>

END R2PathExtra.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
