<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/RealRect.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/RealRect.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>RealRect.T</CODE> is a set of points lying in a rectangle with its sides
   parallel to the coordinate axes.  The directions of the screen are
   named after the compass points, with north at the top.  A rectangle
   <CODE>rect</CODE> contains a point <CODE>pt</CODE> if
   <P>
   <PRE>
      pt.h <KBD>is in</KBD> [rect.west .. rect.east - 1]  AND
         pt.v <KBD>is in</KBD> [rect.north .. rect.south - 1]
</PRE>
   We impose the restriction that if a rectangle contains no points,
   then it must be equal as a record to <CODE>RealRect.Empty</CODE>.  

<P><PRE>INTERFACE <interface><A HREF="../../realgeometry/src/RealRect.m3">RealRect</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../geometry/src/Interval.i3">Interval</A>, <A HREF="../../geometry/src/Point.i3">Point</A>;

TYPE T = RECORD west, east, north, south: REAL END;

TYPE Edge = {W, E, N, S};

TYPE Vertex = {NW, NE, SW, SE};

CONST Empty = T {0.0, 0.0, 0.0, 0.0};  (* An empty rectangle *)

CONST Full = T {FIRST(REAL), LAST(REAL), FIRST(REAL), LAST(REAL)};
                (* The biggest possible rectangle *)
</PRE> --- Initialization --- 

<P><PRE>PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#FromEdges">FromEdges</A>(w, e, n, s: REAL): T;
</PRE><BLOCKQUOTE><EM> If <CODE>w &gt;= e</CODE> or <CODE>n &gt;= s</CODE> return <CODE>Empty</CODE>, else return <CODE>T{w,e,n,s}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#FromAbsEdges">FromAbsEdges</A>(h1, h2, v1, v2: REAL): T;
</PRE><BLOCKQUOTE><EM> Return 
<P>
<PRE>
      FromEdges(MIN(h1,h2), MAX(h1,h2), 
                MIN(v1,v2), MAX(v1,v2))
</PRE>
</EM></BLOCKQUOTE><PRE>

PROCEDURE FromR2(READONLY p: R2.T): T;
</PRE><BLOCKQUOTE><EM> Return the rectangle whose only element is <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#FromCorners">FromCorners</A>(READONLY p, q: R2.T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromAbsEdges(p.h,q.h,p.v,q.v)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#FromCorner">FromCorner</A>(
  READONLY p: R2.T;
  hor, ver: CARDINAL): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromEdges(p.h, p.h+hor, p.v, p.v+ver)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#FromSize">FromSize</A>(hor, ver: REAL): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromCorner(Point.Origin,hor,ver)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Center">Center</A>(READONLY r: T; READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> If <CODE>r</CODE> is empty then return <CODE>Empty</CODE> else return a rectangle <CODE>s</CODE>
   such that <CODE>Congruent(r, s)</CODE> and <CODE>Middle(s)=p</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#FromIntervals">FromIntervals</A>
  (READONLY hor, ver: Interval.T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>FromEdges(hor.lo,hor.hi,ver.lo,ver.hi)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#FromAxes">FromAxes</A> (axis: Axis.T; READONLY n, m: Interval.T): T;
</PRE><BLOCKQUOTE><EM> If axis=Hor then FromIntervals(n,m), else FromIntervals(m,n) </EM></BLOCKQUOTE><PRE>
</PRE> --- Selection --- 

<P><PRE>PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#NorthWest">NorthWest</A>(READONLY r: T): Point.T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Point.T{r.west,r.north}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#NorthEast">NorthEast</A>(READONLY r: T): Point.T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Point.T{r.east,r.north}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#SouthWest">SouthWest</A>(READONLY r: T): Point.T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Point.T{r.west,r.south}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#SouthEast">SouthEast</A>(READONLY r: T): Point.T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Point.T{r.east,r.south}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#GetVertex">GetVertex</A> (v: Vertex; READONLY r: T): Point.T;
</PRE><BLOCKQUOTE><EM> the point corresponding to the vertex v of r; origin if r is empty </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#HorSize">HorSize</A>(READONLY r: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return <CODE>r.east - r.west</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#VerSize">VerSize</A>(READONLY r: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return <CODE>r.south - r.north</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Size">Size</A> (a: Axis.T; READONLY r: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> HorSize(r) if a=Hor; VerSize(r) if a=Ver </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#DiagSizeSquare">DiagSizeSquare</A> (READONLY r: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> HorSize(r)**2+VerSize(r)**2 </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Middle">Middle</A>(READONLY r: T): Point.T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Point.T{r.west+r.east DIV 2, r.north+r.south DIV 2}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#PickEdge">PickEdge</A> (READONLY r: T; READONLY p: Point.T): Edge;
</PRE><BLOCKQUOTE><EM> Return the edge of r closest to p (one of them if not unique) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#PickVertex">PickVertex</A> (READONLY r: T; READONLY p: Point.T): Vertex;
</PRE><BLOCKQUOTE><EM> Return the vertex of r closest to p (one of them if not unique) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Project">Project</A>(READONLY r: T;
  READONLY p: Point.T): Point.T;
</PRE><BLOCKQUOTE><EM> Return the element of <CODE>r</CODE> that is closest to <CODE>p</CODE>. This is a
   checked runtime error if <CODE>r</CODE> is empty. </EM></BLOCKQUOTE><PRE>
</PRE> --- Transformation --- 

<P><PRE>PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Add">Add</A>(READONLY r: T; READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> Return
<P>
<PRE>
      FromEdges(r.west+p.h, r.east+p.h, 
                r.north+p.v,r.south+p.v)
</PRE>
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Sub">Sub</A>(READONLY r: T; READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Add(r, Point.Minus(p))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Move">Move</A> (READONLY r: T; READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> increment r.e and r.w by p.h; increment r.n and r.s by p.v </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#MoveH">MoveH</A> (READONLY r: T; h: INTEGER): T;
</PRE><BLOCKQUOTE><EM> increment r.e and r.w by h </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#MoveV">MoveV</A> (READONLY r: T; v: INTEGER): T;
</PRE><BLOCKQUOTE><EM> increment r.n and r.s by v </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#MoveHV">MoveHV</A> (READONLY r: T; h, v: INTEGER): T;
</PRE><BLOCKQUOTE><EM> increment r.e and r.w by h, r.n and r.s by v </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Scale">Scale</A> (READONLY r: T; num, den: INTEGER): T;
</PRE><BLOCKQUOTE><EM> scale a rectangle by a fraction </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Change">Change</A>
  (READONLY r: T; dw,de,dn,ds: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If <CODE>r</CODE> is empty return <CODE>Empty</CODE>, else return the rectangle
   <CODE>FromEdges(r.west+dw, r.east+de, r.north+dn, r.south+ds)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Inset">Inset</A>(READONLY r: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Change(r, n, -n, n, -n)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Transpose">Transpose</A>(READONLY r: T; ax := Axis.T.Ver): T;
</PRE><BLOCKQUOTE><EM> If <CODE>r</CODE> is empty or if <CODE>ax = Axis.Hor</CODE>, then return 
   <CODE>r</CODE>, else return <CODE>T{r.north, r.south, r.west, r.east}</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#MoveEdge">MoveEdge</A> (READONLY r: T; e: Edge; dn: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If r is empty return empty, else move the edge e of r by dn in the positive
   direction of the axis perpendicular to it </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#MoveVertex">MoveVertex</A> (READONLY r: T; v: Vertex; READONLY dp: Point.T): T
 ;
</PRE><BLOCKQUOTE><EM> If r is empty return empty, else move the vertex v of r by dp in the
   northwest-southeast direction </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Stretch">Stretch</A> (READONLY r: T; axis: Axis.T; lo, hi: INTEGER): T;
</PRE><BLOCKQUOTE><EM> If r is empty return empty, else change the interval of r determined by
   axis. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Join">Join</A>(READONLY r, s: T): T;
</PRE><BLOCKQUOTE><EM> Return the smallest rectangle containing both <CODE>r</CODE> and <CODE>s</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Meet">Meet</A>(READONLY r, s: T): T;
</PRE><BLOCKQUOTE><EM> Return the largest rectangle contained in both <CODE>r</CODE> and <CODE>s</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Extend">Extend</A> (READONLY r: T; READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> Returns Join(r,FromPoint(p)) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Chop">Chop</A> (hv: Axis.T; READONLY r: T; n: INTEGER; VAR (*out*) s, t: T)
 ;
</PRE><BLOCKQUOTE><EM> Chop a rectangle in two. If hv=Ver, s and t become the top and bottom parts
   of r resp. If hv=Hor, s and t become the left and right parts of r resp. </EM></BLOCKQUOTE><PRE>

TYPE Partition = ARRAY [0..4] OF T;

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Factor">Factor</A>(
  READONLY r, s: T;
  VAR (*out*) f: Partition;
  dh, dv: INTEGER) ;
</PRE><BLOCKQUOTE><EM> Partition <CODE>r</CODE> into <CODE>5</CODE> pieces <CODE>f[0]..f[4]</CODE> where <CODE>f[2] = Meet(r,s)</CODE>,
   and the other rectangles in <CODE>f</CODE> partition the set difference <CODE>r-s</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The order of <CODE>f</CODE> is such that if <CODE>i&lt;j</CODE> then <CODE>f[i]</CODE> translated by
   any positive multiple of <CODE>(dh,dv)</CODE> doesn't intersect <CODE>f[j]</CODE>.  (Only
   the signs of <CODE>dh</CODE> and <CODE>dv</CODE> affect the order, not their magnitude.)  

<P><PRE>PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Mod">Mod</A>(READONLY p: Point.T;
  READONLY r: T): Point.T;
</PRE><BLOCKQUOTE><EM> Return the element of <CODE>r</CODE> whose distance from <CODE>p</CODE> in each axis is a
   multiple of the size of <CODE>r</CODE> in that axis. This is a checked runtime 
   error if <CODE>r</CODE> is empty. </EM></BLOCKQUOTE><PRE>
</PRE> --- Test --- 

<P><PRE>PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Equal">Equal</A> (READONLY r, s: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Rectangle equality; all empty rectangles are equal </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#IsEmpty">IsEmpty</A>(READONLY r: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>r</CODE> is empty. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Member">Member</A>(READONLY p: Point.T;
  READONLY r: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether p is in r. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Overlap">Overlap</A>(READONLY r, s: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>r</CODE> and <CODE>s</CODE> have any element in common. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Subset">Subset</A>(READONLY r, s: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>r</CODE> is contained in <CODE>s</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Congruent">Congruent</A>(READONLY r, s: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>r</CODE> and <CODE>s</CODE> are congruent, that is,
   whether they have the same height and width. </EM></BLOCKQUOTE><PRE>
</PRE> --- Coordinate Transformation --- 

<P><PRE>PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#GlobToLoc">GlobToLoc</A> (READONLY r: T; READONLY p: Point.T): Point.T;
</PRE><BLOCKQUOTE><EM> Transform p (in global coordinates) to the local coordinate system of r.
   Return Point.Sub(p,NorthWest(r)) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#LocToGlob">LocToGlob</A> (READONLY r: T; READONLY p: Point.T): Point.T;
</PRE><BLOCKQUOTE><EM> Transform p (in the local coordinate system of r) to global coordinates.
   Returns Point.Add(p,NorthWest(r)) </EM></BLOCKQUOTE><PRE>
</PRE> --- Standard type operations --- 

<P><PRE>PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#New">New</A> (READONLY value: T): REF T;
</PRE><BLOCKQUOTE><EM> Allocates and initializes a new heap value </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#NewArray">NewArray</A> (size: CARDINAL;  READONLY value := Empty): REF ARRAY OF T;
</PRE><BLOCKQUOTE><EM> Allocates a new array from the heap
  and initializes all its elements with the given value </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#UntracedNew">UntracedNew</A> (READONLY value: T): UNTRACED REF T;
</PRE><BLOCKQUOTE><EM> Allocates and initializes a new untraced value </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#UntracedNewArray">UntracedNewArray</A> (size: CARDINAL;  READONLY value := Empty):
                                                       UNTRACED REF ARRAY OF T;
</PRE><BLOCKQUOTE><EM> Allocates a new untraced array from the heap
  and initializes all its elements with the given value </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Compare">Compare</A> (READONLY a, b: T): INTEGER;
</PRE><BLOCKQUOTE><EM> == RETURN (-1 if Lt (a, b), 0 if Eq (a, b), +1 o. w.) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Lt">Lt</A> (READONLY a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> == RETURN lexicographic comparison of a, b by &lt;w, e, n, s&gt; </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Eq">Eq</A> (READONLY a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> == RETURN (a = b) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../realgeometry/src/RealRect.m3#Hash">Hash</A> (READONLY a: T): INTEGER;
</PRE><BLOCKQUOTE><EM> == RETURN a suitable hash value  </EM></BLOCKQUOTE><PRE>

END Rect.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
