<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/ShapePixmap.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/ShapePixmap.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison and Steve Glassman 
 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="ShapePixmap.i3">ShapePixmap</A></implements></module>;

IMPORT <A HREF="MGV.i3">MGV</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../ui/src/vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../ui/src/vbt/Palette.i3">Palette</A>, <A HREF="../../ui/src/vbt/ScreenType.i3">ScreenType</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Path.i3">Path</A>,
       <A HREF="R2PathExtra.i3">R2PathExtra</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>;

TYPE
  Closure = Palette.PixmapClosure OBJECT
              pixmap: Pixmap.T;
              path: Path.T;
              border: CARDINAL;
              fill: BOOLEAN;
              v: MGV.V;
            OVERRIDES
              apply := Apply;
            END;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (self: Closure; st: ScreenType.T): ScrnPixmap.T =
  VAR bounds := R2PathExtra.PathBounds(self.path);
  BEGIN
    (* We're only interested in 1-bit deep pixmaps *)
    IF st # st.bits THEN
      RETURN Palette.ResolvePixmap(st.bits, self.pixmap);
    END;

    IF NOT self.fill THEN bounds := Rect.Inset(bounds, -self.border); END;

    VAR shapeVBT := self.v.shapeVBT;
    BEGIN
      IF shapeVBT = NIL THEN
        RETURN Palette.ResolvePixmap(st, Pixmap.Solid);
      END;

      VBT.PaintTint(shapeVBT, bounds, PaintOp.Bg);
      IF self.fill THEN
        VBT.Fill(shapeVBT, bounds, self.path);
      ELSE
        VBT.Stroke(shapeVBT, bounds, self.path, self.border);
      END;

      VAR
        dummy_region: Region.T;
        res := VBT.Capture(shapeVBT, bounds, dummy_region);
      BEGIN
        RETURN res;
      END;
    END;
  END Apply;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY path  : Path.T;
               READONLY border: CARDINAL := 0;
               READONLY fill             := TRUE;
               READONLY v     : MGV.V             ): Pixmap.T =
  VAR
    cl  := NEW(Closure, path := path, border := border, fill := fill, v := v);
    res := Palette.FromPixmapClosure(cl);
  BEGIN
    cl.pixmap := res;
    RETURN res;
  END New;

BEGIN
END ShapePixmap.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
