<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/TypeSelector.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/TypeSelector.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Mick Jordan                                         

<P>| TypeSelector.ig and TypeSelector.mg generate a Selector proc
    (see MGV.i3) which iterates over all elements in the current
    MG VBT and finds the element that is a subtype of Type that
    is closest to the selection point.
<P>
    Likely Usage:
    <P>
    file Piddly.i3:
<P>
    INTERFACE Piddly;
    IMPORT &lt;Some interface with an interesting type&gt;;
    TYPE Type = &lt;interface&gt;.&lt;MG.T subtype&gt;;
    END Piddly.
<P>
    file PiddlySelector.i3:
<P>
    INTERFACE PiddlySelector = TypeSelector()
    END PiddlySelector.
<P>
    file PiddlySelector.m3:
<P>
    MODULE PiddlySelector = TypeSelector(Piddly)
    END PiddlySelector.
<P>
    zeus view implementation:
<P>
    ...
    PROCEDURE Install(view: T) =
    VAR v := 
      NEW(&lt;MGV.V subtype&gt;, selector := PiddlySelector.closest, ...).init(...)
    BEGIN
      View.T.install(view);
      ...
    END Install;
    ...
<P>
    m3makefile:
<P>
    [Ii]nterface(Piddly)
    [Mm]odule(PiddlySelector)
<P>


<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="TypeSelector.mg">TypeSelector</A></genericInterface>();

IMPORT <A HREF="MGV.i3">MGV</A>;

VAR
  closest: MGV.Selector;

END TypeSelector.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
