<HTML>
<HEAD>
<TITLE>SRC Modula-3: mg/src/TypeSelector.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mg/src/TypeSelector.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Mick Jordan                         

<P><PRE>GENERIC MODULE <genericModule><A HREF="TypeSelector.ig">TypeSelector</A></genericModule>(Type);

IMPORT
  <A HREF="MG.i3">MG</A>, <A HREF="MGV.i3">MGV</A>, <A HREF="R2.i3">R2</A>, <A HREF="R2Box.i3">R2Box</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  SelectorIter = MG.GroupIterator OBJECT
    closest: MG.T := NIL;
    dist   : REAL := 999999999.0;
    pos: R2.T;
  OVERRIDES
    proc := SelectorProc;
  END;

PROCEDURE <A NAME="Closest"><procedure>Closest</procedure></A> (&lt;* UNUSED *&gt;          s  : MGV.Selector;
                                                 v  : MGV.V;
                                        READONLY pos: R2.T;
                           &lt;* UNUSED *&gt; READONLY cd : VBT.MouseRec): MG.T =
  VAR iter := NEW(SelectorIter, v := v, pos := pos);
  BEGIN
    EVAL v.displayList.iterate(iter, TRUE, FALSE);
    RETURN iter.closest;
  END Closest;

PROCEDURE <A NAME="SelectorProc"><procedure>SelectorProc</procedure></A> (iter: SelectorIter; t: MG.T): BOOLEAN =
  VAR
    dx, dy, dist: REAL;
    pos                            := iter.pos;
    bounds: R2Box.T;
  BEGIN
    TYPECASE t OF
    | Type.T =&gt;
      bounds := t.appearance.boundingBox(t, iter.v);
      IF pos[0] &lt; bounds[0].lo THEN
        dx := bounds[0].lo - pos[0]
      ELSIF pos[0] &gt; bounds[0].hi THEN
        dx := pos[0] - bounds[0].hi
      ELSE
        dx := 0.0;
      END;
      IF pos[1] &lt; bounds[1].lo THEN
        dy := bounds[1].lo - pos[1]
      ELSIF pos[1] &gt; bounds[1].hi THEN
        dy := pos[1] - bounds[1].hi
      ELSE
        dy := 0.0;
      END;
      IF dx = 0.0 AND dy = 0.00 THEN
        iter.closest := t;
        iter.dist := 0.0;
        RETURN FALSE
      ELSE
        dist := dx * dx + dy * dy;
        IF dist &lt; iter.dist THEN iter.closest := t; iter.dist := dist; END;
        RETURN TRUE;
      END;
    ELSE
      RETURN TRUE
    END;
  END SelectorProc;

BEGIN
  closest := NEW(MGV.Selector, select := Closest);
END TypeSelector.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
