<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/AnimationPath.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/AnimationPath.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="AnimationPath.m3">AnimationPath</A></interface>;

IMPORT <A HREF="GraphVBT.i3">GraphVBT</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../mg/src/R2.i3">R2</A>;
</PRE> This interface contains a collection of animation paths for
   moving a <CODE>GraphVBT.Vertex</CODE>. 

<P><PRE>TYPE
  T = GraphVBT.AnimationPath;

  (* &quot;StraightPath&quot; is a linear path from &quot;p0&quot; to &quot;p1&quot;. *)
  <A HREF="AnimationPath.m3#StraightPath">StraightPath</A> &lt;: StraightPathPublic;
  StraightPathPublic =
    T OBJECT METHODS init (p0, p1: R2.T): T END;

  (* &quot;BezierPath&quot; is a path along the Bezier curve from &quot;p0&quot; to
     &quot;p3&quot;, with control points &quot;p1&quot; and &quot;p2&quot;. *)
  <A HREF="AnimationPath.m3#BezierPath">BezierPath</A> &lt;: BezierPathPublic;
  BezierPathPublic =
    T OBJECT METHODS init (p0, p1, p2, p3: R2.T): T END;

  (* &quot;EdgePath&quot; is the path traced out by edge &quot;e&quot;.  If the
     vertices that define &quot;e&quot; (the two endpoints, with or without
     two addition control points) are also moving, the path
     traced by &quot;e&quot; adjusts dynamically. *)
  <A HREF="AnimationPath.m3#EdgePath">EdgePath</A> &lt;: EdgePathPublic;
  EdgePathPublic =
    T OBJECT METHODS init (e: GraphVBT.Edge): T END;
</PRE> <CODE>MultipleEdgePath</CODE> is the path traced out by the sequence of edges
    in <CODE>edges</CODE>.  If the any of the vertices (the two endpoints, with or without
    two addition control points) that define any of the edges
    are also moving, the path traced adjusts dynamically.  The time spent
    moving along each edge is roughly proportional to the length of the 
    edge.  The edges can be disjoint.

  <PRE><A HREF="AnimationPath.m3#MultipleEdgePath">MultipleEdgePath</A> &lt;: MultipleEdgePathPublic;
  MultipleEdgePathPublic =
    T OBJECT METHODS init (edges: RefList.T (* of GraphVBT.Edge *)): T END;

END AnimationPath.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
