<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/ChipsVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/ChipsVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ChipsVBT.i3">ChipsVBT</A></implements></module>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="RectsVBT.i3">RectsVBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>;

TYPE RefOps = REF ARRAY OF PaintOp.T;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        (* fields are protected by v: *)
        C, R, K: INTEGER;
        ops    : RefOps;
      OVERRIDES
        init := Init;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T): T =
  BEGIN
    RETURN RectsVBT.T.init(v)
  END Init;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> (v: T; C, R, K: INTEGER) =
  BEGIN
    LOCK v DO
      v.C := MAX(C, 1);
      v.R := MAX(R, 1);
      v.K := MAX(K, 1);
      v.ops := NEW(RefOps, K);
      FOR i := 0 TO K - 1 DO
        WITH rgb = Color.FromHSV(
                     Color.HSV{FLOAT(i) * 1.0 / FLOAT(K), 1.0, 1.0}) DO
          v.ops[i] :=
            PaintOp.FromRGB(rgb.r, rgb.g, rgb.b, PaintOp.Mode.Accurate)
        END
      END
    END;
    RectsVBT.SetN(v, C * R);
    RectsVBT.SetWC(v, 0.0, 0.0, FLOAT(C), FLOAT(R))
  END Reset;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (v: T; c, r, k: INTEGER) =
  VAR
    ix: INTEGER;
    op: PaintOp.T;
  BEGIN
    LOCK v DO
      IF r &lt; 1 OR c &lt; 1 OR k &lt; 1 OR r &gt; v.R OR c &gt; v.C OR k &gt; v.K THEN
        RETURN
      END;
      ix := (r - 1) * v.C + c;
      op := v.ops[k - 1];
    END;
    RectsVBT.Position(
      v, ix, FLOAT(c - 1), FLOAT(r - 1), FLOAT(c), FLOAT(r));
    RectsVBT.Color(v, ix, op);
    RectsVBT.Draw(v, ix)
  END Set;

BEGIN
END ChipsVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
