<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/GenericTree.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/GenericTree.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P><PRE>&lt;*PRAGMA LL*&gt;

INTERFACE <interface><A HREF="GenericTree.m3">GenericTree</A></interface>;
</PRE> A SubTree provides the basic structure for a tree.
   A GenericTree provides the layout methods for a general tree.
   A tree can be further sub-typed to provide more appropriate
   or efficient representations for specific kinds of trees


<P><PRE>IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../mg/src/MG.i3">MG</A>, <A HREF="../../mg/src/R2.i3">R2</A>;

TYPE
  <A HREF="GenericTree.m3#V">V</A> &lt;: PublicV;
  PublicV = MG.V OBJECT
              &lt;* LL = self.mu *&gt;
              root  : SubTree := NIL;
            METHODS
              &lt;* LL &lt; self.mu *&gt;
              setRoot   (root: SubTree);
              setBorder (border: ARRAY Axis.T OF REAL);
            END;
</PRE><BLOCKQUOTE><EM> A vbt displaying a tree.  A forest can be displayed using a forest root
   node (below) </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="GenericTree.m3#SubTree">SubTree</A> &lt;: PublicSubTree;
  PublicSubTree =
    MG.Group OBJECT
      &lt;* LL = v.mu *&gt;
      graphic    : MG.T    := NIL;
      parent     : SubTree := NIL;
      numChildren: INTEGER := 0;

      width, height: REAL;
      (* MGPublic.Pos(self) is the &quot;control point&quot; of the subtree's
         rectangle.  &quot;width&quot; and &quot;height&quot; are the dimensions of the
         subtree.

         The node is responsible for maintaining its own width and height
         as children are added and removed.  The parent of the node
         provides the north and west (relative to the parent's control
         point) when it calls translate. *)

      linker: Linker := NIL;
      (* self.linker.new(parent, child) returns a graphical element that
         acts as a link connecting parent and child.  The link ends should
         be individually controllable so the parent and child can move
         separately.

         If linker = NIL, linkerDefault is used and returns a MG.Line with
         MG.LineEnds at parent and child.  The visibility of the child
         controls the visibility of the default link. *)
    METHODS
      &lt;* LL &lt; v.mu *&gt;
      init (v: V; graphic: MG.T): SubTree;
      (* adds graphic to the node, sets the linker to the default linker
         (if it is NIL), calculates the node's size, centers the node (and
         graphic) around the origin, sets visibility to 0.0 (invisible). *)

      &lt;* LL = v.mu *&gt;

      addChild    (v: V; pred, child: SubTree);
      removeChild (v: V; child: SubTree);
      (* add or remove child

         A subtype must supply &quot;addChild&quot; and &quot;removeChild&quot; methods.  For
         addChild, if pred = NIL then add as the first child.

         The default methods adjust numChildren and sets child's parent.

         The subtype is responsible for adjusting its data structures.

         The caller is responsible for calling calculateSize and translate
         soon. *)

      route (v: V; descendant: SubTree): MG.Group;
      (* Return a group of the graphical elements (nodes and links)
         connecting the current node to the given descendant (inclusive).

         The default method constructs the group using link and the parent
         links up from descendant. *)

      succ (v: V; pred: SubTree): SubTree;
      (* A subtype must override the &quot;succ&quot; method.  The default methods
         for &quot;pred&quot;, &quot;nth&quot;, and &quot;iterate&quot; are all built out of &quot;succ&quot;. *)

      pred (v: V; succ: SubTree): SubTree;
      nth  (v: V; n: CARDINAL): SubTree;
      (* return the subtree with n predecessors *)

      iterate (v: V; iter: ChildrenIterator);
      (* iterates locks v.mu, and calls iter.proc for each child of the
         node *)

      calculateSize (v: V);
      (* force a calculation of the bounding box size.  Subtypes may
         override this method to provide different layout policies.  The
         parent will later call translate *)

      translate (v: V; north, west: REAL);
      (* move the sub tree so that its bounding box's north west corner is
         offset R2.T{west, north} from the parent's control point *)

      link (v: V): MG.T;
      (* return the graphical element (could be a line, curve, group, etc)
         that connects the current node and its parent.

         A subtype must supply a &quot;link&quot; method. *)
    END;

TYPE
  LinkerRec = RECORD parentLink, childLink: MG.T END;
  Linker = OBJECT METHODS new (v: V; parent, child: SubTree): LinkerRec END;
</PRE><BLOCKQUOTE><EM> NewLink.proc returns a pair of MG.T elements controlling a graphical
   link between parent and child. </EM></BLOCKQUOTE><PRE>

VAR linkerDefault: Linker;
</PRE><BLOCKQUOTE><EM> If subTree.linker = NIL, linkerDefault is used and returns a MG.Line
   with MG.LineEnds at parent and child.  The visibility of the child
   controls the visibility of the default link. </EM></BLOCKQUOTE><PRE>

TYPE
  ChildrenIterator = OBJECT
                       v: V;
                     METHODS
                       &lt;* LL = v.mu *&gt;
                       proc (child: SubTree): (* more *) BOOLEAN
                     END;

TYPE
  <A HREF="GenericTree.m3#GenericTree">GenericTree</A> &lt;: GenericTreePublic;
  GenericTreePublic =
    SubTree OBJECT
      children              : RefList.T     := NIL;
      linkEndParent, linkEnd: MG.T := NIL;
      dxChildren, dyChildren: REAL       := 5.0;
      (* the space horizontally between children and vertically between
         parents and children, in pts *)
    END;
</PRE><BLOCKQUOTE><EM> A tree with an indeterminate number of children stored as a singly
   linked list </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="GenericTree.m3#Forest">Forest</A> &lt;: ForestPublic;
  ForestPublic = GenericTree OBJECT METHODS init (v: V): Forest; END;
</PRE><BLOCKQUOTE><EM> like a normal tree, excpet that the node does not display and no links
   are drawn to the children. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="GenericTree.m3#SetRoot">SetRoot</A>(root: SubTree; v: V);
&lt;* LL &lt; v.mu *&gt;
</PRE><BLOCKQUOTE><EM><PRE>
      equivalent to:
    </PRE>
LOCK v.mu 
      v.setRoot(root);
      RelayoutAncestors(root);
    END;
    VBT.NewShape(v);
    Animation(v);
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="GenericTree.m3#AddChild">AddChild</A>(node: SubTree; v: V; pred, new: SubTree);
&lt;* LL &lt; v.mu *&gt;
</PRE><BLOCKQUOTE><EM><PRE>
      equivalent to:
    </PRE>
LOCK v.mu 
      node.addChild(v, pred, new); 
      RelayoutAncestors(node, v);
    END;
    VBT.NewShape(v);
    Animation(v);
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="GenericTree.m3#RemoveChild">RemoveChild</A>(node: SubTree; v: V; child: SubTree);
&lt;* LL &lt; v.mu *&gt;
</PRE><BLOCKQUOTE><EM><PRE>
      equivalent to:
    </PRE>
LOCK v.mu 
      node.removeChild(v, child); 
      RelayoutAncestors(node, v);
    END;
    VBT.NewShape(v);
    Animation(v);
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="GenericTree.m3#Route">Route</A>(ancestor: SubTree; v: V; descendant: SubTree): MG.Group;
&lt;* LL &lt; v.mu *&gt;

PROCEDURE <A HREF="GenericTree.m3#Succ">Succ</A> (node: SubTree; v: V; pred: SubTree): SubTree;
&lt;* LL &lt; v.mu *&gt;

PROCEDURE <A HREF="GenericTree.m3#Pred">Pred</A> (node: SubTree; v: V; succ: SubTree): SubTree;
&lt;* LL &lt; v.mu *&gt;

PROCEDURE <A HREF="GenericTree.m3#Nth">Nth</A>(node: SubTree; v: V; n: CARDINAL): SubTree;
&lt;* LL &lt; v.mu *&gt;

PROCEDURE <A HREF="GenericTree.m3#Iterate">Iterate</A> (node: SubTree; v: V; iter: ChildrenIterator);
&lt;* LL &lt; v.mu *&gt;

PROCEDURE <A HREF="GenericTree.m3#NumChildren">NumChildren</A>(node: SubTree; v: V): INTEGER;
&lt;* LL &lt; v.mu *&gt;

PROCEDURE <A HREF="GenericTree.m3#Parent">Parent</A>(node: SubTree; v: V): SubTree;
&lt;* LL &lt; v.mu *&gt;

PROCEDURE <A HREF="GenericTree.m3#ParentPos">ParentPos</A>(parent: SubTree; v: V): R2.T;
&lt;* LL = v.mu *&gt;

PROCEDURE <A HREF="GenericTree.m3#LinearAnimation">LinearAnimation</A> (v: V; vector: R2.T; mg: SubTree): BOOLEAN;
&lt;* LL = v.mu *&gt;
</PRE><BLOCKQUOTE><EM> Creates a linear animation to move <CODE>mg</CODE> by <CODE>vector</CODE>, adding the
   animation to v's animations.
<P>
   If Pos(mg) = R2.Origin, then a special animation is produced which moves
   mg by vector at time 0.0 and makes mg visible at time 1.0.
<P>
   Returns TRUE if vector # R2.Origin or mg has been altered in some way
   (child added, transformed, etc).  Children don't have to be relayed out
   if LinearAnimation return FALSE </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="GenericTree.m3#RelayoutAncestors">RelayoutAncestors</A>(node: SubTree; v: V);
&lt;* LL = v.mu *&gt;

END GenericTree.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
