<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/GraphAnim.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/GraphAnim.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="GraphAnim.i3">GraphAnim</A></implements></module>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="../../mg/src/Animate.i3">Animate</A>, <A HREF="AnimationPath.i3">AnimationPath</A>, <A HREF="GraphVBT.i3">GraphVBT</A>, <A HREF="GraphVBTExtras.i3">GraphVBTExtras</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>,
   <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="../../mg/src/Matrix2D.i3">Matrix2D</A>, <A HREF="../../mg/src/MG.i3">MG</A>, <A HREF="../../mg/src/MGV.i3">MGV</A>, <A HREF="../../mg/src/R2.i3">R2</A>;

TYPE
  RotateAnimation = Animate.T BRANDED OBJECT
    center: GraphVBT.Vertex;
    angle: REAL;
    vertices: RefList.T;
  OVERRIDES
    length := LengthAnim;
    doStep := DoStepRotate
  END;

PROCEDURE <A NAME="LengthAnim"><procedure>LengthAnim</procedure></A> (&lt;* UNUSED *&gt; anim: Animate.T;
                      &lt;* UNUSED *&gt; v   : MG.V;
                      &lt;* UNUSED *&gt; mg  : MG.T       ): INTEGER =
  BEGIN
    RETURN 100
  END LengthAnim;

&lt;* LL &lt;+ VBT.mu *&gt;
PROCEDURE <A NAME="DoStepRotate"><procedure>DoStepRotate</procedure></A> (             anim          : RotateAnimation;
                                     time, timePrev: REAL;
                        &lt;* UNUSED *&gt; v             : MG.V;
                        &lt;* UNUSED *&gt; mg            : MG.T             ) =
  VAR
    vertices                  := anim.vertices;
    vertex  : GraphVBT.Vertex;
    center                    := anim.center.pos;
    m := Matrix2D.Concat3(
           Matrix2D.Translate(-center[0], -center[1]),
           Matrix2D.Rotate((time - timePrev) * -anim.angle * Math.Degree),
           Matrix2D.Translate(center[0], center[1]));
  BEGIN
    LOCK anim.center.graph.mu DO
      WHILE vertices # NIL DO
        vertex := vertices.head;
        vertices := vertices.tail;
        vertex.move(Matrix2D.Transform(m, vertex.pos));
      END;
    END;
  END DoStepRotate;
</PRE> copy l and remove any duplicates.  Very inefficient for big lists... 
<PRE>PROCEDURE <A NAME="RemoveDups"><procedure>RemoveDups</procedure></A> (l: RefList.T): RefList.T =
  VAR
    res, ll: RefList.T;
    v      : REFANY;
    found  : BOOLEAN;
  BEGIN
    WHILE l # NIL DO
      v := l.head;
      l := l.tail;
      ll := res;
      found := FALSE;
      WHILE ll # NIL DO found := found OR ll.head = v; ll := ll.tail END;
      IF NOT found THEN res := RefList.Cons(v, res); END;
    END;
    RETURN res;
  END RemoveDups;

PROCEDURE <A NAME="Rotate"><procedure>Rotate</procedure></A> (center  : GraphVBT.Vertex;
                  angle   : REAL;
                  vertices: RefList.T (* of GraphVBT.Vertex *)) =
  VAR mgv := GraphVBTExtras.GetMG(center.graph);
  BEGIN
    IF vertices = NIL THEN RETURN END;
    MGV.AddAnimation(
      mgv, NEW(RotateAnimation, center := center, angle := angle,
               vertices := RemoveDups(vertices)).init(), NIL)
  END Rotate;

TYPE
  MoveAnimation =
    Animate.T BRANDED OBJECT
      graph   : GraphVBT.T;
      path    : AnimationPath.MultipleEdgePath;
      vertices: RefList.T;
      (* cheap cache of last position if animation isn't shared *)
      posPrev : R2.T;
      timePrev: REAL := -1.0;
    OVERRIDES
      length := LengthAnim;
      doStep := DoStepMove
    END;

&lt;* LL &lt;+ VBT.mu *&gt;
PROCEDURE <A NAME="DoStepMove"><procedure>DoStepMove</procedure></A> (             anim          : MoveAnimation;
                                   time, timePrev: REAL;
                      &lt;* UNUSED *&gt; v             : MG.V;
                      &lt;* UNUSED *&gt; mg            : MG.T           ) =
  VAR
    vertices                        := anim.vertices;
    pos, posPrev, delta: R2.T;
    vertex             : GraphVBT.Vertex;
  BEGIN
    LOCK anim.graph.mu DO
      pos := anim.path.pos(time);
      IF anim.timePrev = timePrev THEN
        posPrev := anim.posPrev;
      ELSE
        posPrev := anim.path.pos(timePrev);
      END;
      delta := R2.Sub(pos, posPrev);
      WHILE vertices # NIL DO
        vertex := vertices.head;
        vertices := vertices.tail;
        vertex.move(R2.Add(vertex.pos, delta));
      END;
      anim.timePrev := time;
      anim.posPrev := pos;
    END;
  END DoStepMove;

PROCEDURE <A NAME="MoveAlongEdges"><procedure>MoveAlongEdges</procedure></A> (edges   : RefList.T (* of GraphVBT.Edge *);
                          vertices: RefList.T (* of GraphVBT.Vertex *)) =
  VAR graph := NARROW(vertices.head, GraphVBT.Vertex).graph;
  BEGIN
    MGV.AddAnimation(
      GraphVBTExtras.GetMG(graph),
      NEW(MoveAnimation, graph := graph,
          path := NEW(AnimationPath.MultipleEdgePath).init(edges),
          vertices := RemoveDups(vertices)).init(), NIL);
  END MoveAlongEdges;

BEGIN
END GraphAnim.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
