<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/GraphVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/GraphVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="GraphVBT.m3">GraphVBT</A></interface>;
</PRE> A GraphVBT.T is a VBT class for constructing displays of graphs of
   vertices, edges, and polygons.  Alternatively, you can use it to display
   certain other data structures; for example, you can just use GraphVBT as
   a way to draw and move vertices on a VBT.
<P>
   There are operations to build a graph, and operations to update it
   (e.g., by moving vertices to new positions, automatically bringing their
   edges with them).  Many such updates can be animated, with objects
   slowly sliding toward their new positions, etc. 

<P> OBJECT CLASSES
<P>
   T.  A VBT class for displaying graph elements.
<P>
   Vertex.  A colored rectangle or ellipse with a textual label, with its
   center at specified coordinates.
<P>
   Edge.  A straight or curved colored line between a pair of vertices,
   with optional arrowheads.
<P>
   VertexHighlight.  A colored border on a vertex.
<P>
   Polygon.  A filled colored region specified by a path of vertices. 

<P> COORDINATES
<P>
   Each GraphVBT.T has a specified world coordinate system: [w..e]*[n..s],
   where (w, n) is the window's NW corner.  It is required that e # w, and
   that s # n.  It is allowed for e to be less than w, or s less than n, in
   which case the coordinate system changes handedness.
<P>
   All positions and sizes are given in world coordinates.
<P>
   The preferred size is the size of the graph vbt when it is first created.  
   Any changes by the user to the size of the window take precedence.
   The world coordinate system is automatically scaled to fit the current
   size of the window and all objects and fonts are scaled appropriately.
<P>
   The display rectangle is centered in the window, bordered by at least
   the fixed margin.  Optionally, its size in pixels can be constrained to
   be a multiple of specified values horizontally and vertically; this can
   improve esthetics when the client deals with the corresponding fractions
   of world coordinates.  Also optionally, the display rectangle can be
   constrained to (approximately) a specified aspect ratio.
<P>
   If an element's coordinates lie outside the specified coordinate system,
   they are still mapped linearly onto the VBT, but they may be partially
   or completely invisible. 

<P> APPEARANCE
<P>
   The graph itself has a white (Bg) background.
<P>
   Each vertex is painted as a colored solid shape--a rectangle or an
   ellipse--with a colored textual label in a specified font, with its
   center at a specified coordinate position.  The client specifies the
   size and colors of the vertex.  The vertex has an optional inset border
   of a specified size and color.
<P>
   The actual point size of the font used to display the label is the 
   closest available font size to the scaled world size.
<P>
   Edges are painted as colored lines connecting the centers of their
   vertices.  There is an optional arrowhead at each end; the size of the
   arrowhead is scaled with the width of the line.  Edges may be either
   straight lines or cubic Bezier curves.  If they are Beziers, the client
   specifies two additional vertices that act as control points.  If
   desired, these vertices can be zero-size and therefore invisible.
<P>
   Vertex highlights are painted as colored shapes that appear centered
   behind specified vertices, giving the appearance of a colored borders.
   The vertex highlight has the same shape as its vertex, and the same size
   plus a margin.  When a vertex highlight moves during an animation, the
   whole highlight appears when it is temporarily not behind any vertex.
<P>
   Polygons are painted as colored polygonal filled regions whose sides are
   straight and whose corners are the centers of specified vertices.  The
   handedness of the outline is ignored; it's always the interior of the
   polygon that is filled.
<P>
   When vertices are moved, their edges, polygons, and highlights move with
   them.
<P>
   On the display, vertexes appear in front of edges, edges in front of
   vertex highlights, and vertex highlights in front of polygons.  There is
   no other specified order of objects.  However, a vertex may be moved to
   the front or to the back of the other vertices, leaving the relative
   order of the others the same, and similarly for the other elements.  No
   other operations change the relative orders of objects on the display
   (except init and remove, of course). 

<P> ANIMATION
<P>
   Operations on objects in the graph may be either IMMEDIATE or ANIMATED,
   depending on the <CODE>animated</CODE> parameter.  (Some operations are always
   immediate due to implementation restrictions; others because animation
   would not make sense.)
<P>
   IMMEDIATE operations take place when invoked.  However, they may or may
   not appear on the screen immediately.  They can be forced to appear by
   calling the graph's <CODE>redisplay</CODE> method.
<P>
   The results of ANIMATED operations remain pending until the graph's
   <CODE>animate</CODE> method is invoked.  For example, if a vertex is moved in
   animated mode, the new position does not take effect immediately, but
   remains pending until the graph is animated.  At that time, all pending
   animated operations are performed over a specified time interval; a
   vertex will move in a smooth path from its current position to its final
   position, as will its highlights, polygons, and edges (including any
   Bezier curves for which it's a control point).
<P>
   Multiple moves without intervening animations overwrite each other.
<P>
   Animated operations normally maintain a pending STATE.  If a vertex is
   moved to one position and then another in the same animation, it slides
   directly to the final position during the animation.
<P>
   During an animation, elements normally takes straight paths from their
   initial positions to their new positions.  Optionally, an arbitrary path
   can be specified for a vertex; an optional AnimationPath object contains
   a method that maps a time during the animation (scaled to be between 0.0
   and 1.0) to the desired vertex position in world coordinates.  When a
   vertex follows such a path, so do any edge ends, highlights, corners of
   polygons, etc., that remain attached during the animation.  Otherwise,
   edge ends, vertex highlights, and corners of polygons follow straight
   paths to their final positions.
<P>
   There may be multiple animations per Zeus event.  Each animation starts
   at Zeus time t0 and ends at Zeus time t1.  (Zeus times are given in
   seconds but are scaled by Zeus.) For an event's first animation, t0
   should be 0; for subsequent animations for the same event, t0 should be
   the previous animation's t1.
<P>
   If t0 = t1, the animation appears to happen immediately. 
<P>
   Animations may be aborted by a Thread.Alert on the thread that called
   graph.animate.  The animation checks for an alert at the end of each frame in
   the animation.


<P> LOCKING LEVELS
<P>
   Almost all methods in this interface have &lt;* LL.sup = graph.mu *&gt;.
<P>
   The <CODE>init</CODE> methods have &lt;* LL.sup &lt; graph.mu *&gt;.
<P>
   The <CODE>animate</CODE> method on graphs also has &lt;* LL.sup &lt; graph.mu *&gt;.
<P>
   The <CODE>redisplay</CODE> method on graphs has &lt;* LL.sup &lt;= VBT.mu *&gt;. 

<P> DESIGN DEFICIENCIES.
<P>
   No direct support for graphs.  For example, there is no operations to go
   from an adjacency matrix to a representation on the screen.
<P>
   No labels on edges.
<P>
   It is unclear how easily these method classes can be overridden by
   clients. 

<P> IMPLEMENTATION RESTRICTIONS.
<P>
   The interface should not advertise that GraphVBT.T is a subtype of MG.V.
   This is a temporary workaround.
<P>
   Not all interesting operations can be animated.
<P>
   When edges move, their arrowheads may seem to float off and back on.
<P>
   Vertices' inset borders are drawn in fontColor, nor borderColor.
<P>
   The verticesAt/edgesAt/vertexHighlightsAt/polygonsAt operations have an 
   internal model distinct from the actual renderer's, and sometimes return 
   the wrong answers near boundaries.
<P>
   GraphVBT must be used under Zeus. 

<P> POSSIBLE ADDITIONS.
<P>
   Set coordinate system and margins.
<P>
   Edge highlights.
<P>
   Highlights <CODE>on top</CODE>.
<P>
   Group highlight.
<P>
   Callbacks for input events. 

<P><PRE>IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../mg/src/R2.i3">R2</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

&lt;* PRAGMA LL *&gt;

TYPE
  <A HREF="GraphVBT.m3#T">T</A> &lt;: TPublic;
  <A HREF="GraphVBT.m3#TPrivate">TPrivate</A> &lt;: VBT.T;
  TPublic =
    TPrivate OBJECT
      mu: MUTEX;

      (* READONLY after initialization: MAY be initialized by client *)
      &lt;* LL &gt;= {SELF.mu} *&gt;
      world  := WorldRectangle{w := 0.0, e := 1.0, n := 0.0, s := 1.0};
      margin := 0.0;             (* margin size *)
      pixelSizeDivisor := ARRAY [0 .. 1] OF CARDINAL{1, 1};
      (* the display rectangle will be a multiple of pixelSizeDivisor[0]
         pixels wide, and a multiple of pixelSizeDivisor[1] pixels tall *)
      aspect := 0.0;
      (* if non-zero, display rectangle keeps (approximately) this ratio of
         height / width, subject to pixelSizeDivisor. *)

      preferredSize := R2.T{100.0, 100.0};
      (* The initial size (in mm) of the window when first installed.
         Scaling is adjusted so that the nominal size of the display
         remains the preferredSize at all times. *)

      (* READONLY *)
      vertices: RefList.T (* OF Vertex *) := NIL; (* unordered *)
      edges   : RefList.T (* OF Edge *)   := NIL; (* unordered *)
      vertexHighlights: RefList.T (* OF VertexHighlight *) := NIL; (* unordered *)
      polygons: RefList.T (* OF Polygon *) := NIL; (* unordered *)
    METHODS

      (* MUST be called by client. *)
      &lt;* LL.sup &lt; SELF.mu *&gt;
      init (): T;                (* no-op if already initialized *)

      (* &quot;setWorld&quot; updates self's world rectangle. *)
      &lt;* LL.sup = SELF.mu *&gt;
      setWorld (world: WorldRectangle (* the new world rectangle *));

      (* &quot;setMargin&quot; updates self's margin. *)
      &lt;* LL.sup = SELF.mu *&gt;
      setMargin (margin: REAL (* the new margin *));

      (* &quot;setPixelSizeDivisor&quot; updates the self's pixelSizeDivisors. *)
      &lt;* LL.sup = SELF.mu *&gt;
      setPixelSizeDivisor (pixelSizeDivisor: ARRAY [0 .. 1] OF CARDINAL (* the divisors *));

      (* &quot;setAspect&quot; updates the self's aspect. *)
      &lt;* LL.sup = SELF.mu *&gt;
      setAspect (aspect: REAL (* the new aspect *));

      (* &quot;setPreferredSize&quot; updates the self's preferredSize. *)
      &lt;* LL.sup = SELF.mu *&gt;
      setPreferredSize (preferredSize: R2.T (* the new prferred size *));

      (* &quot;redisplay&quot; should be called after performing immediate operations
         to make the display consistent. *)
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      redisplay ();

      (* &quot;animate&quot; animates all pending animated changes to a graph, over a
         specified time interval.  If t0 = t1, the changes appear
         instantaneously. *)
      &lt;* LL.sup &lt; SELF.mu *&gt;
      animate (t0, t1: REAL) RAISES {Thread.Alerted};

      (* &quot;clear&quot; removes all graphic objects from the graph (calling their
         &quot;remove&quot; methods). *)
      &lt;* LL.sup = SELF.mu *&gt;
      clear ();

      (* &quot;verticesAt&quot; returns a list, in front-to-back order, of all the
         vertices that lie partly or totally inside a specified screen
         rectangle. *)
      &lt;* LL.sup = SELF.mu *&gt;
      verticesAt (pixelRect: Rect.T): RefList.T (* OF Vertex *);

      (* &quot;edgesAt&quot; returns a list, in front-to-back order, of all the edges
         that lie partly or totally inside a specified screen rectangle. *)
      &lt;* LL.sup = SELF.mu *&gt;
      edgesAt (pixelRect: Rect.T): RefList.T (* OF Edge *);

      (* &quot;vertexHighlightsAt&quot; returns a list, in front-to-back order, of
         all the vertex highlights that lie partly or totally inside a
         specified screen rectangle. *)
      &lt;* LL.sup = SELF.mu *&gt;
      vertexHighlightsAt (pixelRect: Rect.T):
                          RefList.T (* OF VertexHighlight *);

      (* &quot;polygonsAt&quot; returns a list, in front-to-back order, of all the
         polygons that lie partly or totally inside a specified screen
         rectangle. *)
      &lt;* LL.sup = SELF.mu *&gt;
      polygonsAt (pixelRect: Rect.T): RefList.T (* OF Polygon *);

      &lt;* LL.sup arbitrary *&gt;
      font (family : TEXT  := &quot;Helvetica&quot;;
            size   : REAL  := 0.0353;
            slant  : Slant := Slant.Roman;
            weight : TEXT  := &quot;Normal&quot;;
            foundry: TEXT  := &quot;*&quot;          ): WorldFont;
      (* &quot;font&quot; returns a font with the given characteristics where &quot;size&quot;
         is in world coordinates *)
    END;

TYPE
  Slant = {Roman, Italic, Oblique, ReverseItalic,
    ReverseOblique, Other, Any};

TYPE
  <A HREF="GraphVBT.m3#Vertex">Vertex</A> &lt;: VertexPublic;
  VertexPublic =
    OBJECT

      (* READONLY after initialization: MUST be initialized by client *)
      (* CONST *)
      graph: T;                 (* the GraphVBT.T containing this vertex *)

      (* READONLY after initialization: MUST be initialized by client *)
      &lt;* LL &gt;= {SELF.graph.mu} *&gt;
      pos: R2.T;                (* the vertex's position *)
      shape: VertexShape;       (* the vertex's shape.  use &quot;setShape&quot; to
                                   update. *)

      (* READONLY after initialization: one of two MUST be initialized by
         client *)
      &lt;* LL &gt;= {SELF.graph.mu} *&gt;
      size := R2.T{0.0, 0.0};  (* the vertex's h and v siz.
                                  use &quot;setSize&quot; to update. *)

      (* READONLY after initialization: MAY be initialized by client *)
      &lt;* LL &gt;= {SELF.graph.mu} *&gt;
      color: PaintOp.T := PaintOp.Fg; (* the tint for the vertex (the
                                         default is black).  use &quot;setColor&quot;
                                         to update. *)
      label: TEXT := &quot;&quot;;        (* the vertex's label.  use &quot;setLabel&quot; to
                                   update. *)
      font: WorldFont := NIL; (* the font for the label.  use
                                 &quot;setFont&quot; to update. IF &quot;font&quot; = NIL then
                                 DefaultFont will be used. *)
      fontColor: PaintOp.T := PaintOp.Bg; (* the tint for the vertex's
                                             label (the default is white).
                                             use &quot;setFontColor&quot; to
                                             update. *)
      border := 0.0;          (* the vertex's inset border size.
                                 use &quot;setBorder&quot; to  update. *)
      borderColor: PaintOp.T := PaintOp.Fg; (* the tint for the vertex's
                                               inset border (the default is
                                               black).  use
                                               &quot;setBorderColor&quot; to
                                               update. *)
      (* IMPLEMENTATION RESTRICTION: The value of borderColor is ignored
         and the inset margin is drawn in &quot;fontColor&quot;. *)

      (* READONLY *)
      edges: RefList.T (* OF Edge *) := NIL;
      (* the edges that mention this vertex.  unordered.  edges that
         mention this vertex more than once (e.g., edges from this vertex
         to itself) may or may not appear more than once. *)
      vertexHighlights: RefList.T (* OF VertexHighlight *) := NIL;
      (* the highlights on this vertex.  unordered. *)
      polygons: RefList.T (* OF Polygon *) := NIL;
      (* the polygons with corners at this vertex.  unordered.  polygons
         with multiple corners at this vertex may or may not appear more
         than once. *)

    METHODS

      (* MUST be called by client. *)
      &lt;* LL.sup &lt; SELF.graph.mu *&gt;
      init (): Vertex;          (* no-op if already initialized *)

      (* &quot;move&quot; moves the vertex to a new position given by h and v; when a
         vertex moves, so do its edges, highlights, and polygons. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      move (pos: R2.T (* the new position *);
            animated: BOOLEAN := FALSE; (* if TRUE, the move is animated *)
            start := 0.0; stop := 1.0; (* if animated, the timing of the animation *)
            path: AnimationPath := NIL); (* if non-NIL, specfies the path
                                            for the animation *)

      (* &quot;setSize&quot; updates the vertex's size. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      setSize (size: R2.T (* the new size*));

      (* &quot;setShape&quot; updates the vertex's shape. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      setShape (shape: VertexShape);

      (* &quot;setColor&quot; updates the vertex's color. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      setColor (color: PaintOp.T);

      (* &quot;setLabel&quot; updates the vertex's label. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      setLabel (label: TEXT);

      (* &quot;setFont&quot; updates the label's Font.  If &quot;font&quot; = NIL then DefaultFont
         will be used. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      setFont (font: WorldFont);

      (* &quot;setFontColor&quot; updates the label's color. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      setFontColor (fontColor: PaintOp.T);

      (* &quot;setBorder&quot; updates the vertex's inset border size. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      setBorder (border: REAL (* the new inset border size *));

      (* &quot;setBorderColor&quot; updates the inset border's color. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      setBorderColor (borderColor: PaintOp.T);

      (* &quot;toFront&quot; moves the vertex's appearance to the front of the other
         vertices, the foreground or the background objects in its graph. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      toFront (zorder := ZOrder.Normal);

      (* &quot;toBack&quot; moves the vertex to the back of the other vertices,
          the foreground or the background objects. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      toBack (zorder := ZOrder.Normal);

      (* &quot;remove&quot; removes a vertex from its graph, along with all its
         edges, highlights, and polygons.  they may be reinstalled with
         init. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      remove ();

    END;

TYPE
  ZOrder = {Foreground, Normal, Background};
  (* All object are overlaid in the following order.  Foreground objects are
     on top of all other objects.  They are followed by Normal vertices,
     then Normal vertex highlights, Normal edges and Normal polygons.
     Finally all Background objects are under all other objects.

     The toFront and toBack methods are used to change the overlay order
     of an object.
  *)

TYPE
  <A HREF="GraphVBT.m3#WorldFont">WorldFont</A> &lt;: REFANY;

VAR (* CONST *)
  DefaultFont: WorldFont;
  (* &quot;DefaultFont&quot; will appear as a 10pt helvetica font in the default
      world configuration:
      self.world = {0, 1, 0, 1} and preferred size = {100, 100}.

      It is equivalent to a font whose size = 0.0353 in world coordinates.
  *)

TYPE
  <A HREF="GraphVBT.m3#Edge">Edge</A> &lt;: EdgePublic;
  EdgePublic =
    OBJECT

      (* READONLY after initialization: MUST be initialized by client *)
      &lt;* LL &gt;= {SELF.vertex0.graph.mu} *&gt;
      vertex0, vertex1: Vertex;  (* the vertices that the edge connects.
                                    must belong to same graph.  use &quot;move&quot;
                                    to update. *)

      (* READONLY after initialization: MAY be initialized by client *)
      &lt;* LL &gt;= {SELF.vertex0.graph.mu} *&gt;
      width := 0.007;         (* the edge's width. use &quot;setWidth&quot; to update. *)
      color: PaintOp.T := PaintOp.Fg; (* the edge's color (the default is
                                         black).  use &quot;setColor&quot; to
                                         update. *)
      arrow := ARRAY [0 .. 1] OF BOOLEAN{FALSE, FALSE};
      (* whether there is an arrowhead at vertex0 or at vertex1.  use
         &quot;setArrow&quot; to update. *)
      control0, control1: Vertex := NIL;
      (* if both NIL, the edge is straight.  otherwise, the edge is a
         Bezier, and these vertices (in the same graph) are the control
         points.  use &quot;move&quot; to update. *)

    METHODS

      (* MUST be called by client. *)
      &lt;* LL.sup &lt; SELF.vertex0.graph.mu *&gt;
      init (): Edge;            (* no-op if already initialized *)

      (* &quot;move&quot; connects the edge to new vertices in the same graph. *)
      &lt;* LL.sup = SELF.vertex0.graph.mu *&gt;
      move (vertex0, vertex1  : Vertex;
            control0, control1: Vertex   := NIL;
            animated          : BOOLEAN  := FALSE;
            start := 0.0; stop := 1.0); (* if animated, the timing of the animation *)

      (* &quot;setWidth&quot; updates the edge's width. *)
      &lt;* LL.sup = SELF.vertex0.graph.mu *&gt;
      setWidth (width: REAL);

      (* &quot;setColor&quot; updates the edge's color. *)
      &lt;* LL.sup = SELF.vertex0.graph.mu *&gt;
      setColor (color: PaintOp.T);

      (* &quot;setArrow&quot; updates whether there are arrowheads at the ends of the
         edge. *)
      &lt;* LL.sup = SELF.vertex0.graph.mu *&gt;
      setArrow (arrow: ARRAY [0 .. 1] OF BOOLEAN);

      (* &quot;toFront&quot; moves the edge's appearance to the front of the other
         edges, the foreground or the background objects in its graph. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      toFront (zOrder := ZOrder.Normal);

      (* &quot;toBack&quot; moves the edge to the back of the other edges, the
         foreground or the background objects. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      toBack (zOrder := ZOrder.Normal);

      (* &quot;remove&quot; removes a edge from its graph.  it may be reinstalled
         with init. *)
      &lt;* LL.sup = SELF.vertex0.graph.mu *&gt;
      remove ();

    END;

TYPE
  <A HREF="GraphVBT.m3#VertexHighlight">VertexHighlight</A> &lt;: VertexHighlightPublic;
  VertexHighlightPublic =
    OBJECT

      (* READONLY after initialization: MUST be initialized by client *)
      &lt;* LL &gt;= {SELF.vertex.graph.mu} *&gt;
      vertex: Vertex;           (* the vertex to vertexHighlight *)
      color: PaintOp.T;         (* the tint for the vertexHighlight; note
                                   that a white (Bg) vertexHighlight is
                                   invisible against the background.  use
                                   &quot;setColor&quot; to update. *)

      (* READONLY after initialization: one of two MUST be initialized by
         client *)
      &lt;* LL &gt;= {SELF.vertex.graph.mu} *&gt;
      border := R2.T{0.0, 0.0}; (* border width horizontally and vertically.
                                   use &quot;setBorder&quot; to update. *)

    METHODS

      (* MUST be called by client. *)
      &lt;* LL.sup &lt; SELF.vertex.graph.mu *&gt;
      init (): VertexHighlight; (* no-op if already initialized *)

      (* &quot;move&quot; moves the vertexHighlight to a new vertex in the same
         graph. *)
      &lt;* LL.sup = SELF.vertex.graph.mu *&gt;
      move (vertex: Vertex; animated: BOOLEAN := FALSE;
            start := 0.0; stop := 1.0); (* if animated, the timing of the animation *)

      (* &quot;setBorder&quot; updates the vertexHighlight border width. *)
      &lt;* LL.sup = SELF.vertex.graph.mu *&gt;
      setBorder (border: R2.T);

      (* &quot;setColor&quot; updates the vertexHighlight's PaintOp.T. *)
      &lt;* LL.sup = SELF.vertex.graph.mu *&gt;
      setColor (color: PaintOp.T);

      (* &quot;toFront&quot; moves the vertex highlight's appearance to the front of
         the other vertex highlights, the foreground or the background objects
         in its graph. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      toFront (zOrder := ZOrder.Normal);

      (* &quot;toBack&quot; moves the vertex highlight to the back of the other
         vertex highlights, the foreground or the background objects. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      toBack (zOrder := ZOrder.Normal);

      (* &quot;remove&quot; removes a vertexHighlight from its graph.  it may be
         reinstalled with init. *)
      &lt;* LL.sup = SELF.vertex.graph.mu *&gt;
      remove ();

    END;

TYPE
  <A HREF="GraphVBT.m3#Polygon">Polygon</A> &lt;: PolygonPublic;
  PolygonPublic =
    OBJECT
      (* READONLY after initialization: MUST be initialized by client *)
      &lt;* LL &gt;= {SELF.vertices.head.graph.mu} *&gt;
      vertices: RefList.T (* OF Vertex or List of 3 Vertices *);
        (* specifies the edges defining the polygon.  A vertex
           indicates a straight edge from the end point of the previous edge.
           A list of 3 vertices indicates a bezier edge.  The first 2
           vertices are the control vertices of the edge and the third vertex
           is the end point of the vertex.  All vertices must belong to the same
           graph.  use &quot;move&quot; to  update. *)

      (* READONLY after initialization: MAY be initialized by client *)
      &lt;* LL &gt;= {RefList.First(SELF.vertices).graph.mu} *&gt;
      color: PaintOp.T := PaintOp.Fg; (* the polygon's color (the default
                                         is black).  use &quot;setColor&quot; to
                                         update. *)

    METHODS

      (* MUST be called by client. *)
      &lt;* LL.sup &lt; RefList.First(SELF.vertices).graph.mu *&gt;
      init (): Polygon;         (* no-op if already initialized *)

      (* &quot;move&quot; connects the polygon to new vertices in the same graph. *)
      &lt;* LL.sup = RefList.First(SELF.vertices).graph.mu *&gt;
      move (vertices: RefList.T (* OF Vertex or List of 3 vertices *);
            animated: BOOLEAN := FALSE;
            start := 0.0; stop := 1.0); (* if animated, the timing of the animation *)

      (* &quot;setColor&quot; updates the polygon's color. *)
      &lt;* LL.sup = RefList.First(SELF.vertices).graph.mu *&gt;
      setColor (color: PaintOp.T);

      (* &quot;toFront&quot; moves the polygon's appearance to the front of the other
         polygons, the foreground or the background objects in its graph. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      toFront (zOrder := ZOrder.Normal);

      (* &quot;toBack&quot; moves the polygon to the back of the other polygons, the
         foreground or the background objects. *)
      &lt;* LL.sup = SELF.graph.mu *&gt;
      toBack (zOrder := ZOrder.Normal);

      (* &quot;remove&quot; removes a polygon from its graph.  it may be reinstalled
         with init. *)
      &lt;* LL.sup = RefList.First(SELF.vertices).graph.mu *&gt;
      remove ();

    END;

TYPE
  (* A WorldRectangle is contained in a GraphVBT.T.  It defines the bounds
     of the world coordinate system for the GraphVBT.T. *)
  WorldRectangle = RECORD
                     w: REAL := 0.0;
                     e: REAL := 1.0;
                     n: REAL := 0.0;
                     s: REAL := 1.0;
                   END;

TYPE
  (* A VertexShape designates the shape of a vertex.  There are only a few
     possible shapes. *)
  VertexShape = {Rectangle, Ellipse};

TYPE
  (* An AnimationPath can specify the path a vertex takes when it is
     animated.  Its &quot;pos&quot; method maps a time between 0.0 and 1.0 onto a
     position in world coordinates. *)
  AnimationPath = OBJECT
  METHODS
    &lt;* LL.sup = {vertex.graph.mu, vertex.graph.mgv.mu *&gt;
    pos (t: REAL): R2.T;
   END;

END GraphVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
