<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/Grid.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/Grid.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison 

<P><PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="Grid.i3">Grid</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../mg/src/MG.i3">MG</A>, <A HREF="../../mg/src/MGV.i3">MGV</A>,
       <A HREF="../../vbtkitutils/src/Pts.i3">Pts</A>, <A HREF="../../mg/src/R2.i3">R2</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="V">V</A> = PublicV BRANDED OBJECT
      OVERRIDES
        init    := Init;
        reshape := MGV.ReshapeLeaveOrigin;
        shape   := Shape;
      END;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (v: V; ax: Axis.T; &lt;* UNUSED *&gt; n: CARDINAL):
  VBT.SizeRange =
  BEGIN
    WITH pref = Pts.ToScreenPixels(v, v.size[ax] + 2.0 * v.border[ax], ax) DO
      RETURN VBT.SizeRange{0, pref, MAX(pref + 1, VBT.DefaultShape.hi)}
    END;
  END Shape;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: V; rows, cols: CARDINAL; width, height: REAL): V =
  BEGIN
    EVAL MGV.V.init(v);
    v.a := NEW(Array, rows, cols);
    v.group := NEW(MG.Group).init(v := v);
    v.size[Axis.T.Hor] := FLOAT(cols) * width;
    v.size[Axis.T.Ver] := FLOAT(rows) * height;
    WITH hor = v.border[Axis.T.Hor],
         ver = v.border[Axis.T.Ver]  DO
      FOR i := 0 TO rows - 1 DO
        FOR j := 0 TO cols - 1 DO
          v.a[i, j] := NEW(MG.Rectangle).init(
                         R2.T{hor + FLOAT(j) * width,
                              -ver - FLOAT(i) * height},
                         R2.T{hor + FLOAT(j + 1) * width,
                              -ver - FLOAT(i + 1) * height}, v, v.group);
        END;
      END;
    END;
    RETURN v;
  END Init;

BEGIN
END Grid.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
