<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/IntArrayView.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/IntArrayView.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="IntArrayView.i3">IntArrayView</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../mg/src/MG.i3">MG</A>, <A HREF="../../mg/src/MGV.i3">MGV</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../vbtkitutils/src/Pts.i3">Pts</A>, <A HREF="../../mg/src/R2.i3">R2</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="V">V</A> = PublicV BRANDED OBJECT
  OVERRIDES
    reshape := MGV.ReshapeLeaveOrigin;
    shape := Shape;
    init := Init;
  END; (* object *)

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (v: V; ax: Axis.T; &lt;* UNUSED *&gt; n: CARDINAL):
  VBT.SizeRange =
  BEGIN
    WITH p = MAX(10, Pts.ToScreenPixels(v, v.prefDimPts[ax], ax)) DO
      RETURN VBT.SizeRange{0, p, MAX(VBT.DefaultShape.hi, p + 1)}
    END;
  END Shape;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v                    : V;
                size                 : CARDINAL;
                widthPts, heightPts  : REAL;
                font                 : Font.T     := Font.BuiltIn;
                prefWidth, prefHeight             := 0.0           ): V =
  VAR elems := NEW(Elems, size);
  BEGIN
    EVAL MG.V.init(v);
    FOR i := 0 TO size - 1 DO
      elems[i] :=
        NEW(Elem, id := i, i := i, font := font, weight := 0.0).init(
          corner1 := R2.T{FLOAT(i) * widthPts, 0.0},
          corner2 := R2.T{FLOAT(i + 1) * widthPts, heightPts}, v := v);
    END;
    LOCK v.mu DO
      v.setNW(R2.T{0.0, heightPts});
      IF prefWidth = 0.0 THEN prefWidth := FLOAT(size) * widthPts END;
      IF prefHeight = 0.0 THEN prefHeight := heightPts END;
      v.prefDimPts[Axis.T.Hor] := prefWidth;
      v.prefDimPts[Axis.T.Ver] := prefHeight;
      v.elems := elems;
    END;
    RETURN v;
  END Init;

PROCEDURE <A NAME="SetColor"><procedure>SetColor</procedure></A>(v: V; elem: CARDINAL; color: PaintOp.ColorScheme) =
  BEGIN
    LOCK v.mu DO
      v.elems[elem].setColor(v, color);
    END;
  END SetColor;

PROCEDURE <A NAME="SetFont"><procedure>SetFont</procedure></A>(v: V; elem: CARDINAL; font: Font.T) =
  BEGIN
    LOCK v.mu DO
      v.elems[elem].setFont(v, font);
    END;
  END SetFont;

PROCEDURE <A NAME="SetValue"><procedure>SetValue</procedure></A> (v: V; elem: CARDINAL; i: INTEGER) =
  BEGIN
    LOCK v.mu DO
      v.elems[elem].i := i;
      v.elems[elem].setLabel(v, Fmt.Int(i));
    END;
  END SetValue;

PROCEDURE <A NAME="ClearValue"><procedure>ClearValue</procedure></A>(v: V; elem: CARDINAL) =
  BEGIN
    LOCK v.mu DO
      v.elems[elem].setColor(v, PaintOp.bgFg);
      v.elems[elem].setLabel(v, &quot;&quot;);
    END;
  END ClearValue;

BEGIN
END IntArrayView.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
