<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/LinearArray.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/LinearArray.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P><PRE>&lt;*PRAGMA LL*&gt;
</PRE> Lists, Queues, Stacks and Buffers.  Lumped together because they are all
   linear displays of things.


<P><PRE>INTERFACE <interface><A HREF="LinearArray.m3">LinearArray</A></interface>;

IMPORT
  <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../mg/src/MG.i3">MG</A>, <A HREF="../../mg/src/MGV.i3">MGV</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>;

TYPE
  <A HREF="LinearArray.m3#T">T</A> &lt;: TPublic;
  TPublic = MG.Group OBJECT
              &lt;* LL = v.mu *&gt;
              graphic        : MG.T;
              next, prev            : T;
              linkToNext, linkToPrev: LinkerRec;
            METHODS
              &lt;* LL &lt; v.mu *&gt;
              init (v: V; graphic: MG.T): T;
              (* displays self using &quot;graphic&quot;, sets the linker to the
                 default linker (if it is NIL), centers the graphic around
                 the origin, sets Pos(self) to the origin, and sets
                 visibility to 0.0 (invisible). *)

              &lt;* LL = v.mu *&gt;
              setNextPrev(v: V; np: NP; t: T);
              setNextPrevLink(v: V; np: NP; READONLY link: LinkerRec);
            END;

TYPE
  NP = {Next, Prev, Label};
  HT = {Head, Tail};

TYPE
  <A HREF="LinearArray.m3#V">V</A> &lt;: VPublic;
  VPublic =
    MGV.V OBJECT
      &lt;* LL = self.mu *&gt;
      dx, dy := 5.0;
      (* separation distance between elements *)

      axis := Axis.T.Hor;
      (* axis of elements *)

      alignment := Alignment.AboveLeft;
      (* side of elements to locate elements that are &quot;align&quot;ed. *)

      linker: Linker := NIL;
      (* self.linker.new(from, to) returns a graphical element that acts as
         a link connecting &quot;from&quot; and &quot;t&quot;.  The link ends should be
         individually controllable so &quot;from&quot; and &quot;to&quot; can move separately.

         If linker = NIL, linkerDefault is used and returns a MG.Line with
         MG.LineEnds at &quot;from&quot; and &quot;to&quot;.  The visibility of &quot;to&quot; controls
         the visibility of the default link. *)

      (* internal state fields *)
      head, tail          : T := NIL;
      headLabel, tailLabel: T := NIL;
      labelLinks             := FALSE;

      aligned: T := NIL;
      (* list of aligned elements, so they are displayed *)

      cntElems := 0;
      (* count of elements in the linear array, maintained by insert and
         delete *)

      width, height: REAL;
      (* size of elements *)

    METHODS
      &lt;* LL &lt; self.mu *&gt;
      init (width, height: REAL): V;
      (* dimensions of a box or label in the linear array *)

      &lt;* LL = self.mu *&gt;
      setLabel (ht: HT; graphic: MG.T);
      (* show &quot;graphic&quot; at the head/tail of the &quot;list&quot;, include a link
         &quot;self.labelLinks&quot; is TRUE *)

      clear ();
      (* reset to have no elements *)

      align (t, dest: T);
      (* Creates and animation moving &quot;t&quot; to be aligned with &quot;dest&quot;. *)

      insert (t, prev: T);
      (* Creates and animation to insert &quot;t&quot; after &quot;prev&quot;.  If &quot;prev&quot; = NIL
         then insert as new head.  Handles next, prev, and links.  Updates
         head and tail as necessary *)

      delete (t: T);
      (* Creates and animation to delete &quot;t&quot; from &quot;self&quot;'s list.  Handles
         next, prev, and links.  Updates head and tail as necessary *)
    END;
</PRE><BLOCKQUOTE><EM> A vbt displaying a linear array of elements. </EM></BLOCKQUOTE><PRE>

&lt;* LL &lt; v.mu *&gt;
PROCEDURE <A HREF="LinearArray.m3#Align">Align</A> (v: V; t, dest: T);
PROCEDURE <A HREF="LinearArray.m3#Clear">Clear</A> (v: V);
PROCEDURE <A HREF="LinearArray.m3#Delete">Delete</A> (v: V; t: T);
PROCEDURE <A HREF="LinearArray.m3#Insert">Insert</A> (v: V; t, prev: T);
PROCEDURE <A HREF="LinearArray.m3#Link">Link</A> (v: V; from, to: T);
</PRE><BLOCKQUOTE><EM> The three above procedures handle locking, new shapes, animation, and
   redisplay for calls of the align, insert and delete methods </EM></BLOCKQUOTE><PRE>

TYPE
  Alignment = {None, AboveLeft, AboveRight, BelowLeft, BelowRight};
  (*| Position of &quot;align&quot;ed elements relative to the destination
      element.  Head/Tail pointers (if any) are aligned on the opposite
      side (or &quot;BelowRight&quot; is used if &quot;None&quot; was specified) *)

TYPE
  LinkerRec = RECORD from, to: MG.T; fromT, toT: T END;
  Linker =
    OBJECT METHODS new (v: V; from, to: T; type: NP): LinkerRec END;
</PRE><BLOCKQUOTE><EM> v.linker.new returns a pair of MG.T elements controlling a graphical
   link between <CODE>from</CODE> and <CODE>to</CODE>.   If either <CODE>from</CODE> or <CODE>to</CODE> is NIL
   then a <CODE>very short</CODE> link should be produced with both ends
   controlled by the non-NIL end.  <CODE>type</CODE> maybe be used to distinguish
   next, prev and label links.  </EM></BLOCKQUOTE><PRE>

VAR linkerDefault: Linker;
</PRE><BLOCKQUOTE><EM> If v.linker = NIL, linkerDefault is used and returns a MG.Line
   with MG.LineEnds at <CODE>from</CODE> and <CODE>to</CODE>.  The visibility of <CODE>to</CODE>
   controls the visibility of the default link. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="LinearArray.m3#List">List</A> &lt;: V;

TYPE
  <A HREF="LinearArray.m3#DoublyLinkedList">DoublyLinkedList</A> &lt;: DoublyLinkedListPublic;
  DoublyLinkedListPublic = List OBJECT
    nextLinkColor, prevLinkColor: PaintOp.ColorScheme;
  END;
  (* Like a List except that linkToPrev is maintained and displayed *)

TYPE
  QSB = V OBJECT
       METHODS
         &lt;* LL = self.mu *&gt;
         push (t: T);
         pop  (): T;
       END;

  <A HREF="LinearArray.m3#Queue">Queue</A> &lt;: QSB;
  (* A FIFO - self.push pushes at the tail and self.pop pops from the head *)

  <A HREF="LinearArray.m3#Stack">Stack</A> &lt;: QSB;
  (* A LIFO - self.push pushes at the head and self.pop pops from the head *)

TYPE
  <A HREF="LinearArray.m3#Buffer">Buffer</A> &lt;: BufferPublic;
  BufferPublic =
    QSB OBJECT
      &lt;* LL = self.mu *&gt;
      pushSide, popSide: HT;
      (* pushSide = HT.Tail, popSide = HT.Head =&gt; Queue behavior pushSide =
         HT.Tail, popSide = HT.Tail =&gt; Stack behavior *)

      slots               : REF ARRAY OF MG.T := NIL;
      headIndex, tailIndex: INTEGER           := 0;

      emptyColor: PaintOp.ColorScheme := NIL;
      (* emptyColor rectangle will fill empty slots in the buffer.  if no
         color is given, then the empty slots will be invisible *)
    METHODS
      &lt;* LL &lt; self.mu *&gt;
      init (width, height: REAL; size: CARDINAL; pushSide, popSide: HT):
            Buffer;

      &lt;* LL = self.mu *&gt;
      grow (newSize: CARDINAL);
    END;

&lt;* LL &lt; v.mu *&gt;
PROCEDURE <A HREF="LinearArray.m3#Push">Push</A> (v: QSB; t: T);
PROCEDURE <A HREF="LinearArray.m3#Pop">Pop</A> (v: QSB);

PROCEDURE <A HREF="LinearArray.m3#GrowBuffer">GrowBuffer</A>(v: Buffer; newSize: INTEGER);

END LinearArray.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
