<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/MGRd.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/MGRd.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Stephen Harrison                                    

<P><PRE>MODULE <module><implements><A HREF="MGRd.i3">MGRd</A></implements></module>;

IMPORT <A HREF="../../mtext/src/MText.i3">MText</A>, <A HREF="../../mtext/src/MTextRd.i3">MTextRd</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/RdClass.i3">RdClass</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>,
       <A HREF="../../etext/src/TextPort.i3">TextPort</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../vtext/src/VTDef.i3">VTDef</A>, <A HREF="../../vtext/src/VText.i3">VText</A>;

REVEAL
  <A NAME="T">T</A> = Rd.T BRANDED OBJECT
        rd                   : MTextRd.T;
        past, present, future: VText.Interval;
        vbt: VBT.T;
      OVERRIDES
        seek   := Seek;
        length := Length;
        close  := Close;
      END;

PROCEDURE <A NAME="FromTextPort"><procedure>FromTextPort</procedure></A> (         tp     : TextPort.T;
                        READONLY present: Style;
                        READONLY past                  := PastStyle;
                        READONLY future                := FutureStyle): T =
  VAR
    mtext   : MText.T;
    vbt     : VBT.T;
    rect    : Rect.T;
    vOptions: VText.VOptions;
    t       : T;
    pastIO := VText.MakeIntervalOptions(
                style := past.intervalStyle,
                whiteBlack :=
                  PaintOp.MakeColorScheme(past.bg, past.fg),
                whiteStroke :=
                  PaintOp.MakeColorScheme(past.bg, past.fg),
                leading := past.bg);
    presentIO := VText.MakeIntervalOptions(
                   style := present.intervalStyle,
                   whiteBlack :=
                     PaintOp.MakeColorScheme(present.bg, present.fg),
                   whiteStroke :=
                     PaintOp.MakeColorScheme(present.bg, present.fg),
                   leading := present.bg);
    futureIO := VText.MakeIntervalOptions(
                  style := future.intervalStyle,
                  whiteBlack :=
                    PaintOp.MakeColorScheme(future.bg, future.fg),
                  whiteStroke :=
                    PaintOp.MakeColorScheme(future.bg, future.fg),
                  leading := future.bg);
    port := TextPort.GetVText(tp);
  &lt;* FATAL VTDef.Error, Rd.Failure, Thread.Alerted *&gt;
  BEGIN
    VText.ExplodeVText(port, mtext, vbt, rect, vOptions);
    t := NEW(T, rd := MTextRd.New(mtext));
    t.vbt := vbt;
    t.past := VText.CreateInterval(port, 0, 0, pastIO);
    VText.SwitchInterval(t.past, VText.OnOffState.On);
    t.present := VText.CreateInterval(port, 0, 1, presentIO);
    VText.SwitchInterval(t.present, VText.OnOffState.On);
    t.future := VText.CreateInterval(port, 1, LAST(INTEGER), futureIO);
    VText.SwitchInterval(t.future, VText.OnOffState.On);
    VBT.Mark(vbt);
    t.buff := NEW(REF ARRAY OF CHAR, 1);
    t.closed := t.rd.closed;
    t.seekable := TRUE;
    t.intermittent := FALSE;
    t.st := 0;
    t.cur := 0;
    t.lo := 0;
    t.hi := 0;
    RETURN t;
  END FromTextPort;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A>(t: T): INTEGER RAISES {Rd.Failure, Thread.Alerted} =
  BEGIN
    RETURN t.rd.length();
  END Length;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(t: T) RAISES {Rd.Failure, Thread.Alerted} =
  &lt;* FATAL VTDef.Error *&gt;
  BEGIN
    t.rd.close();
    t.closed := TRUE;
    VText.SwitchInterval(t.past, VText.OnOffState.Off);
    VText.SwitchInterval(t.present, VText.OnOffState.Off);
    VText.SwitchInterval(t.future, VText.OnOffState.Off);
    VText.DeleteInterval(t.past);
    VText.DeleteInterval(t.present);
    VText.DeleteInterval(t.future);
  END Close;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A> (t: T; n: CARDINAL;
            &lt;* UNUSED *&gt; dontBlock: BOOLEAN): RdClass.SeekResult
  RAISES {Rd.Failure, Thread.Alerted} =
  &lt;* FATAL VTDef.Error *&gt;
  BEGIN
    TRY
      Rd.Seek(t.rd, n);
      VText.MoveInterval(t.past, 0, n);
      VText.MoveInterval(t.present, n, n + 1);
      VText.MoveInterval(t.future, n + 1, LAST(INTEGER));
      VBT.Mark(t.vbt);
      t.cur := n;
      t.lo := n;
      t.hi := n + 1;
      t.buff[0] := Rd.GetChar(t.rd);
    EXCEPT
      Rd.EndOfFile =&gt; RETURN RdClass.SeekResult.Eof
    END;
    RETURN RdClass.SeekResult.Ready;
  END Seek;

BEGIN
END MGRd.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
