<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/PaintOpAnim.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/PaintOpAnim.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="PaintOpAnim.i3">PaintOpAnim</A></implements></module>;

IMPORT <A HREF="../../mg/src/Animate.i3">Animate</A> AS MGAnimate, <A HREF="GraphVBT.i3">GraphVBT</A>, <A HREF="GraphVBTExtras.i3">GraphVBTExtras</A>, <A HREF="../../mg/src/MG.i3">MG</A>, <A HREF="../../mg/src/MGPaintOp.i3">MGPaintOp</A>, <A HREF="../../mg/src/MGV.i3">MGV</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = PublicT BRANDED OBJECT
        pntop: PaintOp.T;
      OVERRIDES
        init    := Init;
        set     := Set;
        get     := Get;
        op      := Op;
        animate := Animate;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T; rgb: RGB): T =
  BEGIN
    t.pntop := MGPaintOp.New(rgb);
    RETURN t;
  END Init;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (t: T; graph: GraphVBT.T; rgb: RGB) =
  BEGIN
    MGPaintOp.Set(VBT.ScreenTypeOf(graph), t.pntop, rgb);
  END Set;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (t: T): RGB =
  BEGIN
    RETURN MGPaintOp.Get(t.pntop);
  END Get;

PROCEDURE <A NAME="Op"><procedure>Op</procedure></A> (t: T): PaintOp.T =
  BEGIN
    RETURN t.pntop
  END Op;

TYPE
  MyAnimation = MGAnimate.T OBJECT
                  t    : T;
                  graph: GraphVBT.T;
                  anim : Animation;
                OVERRIDES
                  length := Length;
                  doStep := DoStep;
                END;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A> (&lt;* UNUSED *&gt; t : MyAnimation;
                  &lt;* UNUSED *&gt; v : MG.V;
                  &lt;* UNUSED *&gt; mg: MG.T         ): INTEGER =
  BEGIN
    RETURN 30;
  END Length;

PROCEDURE <A NAME="DoStep"><procedure>DoStep</procedure></A> (             self    : MyAnimation;
                               time    : REAL;
                  &lt;* UNUSED *&gt; timePrev: REAL;
                  &lt;* UNUSED *&gt; v       : MG.V;
                  &lt;* UNUSED *&gt; mg      : MG.T         ) =
  BEGIN
    self.t.set(self.graph, self.anim.rgb(time));
  END DoStep;

PROCEDURE <A NAME="Animate"><procedure>Animate</procedure></A> (t: T; graph: GraphVBT.T; animation: Animation) =
  BEGIN
    MGV.AddAnimationLocked(
      GraphVBTExtras.GetMG(graph),
      NEW(MyAnimation, t := t, graph := graph, anim := animation).init(), NIL);
  END Animate;

BEGIN
END PaintOpAnim.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
