<HTML>
<HEAD>
<TITLE>SRC Modula-3: mgkit/src/RectsVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mgkit/src/RectsVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

&lt;* PRAGMA LL *&gt;
</PRE> A RectsVBT continuously displays a collection of rectangles.
   Each rectangle is defined by a location in world coordinates,
   a color, and flag indicating whether it exists.  Only those
   rectangles that exist are displayed.
<P>
   The client specifies N, how many rectangle there will be, and
   then accesses the items using a number [0..N].  The 0th item
   is typically used for temporary drawing, or for highlighting.
   When the RectsVBT is refreshed, the items are painted from 1
   to N, and then 0.  Obviously, only items for which information
   has been defined are ever painted.
<P>
   The rectangles are always displayed with the client's world
   coordinate system mapped to the entire VBT domain, optionally
   with a margin of some number of points.
<P>
   A <CODE>RectsVBT</CODE> in internally syncrhonized; it can safely be called 
   from mulitple threads. Each procedure has <CODE>LL.sup &lt; rects</CODE>.
   In addition, <CODE>VBT.mu &lt; rects</CODE> for any <CODE>rects: RectsVBT.T</CODE>. 

<P><PRE>INTERFACE <interface><A HREF="RectsVBT.m3">RectsVBT</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="RectsVBT.m3#T">T</A> &lt;: Public;
  Public = VBT.Leaf OBJECT METHODS init (): T; END;
</PRE><P>
**
** Global Parameters
**


<P><PRE>PROCEDURE <A HREF="RectsVBT.m3#SetBg">SetBg</A> (v: T; op: PaintOp.T);
</PRE><BLOCKQUOTE><EM> Use <CODE>op</CODE> for the background, and mark <CODE>v</CODE> for redisplay.  The
   default value is PaintOp.Bg. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#SetMargin">SetMargin</A> (v: T; west, south, east, north: REAL);
</PRE><BLOCKQUOTE><EM> Rather than using all of <CODE>v</CODE>'s domain to map world
   coordinates, inset the domain by this many points on each
   side.  The default margin is 2.0 on all sides.  Mark <CODE>v</CODE> for
   redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#SetWC">SetWC</A> (v: T; west, south, east, north: REAL);
</PRE><BLOCKQUOTE><EM> Set the window in world coordinates for drawing and mark <CODE>v</CODE>
   for redisplay.  The default is (0,0,1,1). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#SetMins">SetMins</A> (v: T; wd, ht: REAL);
</PRE><BLOCKQUOTE><EM> Set the smallest size, in points, that each visible rectangle
   is allowed to be, and mark <CODE>v</CODE> for redisplay.  The default
   value is 4.0 in both dimensions. </EM></BLOCKQUOTE><PRE>
</PRE><P>
**
** Painting
**


<P><PRE>PROCEDURE <A HREF="RectsVBT.m3#Draw">Draw</A> (v: T; i: CARDINAL);
</PRE><BLOCKQUOTE><EM> Draw the ith rectangle. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#Erase">Erase</A> (v: T; i: CARDINAL);
</PRE><BLOCKQUOTE><EM> Erase the ith rectangle by redrawing the rectangle using the
   background color.  There is no concept of refreshing what was
   underneath the rectangle.  It's the responsibility of the
   caller to redraw whatever is necessary. </EM></BLOCKQUOTE><PRE>
</PRE><P>
**
** Creating and deleting
**


<P><PRE>PROCEDURE <A HREF="RectsVBT.m3#SetN">SetN</A> (v: T; N: CARDINAL; redisplayFg: BOOLEAN := FALSE);
</PRE><BLOCKQUOTE><EM> Create a new set of [0..N] items, after deleting the current
   set.  If <CODE>redisplayFg</CODE> is TRUE, then erase each rectangle
   before deleting it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#Exists">Exists</A> (v: T; i: CARDINAL): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Does the ith rectangle exits?  A rectangle is considered to
   ``existing'' as soon as one of its attributes (i.e., color or
   position) is defined; it no longer exists when Delete </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#Delete">Delete</A> (v          : T;
                  i          : CARDINAL;
                  redisplayFg: BOOLEAN    := FALSE);
</PRE><BLOCKQUOTE><EM> Record the ith rectangle as no longer existing.  If
   redisplayFg is TRUE, then erase the item before deleting
   it. </EM></BLOCKQUOTE><PRE>
</PRE><P>
**
** Attributes
**


<P><PRE>PROCEDURE <A HREF="RectsVBT.m3#Position">Position</A> (v                       : T;
                    i                       : CARDINAL;
                    west, south, east, north: REAL;
                    redisplayFg             : BOOLEAN    := FALSE);
</PRE><BLOCKQUOTE><EM> Set the position in world coordinates of the ith rectangle.
   If redisplayFg is TRUE, then erase the item (at its old
   position) and draw it in its new location. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#Color">Color</A> (v          : T;
                 i          : CARDINAL;
                 op         : PaintOp.T;
                 redisplayFg: BOOLEAN     := FALSE);
</PRE><BLOCKQUOTE><EM> Set the color of the <CODE>i</CODE>th rectangle.  If redisplayFg is TRUE,
   then draw the rectangle in its new color. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#GetColor">GetColor</A> (v          : T;
                    i          : CARDINAL): PaintOp.T;
</PRE><BLOCKQUOTE><EM> Get the color of the <CODE>i</CODE>th rectangle. A checked run-time
   error if the <CODE>i</CODE>th rectangle hasn't been defined yet. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#Locate">Locate</A> (v: T; i: CARDINAL): Rect.T;
</PRE><BLOCKQUOTE><EM> Return the screen coordinates where the <CODE>i</CODE>th rectangle is
   being displayed.  Return Rect.Empty if the <CODE>i</CODE>th rectangle
   hasn't been defined yet. </EM></BLOCKQUOTE><PRE>
</PRE><P>
**
** Coordinate transformations
**


<P><PRE>TYPE
  RealPoint = RECORD h, v: REAL END;
  RealRect = RECORD north, south, west, east: REAL END;

PROCEDURE <A HREF="RectsVBT.m3#VBT2WC">VBT2WC</A> (v: T; pt: Point.T): RealPoint;
</PRE><BLOCKQUOTE><EM> Translate <CODE>pt</CODE> from screen coordinates to world coordinate. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RectsVBT.m3#WC2VBT">WC2VBT</A> (v: T; pt: RealPoint): Point.T;
</PRE><BLOCKQUOTE><EM> Translate <CODE>pt</CODE> from world coordinates to screen coordinate. </EM></BLOCKQUOTE><PRE>

END RectsVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
