<HTML>
<HEAD>
<TITLE>SRC Modula-3: mtext/src/MText.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mtext/src/MText.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="MText.m3">MText</A></interface>;
</PRE> An <CODE>MText</CODE> is a mutable sequence of characters whose internal
   representation is a balanced binary tree.  An <CODE>MText</CODE> is
   an appropriate abstraction for use in implementing a text
   editor, and perhaps other applications that perform lots of
   text modifications.  More documentation is at the end of this
   interface.
<P>
   <CODE>MText</CODE> is related to text and readers.  You should consult
   <CODE>Text.i3</CODE> and <CODE>Rd.i3</CODE> for information on these abstractions.
<P>
   This interface is monitored.  Readers are also synchronized
   with updates to the <CODE>MText</CODE> so that a reader fails when it tries
   to refill its buffer and discovers that the <CODE>MText</CODE> has been
   changed.
<P>
   If a procedure raises an exception, the mtext is left in an
   undefined state.  However, the client should be able to call
   <CODE>Close</CODE> on it.
<P>
   <CODE>MText</CODE> procedures use the ``begin/end/length'' semantics
   defined by the <CODE>Text</CODE> interface: if <CODE>begin</CODE> or <CODE>begin +
   length</CODE> or <CODE>end</CODE> exceed <CODE>Length(m)</CODE>, then <CODE>Length(m)</CODE> will
   be used.  (A previous implementation raised checked runtime
   errors in such cases.)
   <P>
 

<P><PRE>IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>;

TYPE
  T &lt;: REFANY;
  Index = CARDINAL;             (* obsolete, but keep for
                                   compatibility *)
</PRE> \subsection {Creating MTexts} 

<P><PRE>PROCEDURE <A HREF="MText.m3#New">New</A> (t := &quot;&quot;; bufMax: CARDINAL := 256): T;
</PRE><BLOCKQUOTE><EM> Returns a new <CODE>MText</CODE> containing the characters of <CODE>t</CODE>.
   <CODE>bufMax</CODE> specifies the size of the mutable buffer used by
   <CODE>Replace</CODE> when it cannot perform editing within the buffer.
   The buffer is useful both during straight typing by a user and
   during insertions by a program (as in a typescript). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MText.m3#ChangeBufMax">ChangeBufMax</A> (m: T; bufMax: CARDINAL);

PROCEDURE <A HREF="MText.m3#Close">Close</A> (m: T);
</PRE><BLOCKQUOTE><EM> <P>
<PRE>
      = MText.Replace(m, 0, MText.Length(m), &quot;&quot;)
</EM></BLOCKQUOTE><PRE>
</PRE> \subsection {Examining MTexts and Extracting Characters} 

<P> Note that readers on MText are available (see the <CODE>MTextRd</CODE>
   interface).  It is often more appropriate to create a reader
   than to create a text. 

<P><PRE>PROCEDURE <A HREF="MText.m3#Length">Length</A> (m: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Returns the number of characters in <CODE>m</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MText.m3#GetChar">GetChar</A> (m: T; index: CARDINAL): CHAR;
</PRE><BLOCKQUOTE><EM> Returns the character at <CODE>index</CODE> in the text.  A checked error
   if <CODE>index &gt;= Length(m)</CODE>.  Warning: this is an expensive
   operation.  If it is going to be done several times, it would
   be better to use an <CODE>MTextRd.T</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MText.m3#GetText">GetText</A> (m    : T;
                   begin: CARDINAL := 0;
                   end  : CARDINAL := LAST (CARDINAL)): TEXT;
</PRE><BLOCKQUOTE><EM> Returns a sub-sequence of <CODE>m</CODE>.  The result will be empty if
   <CODE>begin &gt;= Length(m)</CODE>; otherwise the range of indexes of the
   subsequence is <CODE>[begin ..  MIN (end, Length (m)) -1]</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection {Modifying MTexts} 

<P> See ``Efficiency considerations'' below for a discussion of
   the performance implications of the various ways of modifying
   mtexts.  To delete characters from an mtext, use <CODE>Replace</CODE>
   with an empty string as the value of <CODE>newtext</CODE>.  To insert
   characters, use any of the procedures below with <CODE>begin =
   end</CODE>. 

<P><PRE>PROCEDURE <A HREF="MText.m3#Replace">Replace</A> (m: T; begin, end: CARDINAL; newtext: TEXT);
</PRE><BLOCKQUOTE><EM> Delete characters in the range <CODE>[begin .. end-1]</CODE>, and insert the
   characters of <CODE>newtext</CODE> at <CODE>begin</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MText.m3#ReplaceChars">ReplaceChars</A> (m: T; begin, end: CARDINAL; READONLY str: ARRAY OF CHAR);
</PRE><BLOCKQUOTE><EM> <CODE> = Replace (m, begin, end, Text.FromChars (str))</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MText.m3#ReplaceFile">ReplaceFile</A> (m         : T;
                       begin, end: CARDINAL;
                       rd        : Rd.T;
                       start     : CARDINAL   := 0;
                       numChars  : CARDINAL   := LAST (CARDINAL));
</PRE><BLOCKQUOTE><EM> Delete characters in the range <CODE>[begin ..  end-1]</CODE>, then
   insert the characters <CODE>[start ..  start+numChars-1]</CODE> from <CODE>rd</CODE>
   at <CODE>begin</CODE>.
<P>
   While this procedure is intended to be used primarily for
   file-readers, any seekable, non-intermittent reader is
   acceptable.
<P>
   Characters from <CODE>rd</CODE> are read only as needed, not necessarily
   at the time <CODE>ReplaceFile</CODE> is called.  The client should
   therefore not call <CODE>Rd.Close(rd)</CODE> or make any changes to the
   underlying text. </EM></BLOCKQUOTE><PRE>

END MText.
</PRE> Introduction to Mutable Text (MText)
<P>
   A Mutable Text or MText is a REF representing a mutable
   sequence of characters.  The characters of an MText are
   indexed starting from 0, like those of a Text.  MText is an
   appropriate abstraction for use in implementing a text editor,
   and perhaps other applications that perform lots of text
   modifications.
<P>
   MText is well integrated with the more basic Text abstraction.
   It is easy to create an MText from a Text, and to extract
   Texts from an MText.  It is also easy to create an MText from
   a file.  The performance of these operations is generally
   good.
<P>
   Efficiency considerations
<P>
   The implementation of MText is a 'piece table'.  A piece table
   is (logically) a linear list of pieces, where each piece is
   some representation of a character sequence.  The piece table
   represents the concatenation of the character sequences.
<P>
   MText supports three types of pieces: subsequence of
   characters in an immutable Text, subsequence of characters in
   a reader (e.g., a readonly file), and a mutable buffer.  The
   mutable buffer is supported to avoid creating a huge number of
   pieces when performing individual character-insertions during
   typein.
<P>
   The number of pieces in an MText may increase linearly with
   the number of editing operations applied to it.  So MText uses
   a balanced binary tree to represent the list of pieces.  This
   means that reading and editing the MText can still be quite
   fast when the number of pieces is large.  The time to perform
   GetText(mtext,begin,end) is proportional to (log n + r) where
   n is the number of pieces in the MText and r is the number of
   pieces contributing characters to the result.  The fact that
   this is linear in r is not wonderful.  &lt;&lt;Eventually we should
   give the constant factors.&gt;&gt;
<P>
   When a reader is used as a text source, the MText
   implementation reads characters into virtual memory only when
   those characters are referenced.  This means that creating an
   MText from a reader takes constant time; it also means that if
   the reader's target is changed while the MText still includes
   the reader, the contents of the MText become undefined. 

<P>
<P>
<P>
<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
