<HTML>
<HEAD>
<TITLE>SRC Modula-3: mtext/src/MTextDebug.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mtext/src/MTextDebug.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="MTextDebug.i3">MTextDebug</A></implements></module>;

IMPORT <A HREF="MTextPrivate.i3">MTextPrivate</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;
FROM <A HREF="MText.i3">MText</A> IMPORT T;
FROM <A HREF="MTextPrivate.i3">MTextPrivate</A> IMPORT Node, NodeType;
FROM <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A> IMPORT stderr;

&lt;* FATAL Thread.Alerted, Wr.Failure, Rd.Failure *&gt;
</PRE>*******************************************************************
                       For Debugging Only                          
*******************************************************************

<P> A generator for node i.d. numbers. These exist only to make structural
   printouts more readable, and are assigned only when the nodes are
   printed. 
   
<P><PRE>VAR idCounter: CARDINAL := 0;

PROCEDURE <A NAME="Id"><procedure>Id</procedure></A> (node: T): CARDINAL RAISES {} =
  BEGIN
    IF node.id = 0 THEN INC(idCounter); node.id := idCounter END;
    RETURN node.id
  END Id;
</PRE> Dump gives a structural printout of everything interesting about an
   MText: size, files held open, tree structure, list of heads. 

<P><PRE>PROCEDURE <A NAME="Dump"><procedure>Dump</procedure></A> (m: T) =
  VAR
    index: CARDINAL;
    wr            := stderr;
  PROCEDURE Space (n: INTEGER) =
    BEGIN
      FOR i := 1 TO n DO Wr.PutChar(wr, ' ') END
    END Space;
  PROCEDURE DumpTree (node: Node; indent: INTEGER) =
    BEGIN
      CASE node.type OF
        NodeType.tree =&gt;
          DumpTree(node.left, indent + 2);
          Space(indent);
          Wr.PutText(wr, &quot;[n&quot; &amp; Fmt.Int(Id (node)) &amp; &quot; len=&quot;
                           &amp; Fmt.Int(node.length) &amp; &quot;]\n&quot;);
          IF (node.right.type = NodeType.tree) AND (node.right.sub) THEN
            DumpTree(node.right.left, indent + 2);
            Space(indent + 1);
            Wr.PutText(wr, &quot;[+&quot; &amp; Fmt.Int(Id (node.right)) &amp; &quot; len=&quot;
                             &amp; Fmt.Int(node.right.length) &amp; &quot;]\n&quot;);
            DumpTree(node.right.right, indent + 2)
          ELSE
            DumpTree(node.right, indent + 2)
          END
      | NodeType.anchor =&gt;
          Space(indent);
          Wr.PutText(
            wr, &quot;[a&quot; &amp; Fmt.Int(Id (node)) &amp; &quot; len=&quot; &amp; Fmt.Int(node.length)
                  &amp; &quot; index=&quot; &amp; Fmt.Int(index) &amp; &quot;]\n&quot;)
      | NodeType.text =&gt;
          Space(indent);
          Wr.PutText(
            wr, &quot;[t&quot; &amp; Fmt.Int(Id (node)) &amp; &quot; len=&quot; &amp; Fmt.Int(node.length)
                  &amp; &quot; index=&quot; &amp; Fmt.Int(index) &amp; &quot;]&lt;&quot;);
          IF node.length &lt; 20 THEN
            Wr.PutText(wr, node.text &amp; &quot;&gt;\n&quot;)
          ELSE
            Wr.PutText(wr, Text.Sub(node.text, 0, 20) &amp; &quot;...&gt;\n&quot;)
          END;
          INC(index, node.length)
      | NodeType.buf =&gt;
          Space(indent);
          Wr.PutText(
            wr, &quot;[b&quot; &amp; Fmt.Int(Id (node)) &amp; &quot; len=&quot; &amp; Fmt.Int(node.length)
                  &amp; &quot; index=&quot; &amp; Fmt.Int(index) &amp; &quot;]&lt;&quot;);
          IF node.length &lt; 20 THEN
            Wr.PutString(wr, SUBARRAY(node.buffer^, 0, node.length));
            Wr.PutText(wr, &quot;&gt;\n&quot;)
          ELSE
            Wr.PutString(wr, SUBARRAY(node.buffer^, 0, 20));
            Wr.PutText(wr, &quot;...&gt;\n&quot;)
          END;
          INC(index, node.length)
      | NodeType.file =&gt;
          Space(indent);
          Wr.PutText(
            wr, &quot;[f&quot; &amp; Fmt.Int(Id (node)) &amp; &quot;,start=&quot; &amp; Fmt.Int(node.start)
                  &amp; &quot; len=&quot; &amp; Fmt.Int(node.length) &amp; &quot; index=&quot;
                  &amp; Fmt.Int(index) &amp; &quot;]&lt;&quot;);
          Rd.Seek(node.file, node.start);
          IF node.length &lt; 20 THEN
            Wr.PutText(wr, Rd.GetText(node.file, node.length) &amp; &quot;&gt;\n&quot;)
          ELSE
            Wr.PutText(wr, Rd.GetText(node.file, 20) &amp; &quot;...&gt;\n&quot;)
          END;
          INC(index, node.length)
      ELSE &lt;* ASSERT FALSE *&gt;
      END
    END DumpTree;
  BEGIN
    LOCK m.lock DO
      Wr.PutText(wr, &quot;mtext of length &quot; &amp; Fmt.Int(m.length) &amp; &quot;, height &quot;
                       &amp; Fmt.Int(m.height) &amp; &quot;, root [&quot;
                       &amp; Fmt.Int(Id (m.root)) &amp; &quot;]\n&quot;);
      index := 0;
      DumpTree(m.root, 0);
      Wr.PutText(wr, &quot;\n&quot;);
      Wr.Flush(wr)
    END
  END Dump;
</PRE> Verify verifies all the properties which I assert to be true of a
   consistent mutable text tree or subtree: It contains no NIL Node
   pointers except top.up.
<PRE>
        For every interior node,
         node.left.up = node
         node.right.up = node
         node.length = node.left.length + node.right.length
         node.leftSize = node.left.length NOT node.left.sub
       If node.sub then node.right.sub = FALSE (2-3 tree condition)
       For the top node,
             top.up = NIL
             top.root # NIL
             top.root.up = top
             top.length = top.root.length - 1
             top.root.sub = FALSE
             top.height = height of the tree at top.root
       For each head on the top.heads list,
             top.root is an ancestor of head.node
             0 &lt;= head.index &lt;= head.node.length
             head.index = head.node.length only if
                 head.node is the final anchor node 


<P>
<P><PRE>EXCEPTION VerifyError;

PROCEDURE <A NAME="Verify"><procedure>Verify</procedure></A> (wr: Wr.T; node: Node; msg: TEXT) =
  &lt;* FATAL VerifyError *&gt;
  VAR
    height: INTEGER;
    root:   Node;
  PROCEDURE Err (err: TEXT) =
    BEGIN
      Wr.PutText(
        wr, &quot;Verify of &quot; &amp; msg &amp; &quot;: &quot; &amp; err &amp; &quot; in [&quot; &amp; Fmt.Int(Id (node))
              &amp; &quot;] at height &quot; &amp; Fmt.Int(height) &amp; &quot;\n&quot;);
      Wr.Flush(wr);
      RAISE VerifyError
    END Err;
  PROCEDURE ErrN (err1: TEXT; n: INTEGER; err2: TEXT) =
    BEGIN
      Wr.PutText(
        wr, &quot;Verify of &quot; &amp; msg &amp; &quot;: &quot; &amp; err1 &amp; Fmt.Int(n) &amp; err2 &amp; &quot; in [&quot;
              &amp; Fmt.Int(Id (node)) &amp; &quot;] at height &quot; &amp; Fmt.Int(height) &amp; &quot;\n&quot;);
      Wr.Flush(wr);
      RAISE VerifyError
    END ErrN;
  BEGIN
    height := -1;               (* used before height is computed *)
    IF node.type = NodeType.top THEN
      IF node.up # NIL THEN Err(&quot;top.up # NIL&quot;) END;
      root := node.root;
      IF root = NIL THEN Err(&quot;root is NIL&quot;) END;
      IF root.up # node THEN Err(&quot;inconsistent uplink to top&quot;) END;
      IF node.length # root.length - 1 THEN
        ErrN(&quot;root length &quot;, root.length, &quot; is wrong&quot;)
      END;
      IF (root.type = NodeType.tree) AND (root.sub) THEN
        Err(&quot;root is a sub&quot;)
      END;
      height := Height(root);
      IF node.height # height THEN Err(&quot;height is wrong&quot;) END;
      Verify(wr, root, msg);
    ELSIF node.type = NodeType.tree THEN (* regular interior node *)
      height := Height(node);
      IF (node.left = NIL) OR (node.right = NIL) THEN
        Err(&quot;node has NIL child&quot;)
      END;
      IF node.left.up # node THEN Err(&quot;inconsistent left uplink&quot;) END;
      IF node.right.up # node THEN Err(&quot;inconsistent right uplink&quot;) END;
      IF node.length # node.left.length + node.right.length THEN
        Err(&quot;length is wrong&quot;)
      END;
      IF node.leftSize # node.left.length THEN
        Err(&quot;leftSize is wrong&quot;)
      END;
      IF (node.left.type = NodeType.tree) AND (node.left.sub) THEN
        Err(&quot;sub on left&quot;)
      END;
      IF (node.sub) AND (node.right.type = NodeType.tree)
           AND (node.right.sub) THEN
        Err(&quot;double sub&quot;)
      END;
      Verify(wr, node.left, msg);
      Verify(wr, node.right, msg);
    ELSIF node.type = NodeType.text THEN
      height := 0;
      IF node.length # Text.Length(node.text) THEN
        Err(&quot;text node length is wrong&quot;)
      END;
    ELSIF node.type = NodeType.buf THEN
      root := node;
      WHILE root.type # NodeType.top DO root := root.up END;
      IF node.length &gt; root.bufMax THEN Err(&quot;buf node too long&quot;) END;
    ELSIF node.type = NodeType.anchor THEN
      IF node.length # 1 THEN Err(&quot;anchor\'s length is not 1&quot;) END
    END
  END Verify;

PROCEDURE <A NAME="Height"><procedure>Height</procedure></A> (node: Node): CARDINAL =
  VAR h: CARDINAL := 0;
  BEGIN
    WHILE node.type = NodeType.tree DO h := h + 1; node := node.left END;
    RETURN h
  END Height;

BEGIN
END MTextDebug.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
