<HTML>
<HEAD>
<TITLE>SRC Modula-3: mtext/src/MTextDs.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mtext/src/MTextDs.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created on Thu Sep 4 13:13:00 1986 by chan 

<P><PRE>INTERFACE <interface><A HREF="MTextDs.m3">MTextDs</A></interface>;

FROM <A HREF="MText.i3">MText</A> IMPORT T;
FROM <A HREF="MTextPrivate.i3">MTextPrivate</A> IMPORT Node;

PROCEDURE <A HREF="MTextDs.m3#Locate">Locate</A> (             mtext     : T;
                               index     : CARDINAL;
                  VAR (* out*) node      : Node;
                  VAR (* out*) localIndex: CARDINAL  );
</PRE><BLOCKQUOTE><EM> Given an index into the mtext, returns the relevant node and the local
   index within the node. If the index is between nodes, then the node to
   the left is chosen; i.e., localIndex = node.length. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#LocateB">LocateB</A> (             mtext     : T;
                                index     : CARDINAL;
                   VAR (* out*) node      : Node;
                   VAR (* out*) localIndex: CARDINAL  );
</PRE><BLOCKQUOTE><EM> Same as Locate except if the index is between nodes, then the node to
   the right is chosen; i.e., localIndex = 0. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#GetIndexOfNode">GetIndexOfNode</A> (node: Node; localIndex: CARDINAL): CARDINAL
 ;
</PRE><BLOCKQUOTE><EM> Returns the index with respect to the entire mtext. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#LeftNeighbor">LeftNeighbor</A> (node: Node): Node;
</PRE><BLOCKQUOTE><EM> Find the nearest leaf to the left of node, which should be a leaf.
   Returns NIL if there isn't one. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#RightNeighbor">RightNeighbor</A> (node: Node): Node;
</PRE><BLOCKQUOTE><EM> Find the nearest leaf to the right of node, which is usually but not
   always a leaf. Returns NIL if there isn't one, which shouldn't happen,
   because there's no reason to be finding the right neighbor of the anchor
   node. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#InsertAt">InsertAt</A> (node: Node; nodeIndex: CARDINAL; newnode: Node);

PROCEDURE <A HREF="MTextDs.m3#InsertBefore">InsertBefore</A> (node, newnode: Node);
</PRE><BLOCKQUOTE><EM> InsertBefore is called ONLY when InsertAfter will not work because there
   is nothing to insert the node before. It proceeds up a leftmost branch
   until it finds a node that is not leftmost; then it calls InsertAfter to
   do the rest of the job. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#InsertAfter">InsertAfter</A> (node, newnode: Node);
</PRE><BLOCKQUOTE><EM> Internal procedure. Node is part of a balanced tree; newnode is a new,
   unattached node to be inserted in the tree after node. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#Remake">Remake</A> (node, left, right: Node);
</PRE><BLOCKQUOTE><EM> Change the child links of a node. Keeps the length fields of node, and
   the uplinks of its new children, correct. WARNING: it pays no attention
   to the <CODE>sub</CODE> field. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#Delete">Delete</A> (VAR (* inout*) node: Node; b, e: CARDINAL);
</PRE><BLOCKQUOTE><EM> node may change. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#RemoveNode">RemoveNode</A> (node: Node);
</PRE><BLOCKQUOTE><EM> Removes a node (at any height) from the tree, keeping the tree balanced.
   Does not fix heads. Node must not be an ancestor of the anchor node,
   because the anchor node is never removed. The careful observer will note
   that each Remake under here abandons one interior node which is never
   cleaned out. That is all right, because all deleted leaves ARE cleaned
   out, and the abandoned node involves no cycles. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#SplitLeaf">SplitLeaf</A> (node: Node; i: CARDINAL);
</PRE><BLOCKQUOTE><EM> Break the node in two. Error if i = 0 OR i = node.length. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#ReplaceLeaf">ReplaceLeaf</A> (old, new: Node);
</PRE><BLOCKQUOTE><EM> Sometimes a leaf node must be replaced with an equivalent node of a
   different type. For example, a reader will not read a file node; it must
   be converted into a text node first. ReplaceLeaf assumes that old and
   new are both leaves and have the same length and the same content. It
   will link new into the place formerly occupied by old, and it will
   release any resources implicitly held by old. Heads which pointed into
   old will be fixed. </EM></BLOCKQUOTE><PRE>
</PRE>*********************
 Buf node operations 
*********************

<P><PRE>PROCEDURE <A HREF="MTextDs.m3#BufOpen">BufOpen</A> (node: Node; point, size: CARDINAL);
</PRE><BLOCKQUOTE><EM> Internal procedure to insert space in a buf node. We assume that caller
   will then put something reasonable into that space. Node must be a buf
   node, and node.length + size &lt;= m.bufMax. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#Free">Free</A> (node: Node);
</PRE><BLOCKQUOTE><EM> Free takes a subtree which is no longer needed and shreds it, setting
   all REFs to NIL. This makes it easy for the reference-counting garbage
   collector to clean up after us. </EM></BLOCKQUOTE><PRE>
</PRE>**********************
 File node operations 
**********************

<P><PRE>VAR FileChunkSize: CARDINAL := 8192;
  (* How much of a file node we like to read in at a time. default = 8192.
     This a variable so that it can be made smaller during debugging. *)

PROCEDURE <A HREF="MTextDs.m3#MoveBufTo">MoveBufTo</A> (               m    : T;
                     VAR (* inout*) node : Node;
                     VAR (* inout*) nodeI: CARDINAL);
</PRE><BLOCKQUOTE><EM> Places an empty buf node at &lt;node,nodeI&gt;; on return, node = bufnode AND
   nodeI = 0. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MTextDs.m3#ToText">ToText</A> (VAR (* inout*) node: Node; all: BOOLEAN := TRUE);
</PRE><BLOCKQUOTE><EM> Converts the node into a text node. If all is FALSE, at most
   FileChunkSize of a file node is converted into text. </EM></BLOCKQUOTE><PRE>
</PRE>****************************
 Extracting text from nodes 
****************************

<P>
<P><PRE>PROCEDURE <A HREF="MTextDs.m3#GetNodeText">GetNodeText</A> (VAR (* inout *) node : Node;
                                       begin: CARDINAL := 0;
                                       end  : CARDINAL := LAST (CARDINAL)):
  TEXT;
</PRE><BLOCKQUOTE><EM> node changes if node.type = file. </EM></BLOCKQUOTE><PRE>

END MTextDs.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
