<HTML>
<HEAD>
<TITLE>SRC Modula-3: mtext/src/MTextPrivate.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mtext/src/MTextPrivate.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="MText.m3">MTextPrivate</A></interface>;

IMPORT <A HREF="MText.i3">MText</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>;

REVEAL MText.<A NAME="T">T</A> = BRANDED REF NodeRec;

VAR debug: BOOLEAN := FALSE;

TYPE
  Node = MText.T;
  (* To Modula, types Node and T are equal.  However, we use T to refer only
     to a top node, for the purpose of representing the whole MText.  Node
     refers to any sort of node.  Only T is exported, and it is opaque. *)

  NodeType = {tree, text, file, buf, anchor, top};
  (*
    tree: an interior node
    text: a leaf containing a TEXT
    file: a leaf referring to part of a file
    buf: a leaf containing a typein buffer
    anchor: (bookkeeping?)
    top: the header node, one per MText *)

  NodeRec =
    RECORD
      up     : Node       := NIL; (* parent *)
      id     : INTEGER;          (* FOR DEBUGGING *)
      length : CARDINAL   := 0;  (* number of characters in this subtree *)
      lock   : MUTEX;            (* for reading and updating the mtext *)
      root   : Node;             (* root of the tree *)
      height : CARDINAL;         (* height of the tree, 1 leaf =&gt; 0 *)
      bufNode: Node;             (* handy access to the mutable buffer *)
      bufMax : CARDINAL;         (* maximum size of mutable buffer *)
      version: CARDINAL   := 0;  (* is incremented each modification. *)

      (* Nodes change their type, so subtypes aren't appropriate. *)
      type: NodeType;

      (* NodeType.tree: *)
      left, right: Node;         (* the two children *)
      leftSize   : CARDINAL;     (* number of chars in left subtree *)
      sub        : BOOLEAN;
      (* TRUE if this is a right subnode of a node in the 2-3 tree we are
         modeling. *)

      (* NodeType.text: *)
      text := &quot;&quot;;

      (* NodeType.buf: *)
      buffer: REF ARRAY OF CHAR;  (* a mutable buffer *)

      (* NodeType.file: *)
      file : Rd.T;
      start: CARDINAL;           (* where this piece starts in the file *)
    END;

PROCEDURE <A HREF="MText.m3#Check">Check</A> (VAR start, end: CARDINAL; actualLength: CARDINAL);

END MTextPrivate.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
