<HTML>
<HEAD>
<TITLE>SRC Modula-3: mtext/src/MTextRd.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mtext/src/MTextRd.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="MTextRd.m3">MTextRd</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="MText.i3">MText</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  <A HREF="MTextRd.m3#T">T</A> &lt;: Public;
  Public = Rd.T OBJECT
           METHODS
             init (m         : MText.T  := NIL;
                   start     : CARDINAL := 0;
                   rangeStart: CARDINAL := 0;
                   rangeEnd  : CARDINAL := LAST (CARDINAL);
                   reverse   : BOOLEAN  := FALSE            ): T
                   RAISES {Rd.Failure, Thread.Alerted}
           END;
</PRE> <CODE>rd.init(m, ...)</CODE> initializes a seekable, non-intermittent reader for the
   <CODE>MText m</CODE>.
<P>
   It is intended that this method be called more than once, to re-initialize
   a reader (and avoid re-allocating storage for <CODE>rd.buff</CODE>); in this case, it
   is permitted for <CODE>m</CODE> to be <CODE>NIL</CODE>, and the default value is the <CODE>MText</CODE> that
   was previously used by the reader.
<P>
   The reader's source may be a proper subsequence of the underlying <CODE>MText</CODE>,
   and the reader can be initialized to read in reverse order.
<P>
   <CODE>src(rd)</CODE> comprises the characters of <CODE>m</CODE> that are contained in the
   interval
<PRE>
       [first(rd) .. last(rd)]
   </PRE>
where
<PRE>
       first(rd)) = rangeStart
   </PRE>
and
<PRE>
       last(rd) = MIN (rangeEnd, MText.Length(m)) - 1]
</PRE>
<PRE>
       len(rd) = MAX (last(rd) - first(rd) + 1, 0)
</PRE>
   In a forward reader (<CODE>reverse = FALSE</CODE>), <CODE>Rd.GetChar</CODE> delivers characters
   from <CODE>start</CODE> to <CODE>last(rd)</CODE>.  <CODE>Rd.Index</CODE> returns the index relative to
   <CODE>first(rd)</CODE>.  Hence just after a forward reader <CODE>rd</CODE> is initialized,
<PRE>
       cur(rd) = start - first(rd)
</PRE>
   In a reverse reader, <CODE>Rd.GetChar</CODE> delivers characters from <CODE>start-1</CODE> (not
   <CODE>start</CODE>) to <CODE>first(rd)</CODE>.  <CODE>Rd.Index</CODE> returns the index relative to
   <CODE>last(rd)+1</CODE>.  Hence just after a reverse reader <CODE>rd</CODE> is initialized,
<PRE>
       cur(rd) = last(rd) + 1 - start
</PRE>
   Thus the value returned by <CODE>Rd.Index</CODE> increases by 1 with each call to
   <CODE>Rd.GetChar</CODE>, regardless of the reader's direction.
<P>
   The coordinate system used by <CODE>Rd.Seek</CODE> is consistent with <CODE>Rd.Index</CODE>.
<P>
   If the underlying <CODE>MText</CODE> is modified, the reader is invalid and should be
   re-initialized.   
<P>
   <CODE>rd.init</CODE> calls <CODE>Rd.Seek(rd, rd.cur)</CODE>, which can raise <CODE>Rd.Failure</CODE> or
   <CODE>Thread.Alerted</CODE>.
<P>
   Synchronization: it is not possible to have several readers reading the
   mtext concurrently.  The reason is that a read to a file node causes the
   mtext data structure to change.  If you don't use file nodes, then it's
   safe. (JRM doesn't believe this.)
<P>


<P><PRE>PROCEDURE <A HREF="MTextRd.m3#New">New</A> (m         : MText.T;
               start     : CARDINAL  := 0;
               rangeStart: CARDINAL  := 0;
               rangeEnd  : CARDINAL  := LAST (CARDINAL);
               reverse   : BOOLEAN   := FALSE            ): T
  RAISES {Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> This is equivalent to
<PRE>
      NEW (T).init (m, start, rangeStart, rangeEnd, reverse, alertable)
</EM></BLOCKQUOTE><PRE>

END MTextRd.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
