<HTML>
<HEAD>
<TITLE>SRC Modula-3: mtext/src/MTextRd.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>mtext/src/MTextRd.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="MTextRd.i3">MTextRd</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/RdClass.i3">RdClass</A>, <A HREF="MText.i3">MText</A>, <A HREF="MTextDs.i3">MTextDs</A>, <A HREF="MTextPrivate.i3">MTextPrivate</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../text/src/TextF.i3">TextF</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

FROM <A HREF="MTextPrivate.i3">MTextPrivate</A> IMPORT Node, NodeType;

CONST BufferSize = 512;

REVEAL
  <A NAME="T">T</A> = Public BRANDED &quot;MTextRd.T.2&quot; OBJECT
        m                   : MText.T;
        rangeStart, rangeEnd: CARDINAL;
        len, first          : CARDINAL;
        last                : INTEGER;
        version             : INTEGER;
        reverse             : BOOLEAN;
        chars               : REF ARRAY OF CHAR := NIL
      OVERRIDES
        length := Length;
        seek   := Seek;
        init   := Init
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (m         : MText.T  := NIL;
               start     : CARDINAL := 0;
               rangeStart: CARDINAL := 0;
               rangeEnd  : CARDINAL := LAST (CARDINAL);
               reverse   : BOOLEAN  := FALSE;           ): T
  RAISES {Rd.Failure, Thread.Alerted} =
  BEGIN
    RETURN NEW (T).init (m, start, rangeStart, rangeEnd, reverse)
  END New;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (rd        : T;
                m         : MText.T  := NIL;
                start     : CARDINAL := 0;
                rangeStart: CARDINAL := 0;
                rangeEnd  : CARDINAL := LAST (CARDINAL);
                reverse   : BOOLEAN  := FALSE            ): T
  RAISES {Rd.Failure, Thread.Alerted} =
  BEGIN
    IF m # NIL THEN rd.m := m END;
    rd.first := rangeStart;
    rd.last := MIN (rangeEnd, rd.m.length) - 1;
    rd.len := MAX (rd.last - rd.first + 1, 0);
    rd.reverse := reverse;
    rd.closed := FALSE;
    rd.seekable := TRUE;
    rd.intermittent := FALSE;
    rd.st := 0;
    rd.lo := 0;
    rd.hi := 0;
    IF rd.chars = NIL THEN
      rd.chars := NEW (REF ARRAY OF CHAR, BufferSize)
    END;
    rd.buff := rd.chars;
    IF reverse THEN
      IF rd.len = 0 THEN
        rd.cur := 0
      ELSIF start &lt; rd.first THEN
        rd.cur := rd.len
      ELSIF start &gt; rd.last THEN
        rd.cur := 0
      ELSE
        rd.cur := rd.last + 1 - start
      END
    ELSE
      IF rd.len = 0 THEN
        rd.cur := 0
      ELSIF start &lt; rd.first THEN
        rd.cur := 0
      ELSIF start &gt; rd.last THEN
        rd.cur := rd.len
      ELSE
        rd.cur := start - rd.first
      END
    END;
    Rd.Seek (rd, rd.cur);
    RETURN rd
  END Init;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A> (rd: T; n: CARDINAL; dontBlock: BOOLEAN): RdClass.SeekResult
  RAISES {Rd.Failure, Thread.Alerted} =
  BEGIN
    IF n &gt;= rd.len THEN
      rd.cur := rd.len;
      rd.lo := rd.cur;
      rd.hi := rd.cur;
      RETURN RdClass.SeekResult.Eof
    END;
    IF rd.reverse THEN
      RETURN RevSeek (rd, n, dontBlock)
    ELSE
      RETURN ForwardSeek (rd, n, dontBlock)
    END
  END Seek;

PROCEDURE <A NAME="ForwardSeek"><procedure>ForwardSeek</procedure></A> (rd: T; n: CARDINAL; &lt;* UNUSED *&gt; dontBlock: BOOLEAN):
  RdClass.SeekResult RAISES {Rd.Failure, Thread.Alerted} =
  VAR
    beginN          : Node;
    beginI, count, i: CARDINAL;
    result                     := RdClass.SeekResult.Ready;
  BEGIN
    MTextDs.LocateB (rd.m, n + rd.first, beginN, beginI);
    count := MIN (MIN (beginN.length - beginI, BufferSize), rd.len - n);
    CASE beginN.type OF
    | NodeType.text =&gt;
        SUBARRAY (rd.buff^, 0, count) :=
          SUBARRAY (beginN.text^, beginI, count);
    | NodeType.buf =&gt;
        SUBARRAY (rd.buff^, 0, count) :=
          SUBARRAY (beginN.buffer^, beginI, count);
    | NodeType.file =&gt;
        Rd.Seek (beginN.file, beginI + beginN.start);
        i := 0;
        TRY
          WHILE i &lt; count DO
            rd.buff [i] := Rd.GetChar (beginN.file);
            INC (i)
          END
        EXCEPT
          Rd.EndOfFile =&gt;
        END;
        count := i;
    ELSE                         &lt;* ASSERT FALSE *&gt;
    END;
    rd.cur := n;
    rd.lo := n;
    rd.hi := rd.lo + count;
    RETURN result
  END ForwardSeek;

PROCEDURE <A NAME="RevSeek"><procedure>RevSeek</procedure></A> (rd: T; n: CARDINAL; &lt;* UNUSED *&gt; dontBlock: BOOLEAN):
  RdClass.SeekResult RAISES {Rd.Failure, Thread.Alerted} =
  VAR
    beginN                 : Node;
    beginI, count, first, i: CARDINAL;
  PROCEDURE RevCopy (READONLY v: ARRAY OF CHAR) =
    BEGIN
      FOR i := 1 TO count DO rd.buff [count - i] := v [first + i - 1] END
    END RevCopy;
  BEGIN
    MTextDs.Locate (rd.m, rd.last + 1 - n, beginN, beginI);
    count := MIN (MIN (beginI, BufferSize), rd.len - n);
    first := beginI - count;
    CASE beginN.type OF
    | NodeType.text =&gt;
        RevCopy (SUBARRAY (beginN.text^, 0, Text.Length (beginN.text)))
    | NodeType.file =&gt;
        Rd.Seek (beginN.file, beginN.start + first);
        i := 0;
        TRY
          WHILE i &lt; count DO
            rd.buff [count - 1 - i] := Rd.GetChar (beginN.file);
            INC (i)
          END
        EXCEPT
          Rd.EndOfFile =&gt;
        END;
        count := i
    | NodeType.buf =&gt; RevCopy (beginN.buffer^)
    ELSE                         &lt;* ASSERT FALSE *&gt;
    END;
    rd.cur := n;
    rd.lo := n;
    rd.hi := rd.lo + count;
    RETURN RdClass.SeekResult.Ready
  END RevSeek;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A> (rd: T): INTEGER =
  BEGIN
    RETURN rd.len
  END Length;

BEGIN
END MTextRd.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
