<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobj/src/NetObjMon.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobj/src/NetObjMon.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> NetObjMon.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The interface <CODE>NetObjMon</CODE> provides a way of inspecting the state
   of the network object runtime at a program. 

<P><PRE>INTERFACE <interface><A HREF="#x1">NetObjMon</A></interface>;

IMPORT <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  (* a &quot;NetObjMon.T&quot; is used to query the state of the network object
     runtime, and to simulate the death of surrogate objects and remote
     program instances *)

  T = NetObj.T OBJECT METHODS
    dump (): REFANY  (* NGCMonitor.Dump *)
      RAISES {NetObj.Error, Thread.Alerted};
    dumpNames (): RefList.T (* of NGCMonitor.NDump *)
      RAISES {NetObj.Error, Thread.Alerted};
  END;
</PRE> Binding to <CODE>NetObjMon.T</CODE>s is performed via a <CODE>NetObjMon.Registry</CODE>. 

<P><PRE>TYPE
  Registry = NetObj.T OBJECT METHODS
    register (t: T; id: TEXT)
      RAISES {NetObj.Error, Thread.Alerted};
    list (): REF ARRAY OF TEXT
      RAISES {NetObj.Error, Thread.Alerted};
      (* &quot;list&quot; would return an array of &quot;(id: TEXT, t: T)&quot; pairs,
          but for the fact that if any of the owners of the &quot;t&quot;s
          are dead, it won't be possible to unmarshal {\em any} of
          the &quot;t&quot;s.  So we give a list of &quot;id&quot;s, which can be passed
          as needed to &quot;get&quot;, below. *)
    get (id: TEXT): T
      RAISES {NetObj.Error, Thread.Alerted};
  END;

CONST
  RegistryServiceName = &quot;NetObjMon.Registry&quot;;

PROCEDURE <A HREF="NetObjMon.m3#Register">Register</A> ();   (* create and register a local monitor *)

END NetObjMon.
</PRE>
</inInterface>
<HR>
<A NAME="x1">NetObjMon's implementation  is in:
</A><UL>
<LI><A HREF="NetObjMon.m3#0TOP0">netobj/src/NetObjMon.m3</A>
<LI><A HREF="NetObjMon_Registry_v1.m3#0TOP0">netobj/src/NetObjMon_Registry_v1.m3</A>
<LI><A HREF="NetObjMon_T_v1.m3#0TOP0">netobj/src/NetObjMon_T_v1.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
