<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobj/src/NetObjMon_Registry_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobj/src/NetObjMon_Registry_v1.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>NetObjMon_Registry_v1</module> EXPORTS <A HREF="NetObjMon.i3"><implements>NetObjMon</A></implements>, <A HREF="NetObjMon_Registry_v1.i3"><implements>NetObjMon_Registry_v1</A></implements>,
                                                <A HREF="NetObjMonInit.i3"><implements>NetObjMonInit</A></implements>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="NetObjMon.i3">NetObjMon</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {get, list, register};
      ReturnCodes = {OK};

  PROCEDURE <A NAME="Surrogate_register"><procedure>Surrogate_register</procedure></A>(
      self: NetObjMon.Registry;
      t_arg: NetObjMon.T;
      id_arg: TEXT) RAISES {NetObj.Error, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutCardinal(c, ORD(Methods.register));
          StubLib.OutRef(c, t_arg);
          StubLib.OutRef(c, id_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InCardinal(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_register;

  PROCEDURE <A NAME="Surrogate_list"><procedure>Surrogate_list</procedure></A>(self: NetObjMon.Registry): REF ARRAY  OF TEXT
       RAISES {NetObj.Error, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: REF ARRAY  OF TEXT;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutCardinal(c, ORD(Methods.list));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InCardinal(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, -1);
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_list;

  PROCEDURE <A NAME="Surrogate_get"><procedure>Surrogate_get</procedure></A>(self: NetObjMon.Registry; id_arg: TEXT)
      : NetObjMon.T RAISES {NetObj.Error, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: NetObjMon.T;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutCardinal(c, ORD(Methods.get));
          StubLib.OutRef(c, id_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InCardinal(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(NetObjMon.T));
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_get;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, NetObjMon.Registry);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InCardinal(c, rep) OF
      | ORD(Methods.register) =&gt; Stub_register(t, c, rep);
      | ORD(Methods.list) =&gt; Stub_list(t, c, rep);
      | ORD(Methods.get) =&gt; Stub_get(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_register"><procedure>Stub_register</procedure></A>(
    self: NetObjMon.Registry;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR t_arg: NetObjMon.T;
      id_arg: TEXT;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    t_arg := StubLib.InRef(c, rep, TYPECODE(NetObjMon.T));
    id_arg := StubLib.InRef(c, rep, -1);
    self.register(t_arg, id_arg);
    StubLib.StartResult(c);
    StubLib.OutCardinal(c, ORD(ReturnCodes.OK));

  END Stub_register;

PROCEDURE <A NAME="Stub_list"><procedure>Stub_list</procedure></A>(
    self: NetObjMon.Registry;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: REF ARRAY  OF TEXT;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.list();
    StubLib.StartResult(c);
    StubLib.OutCardinal(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_list;

PROCEDURE <A NAME="Stub_get"><procedure>Stub_get</procedure></A>(
    self: NetObjMon.Registry;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR id_arg: TEXT;
      res: NetObjMon.T;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    id_arg := StubLib.InRef(c, rep, -1);
    res := self.get(id_arg);
    StubLib.StartResult(c);
    StubLib.OutCardinal(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_get;

PROCEDURE <A NAME="InitRegistryStubs"><procedure>InitRegistryStubs</procedure></A>() =
  BEGIN
    StubLib.Register(TYPECODE(NetObjMon.Registry), 1, TYPECODE(Surrogate_NetObjMon_Registry), Invoke);
  END InitRegistryStubs;

BEGIN
END NetObjMon_Registry_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
