<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobj/src/NetObjMon_T_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobj/src/NetObjMon_T_v1.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>NetObjMon_T_v1</module> EXPORTS <A HREF="NetObjMon.i3"><implements>NetObjMon</A></implements>, <A HREF="NetObjMon_T_v1.i3"><implements>NetObjMon_T_v1</A></implements>, <A HREF="NetObjMonInit.i3"><implements>NetObjMonInit</A></implements>;

IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="NetObjMon.i3">NetObjMon</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {dumpNames, dump};
      ReturnCodes = {OK};

  PROCEDURE <A NAME="Surrogate_dump"><procedure>Surrogate_dump</procedure></A>(self: NetObjMon.T): REFANY RAISES {NetObj.Error,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: REFANY;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutCardinal(c, ORD(Methods.dump));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InCardinal(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, -1);
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_dump;

  PROCEDURE <A NAME="Surrogate_dumpNames"><procedure>Surrogate_dumpNames</procedure></A>(self: NetObjMon.T): RefList.T
       RAISES {NetObj.Error, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: RefList.T;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutCardinal(c, ORD(Methods.dumpNames));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InCardinal(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(RefList.T));
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_dumpNames;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, NetObjMon.T);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InCardinal(c, rep) OF
      | ORD(Methods.dump) =&gt; Stub_dump(t, c, rep);
      | ORD(Methods.dumpNames) =&gt; Stub_dumpNames(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_dump"><procedure>Stub_dump</procedure></A>(
    self: NetObjMon.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: REFANY;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.dump();
    StubLib.StartResult(c);
    StubLib.OutCardinal(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_dump;

PROCEDURE <A NAME="Stub_dumpNames"><procedure>Stub_dumpNames</procedure></A>(
    self: NetObjMon.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: RefList.T;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.dumpNames();
    StubLib.StartResult(c);
    StubLib.OutCardinal(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_dumpNames;

PROCEDURE <A NAME="InitMonitorStubs"><procedure>InitMonitorStubs</procedure></A>() =
  BEGIN
    StubLib.Register(TYPECODE(NetObjMon.T), 1, TYPECODE(Surrogate_NetObjMon_T), Invoke);
  END InitMonitorStubs;

BEGIN
END NetObjMon_T_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
