<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/Example.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/Example.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Example.i3 </EM></BLOCKQUOTE><PRE>
</PRE> This is an example of an interface that defines a network object type. 

<P><PRE>INTERFACE <interface><A HREF="Example.m3">Example</A></interface>;

IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

EXCEPTION Invalid;

TYPE
  T = NetObj.T OBJECT METHODS
     get(key: TEXT) : TEXT
       RAISES {Invalid, NetObj.Error, Thread.Alerted};
     put(key: TEXT; value: TEXT)
       RAISES {Invalid, NetObj.Error, Thread.Alerted};
  END;

END Example.
</PRE> Notice that the object methods must raise <CODE>NetObj.Error</CODE> or else 
   communications failures will be treated as checked runtime errors.  
   Also notice that <CODE>Thread.Alerted</CODE> is present in the <CODE>RAISES</CODE> clause 
   of all methods.  This is not required, but is strongly advised.  
   If <CODE>Thread.Alerted</CODE> is not propagated then not only is it impossible 
   to alert remote invocations, but the server implementation must 
   guarantee that <CODE>Alerted</CODE> will never be raised.  This guarantee 
   must hold even though the network object runtime uses <CODE>Thread.Alert</CODE> 
   to recover server threads when the client address space dies. 

</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
