<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/Example.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/Example.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Example.m3 </EM></BLOCKQUOTE><PRE>
</PRE> This module is an example of a hand-coded stub. 

<P><PRE>MODULE <module><implements><A HREF="#x1">Example</A></implements></module>;

IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="StubLib.i3">StubLib</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

TYPE
  P = { Get, Put };  R = { OK, Invalid };
</PRE> The enumerated types <CODE>P</CODE> and <CODE>R</CODE> define values to be 
   associated with the methods of <CODE>T</CODE> and with the various results 
   (normal return or exception) of these methods. 
 
<P><PRE>TYPE
  StubT = T OBJECT
  OVERRIDES
    get := SurrogateGet;
    put := SurrogatePut;
  END;
</PRE> The type <CODE>StubT</CODE> is the surrogate object type for <CODE>T</CODE>.  It provides 
   method overrides that perform remote invocation. 

<P><PRE>CONST StubVersion = StubLib.SystemStubProtocol;
</PRE> This constant will be set by the stub generator to denote the
   stub generator version that created a given stub. 

<P><PRE>PROCEDURE <A NAME="SurrogateGet"><procedure>SurrogateGet</procedure></A> (t: StubT; key: TEXT) : TEXT
    RAISES {Invalid, NetObj.Error, Thread.Alerted} =
  VAR reuse := FALSE;
      rep: StubLib.DataRep;
      c: StubLib.Conn;
      res: TEXT;
  BEGIN
    TRY
      c := StubLib.StartCall(t, StubVersion);
      TRY
        StubLib.OutInt32(c, ORD(P.Get));
        StubLib.OutRef(c, key);
        rep := StubLib.AwaitResult(c);
        CASE StubLib.InInt32(c, rep) OF
        | ORD(R.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(TEXT));
            reuse := TRUE;
        | ORD(R.Invalid) =&gt;
            reuse := TRUE;
            RAISE Invalid;
        ELSE
            StubLib.RaiseUnmarshalFailure();
        END;
      FINALLY
        StubLib.EndCall(c, reuse);
      END;
    EXCEPT
    | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
    | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
    END;
    RETURN res;
  END SurrogateGet;

PROCEDURE <A NAME="SurrogatePut"><procedure>SurrogatePut</procedure></A> (t: StubT; key: TEXT; value: TEXT)
    RAISES {Invalid, NetObj.Error, Thread.Alerted} =
  VAR reuse := FALSE;
      rep: StubLib.DataRep;
      c: StubLib.Conn;
  BEGIN
    TRY
      c := StubLib.StartCall(t, StubVersion);
      TRY
        StubLib.OutInt32(c, ORD(P.Put));
        StubLib.OutRef(c, key);
        StubLib.OutRef(c, value);
        rep := StubLib.AwaitResult(c);
        CASE StubLib.InInt32(c, rep) OF
        | ORD(R.OK) =&gt;
            reuse := TRUE;
        | ORD(R.Invalid) =&gt;
            reuse := TRUE;
            RAISE Invalid;
        ELSE
            StubLib.RaiseUnmarshalFailure();
        END;
      FINALLY
        StubLib.EndCall(c, reuse);
      END;
    EXCEPT
    | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
    | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
    END;
  END SurrogatePut;
</PRE> <CODE>Invoke</CODE> is the server stub dispatcher for <CODE>T</CODE>.  It is called when 
    the network object runtime receives a method invocation for an 
    object of type <CODE>T</CODE>. 

<P><PRE>PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    &lt;*UNUSED*&gt; stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, T);
  BEGIN
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(P.Get) =&gt; GetStub(c, t, rep);
      | ORD(P.Put) =&gt; PutStub(c, t, rep);
      ELSE StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | Invalid =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(R.Invalid));
    END;
  END Invoke;
</PRE> There is one server side stub procedure for each method of <CODE>T</CODE>. 

<P><PRE>PROCEDURE <A NAME="GetStub"><procedure>GetStub</procedure></A> (
    c: StubLib.Conn;
    t: T;
    rep: StubLib.DataRep)
    RAISES {Invalid, NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR key, res: TEXT;
  BEGIN
    key := StubLib.InRef(c, rep, TYPECODE(TEXT));
    res := t.get(key);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(R.OK));
    StubLib.OutRef(c, res);
  END GetStub;

PROCEDURE <A NAME="PutStub"><procedure>PutStub</procedure></A> (
    c: StubLib.Conn;
    t: T;
    rep: StubLib.DataRep)
    RAISES {Invalid, NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR
    key, value: TEXT;
  BEGIN
    key := StubLib.InRef(c, rep, TYPECODE(TEXT));
    value := StubLib.InRef(c, rep, TYPECODE(TEXT));
    t.put(key, value);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(R.OK));
  END PutStub;
</PRE> All stub code is registered with the network object runtime by 
   the main body of the stub module.  The protocol number is set
   to the stub protocol constant defined above. 

<P><PRE>BEGIN
  StubLib.Register(
    TYPECODE(T), StubVersion,
    TYPECODE(StubT), Invoke);
END Example.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Example is in:
</A><UL>
<LI><A HREF="../../m3tk/src/files/Common/Example.i3#0TOP0">m3tk/src/files/Common/Example.i3</A>
<LI><A HREF="Example.i3#0TOP0">netobjrt/src/Example.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
