<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/NGCMonitor.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/NGCMonitor.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> NGCMonitor.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The interface <CODE>NGCMonitor</CODE> provides a way of inspecting the state
   of the network object runtime at a program. 

<P><PRE>INTERFACE <interface><A HREF="NetObjRT.m3">NGCMonitor</A></interface>;

IMPORT <A HREF="WireRep.i3">WireRep</A>, <A HREF="DirtyElem.i3">DirtyElem</A>, <A HREF="../../fingerprint/src/Fingerprint.i3">Fingerprint</A>, <A HREF="Transport.i3">Transport</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>;

TYPE
  (* A value of type &quot;Dump&quot; is a snapshot of the state of the network
     object garbage collector in some program. *)

  Dump = REF RECORD
    concs: RefList.T (* of CDump *) := NIL;
    srgts: RefList.T (* of SDump *) := NIL;
    locs:  RefList.T (* of LDump *) := NIL;
  END;

  ODump = OBJECT
    obj: WireRep.T;
    fp: Fingerprint.T;
    typeName: TEXT;
  END;

  CDump = ODump OBJECT
    pinCount: CARDINAL;
  END;

  SDump = ODump OBJECT
    owner: Transport.Endpoint;
  END;

  LDump = REF RECORD
    info: TEXT;
    ep: Transport.Endpoint;
    exports: RefList.T (* of DDump *) := NIL;
  END;

  DDump = REF RECORD
    wrep: WireRep.T;
    de: DirtyElem.T;
  END;

  NDump = REF RECORD
    name: TEXT;    (* in export table *)
    obj: WireRep.T;
  END;

PROCEDURE <A HREF="NetObjRT.m3#MonitorDump">MonitorDump</A>() : Dump;
  (* return snapshot of local network object state *)

PROCEDURE <A HREF="NetObjRT.m3#MonitorDumpNames">MonitorDumpNames</A>() : RefList.T (*of NDump*);
  (* return snapshot of local agent table *)

END NGCMonitor.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
